/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.application.provider;

import com.yahoo.config.application.ConfigDefinitionDir;
import com.yahoo.config.application.XmlPreProcessor;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.model.application.provider.AppSubDirs;
import com.yahoo.config.model.application.provider.Bundle;
import com.yahoo.config.model.application.provider.FilesApplicationPackage;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.config.provision.Zone;
import com.yahoo.io.IOUtils;
import com.yahoo.path.Path;
import com.yahoo.text.XML;
import com.yahoo.yolean.Exceptions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

class ApplicationPackagePreprocessor {
    private final FilesApplicationPackage applicationPackage;
    private final TransformerFactory transformerFactory = XML.createTransformerFactory();
    private final File preprocessedDir;
    private final boolean includeSourceFiles;
    private final Map<String, FilesApplicationPackage> inheritableApplications;

    ApplicationPackagePreprocessor(FilesApplicationPackage applicationPackage, Optional<File> preprocessedDir, boolean includeSourceFiles, Map<String, FilesApplicationPackage> inheritableApplications) {
        this.applicationPackage = applicationPackage;
        this.includeSourceFiles = includeSourceFiles;
        this.preprocessedDir = preprocessedDir.orElse(FilesApplicationPackage.fileUnder(applicationPackage.getAppDir(), Path.fromString((String)".preprocessed")));
        this.inheritableApplications = inheritableApplications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationPackage preprocess(Zone zone) throws IOException {
        java.nio.file.Path tempDir = null;
        try {
            tempDir = Files.createTempDirectory(this.applicationPackage.getAppDir().getParentFile().toPath(), "preprocess-tempdir", new FileAttribute[0]);
            this.preprocess(this.applicationPackage.getAppDir(), tempDir.toFile(), zone);
            IOUtils.recursiveDeleteDir((File)this.preprocessedDir);
            Files.move(tempDir, this.preprocessedDir.toPath(), new CopyOption[0]);
            tempDir = null;
        }
        catch (AccessDeniedException | DirectoryNotEmptyException e) {
            this.preprocess(this.applicationPackage.getAppDir(), this.preprocessedDir, zone);
        }
        finally {
            if (tempDir != null) {
                IOUtils.recursiveDeleteDir((File)tempDir.toFile());
            }
        }
        FilesApplicationPackage preprocessedApp = FilesApplicationPackage.fromDir(this.preprocessedDir, this.includeSourceFiles, this.inheritableApplications);
        ApplicationPackagePreprocessor.copyUserDefsIntoApplication(preprocessedApp);
        return preprocessedApp;
    }

    private void preprocess(File appDir, File dir, Zone zone) throws IOException {
        this.validateServicesFile();
        IOUtils.copyDirectory((File)appDir, (File)dir, (int)-1, (__, name) -> !List.of(".preprocessed", "services.xml", "hosts.xml", "configdefinitions").contains(name));
        this.preprocessXML(FilesApplicationPackage.fileUnder(dir, Path.fromString((String)"services.xml")), this.applicationPackage.applicationFile("services.xml"), zone);
        this.preprocessXML(FilesApplicationPackage.fileUnder(dir, Path.fromString((String)"hosts.xml")), this.applicationPackage.applicationFile("hosts.xml"), zone);
    }

    private void preprocessXML(File destination, File inputXml, Zone zone) throws IOException {
        if (!inputXml.exists()) {
            return;
        }
        try {
            InstanceName instance = this.applicationPackage.getMetaData().getApplicationId().instance();
            Document document = new XmlPreProcessor(this.applicationPackage.getAppDir(), inputXml, instance, zone.environment(), zone.region(), zone.cloud().name(), this.applicationPackage.getDeploymentSpec().tags(instance, zone.environment())).run();
            try (FileOutputStream outputStream = new FileOutputStream(destination);){
                this.transformerFactory.newTransformer().transform(new DOMSource(document), new StreamResult(outputStream));
            }
        }
        catch (ParserConfigurationException | TransformerException | SAXException e) {
            throw new RuntimeException("Error preprocessing " + inputXml.getPath() + ": " + e.getMessage(), e);
        }
    }

    private void validateServicesFile() throws IOException {
        File servicesFile = this.applicationPackage.applicationFile("services.xml");
        if (!servicesFile.exists()) {
            throw new IllegalArgumentException("services.xml does not exist in application package. There are " + this.filesInApplicationPackage() + " files in the directory");
        }
        if (IOUtils.readFile((File)servicesFile).isEmpty()) {
            throw new IllegalArgumentException("services.xml in application package is empty. There are " + this.filesInApplicationPackage() + " files in the directory");
        }
    }

    private long filesInApplicationPackage() {
        return (Long)Exceptions.uncheck(() -> {
            try (Stream<java.nio.file.Path> files = Files.list(this.applicationPackage.getAppDir().toPath());){
                Long l = files.count();
                return l;
            }
        });
    }

    private static void copyUserDefsIntoApplication(FilesApplicationPackage applicationPackage) {
        File destination = new AppSubDirs(applicationPackage.getAppDir()).configDefs();
        destination.mkdir();
        ConfigDefinitionDir defDir = new ConfigDefinitionDir(destination);
        ArrayList<Bundle> bundlesAdded = new ArrayList<Bundle>();
        for (Bundle bundle : applicationPackage.getBundles()) {
            defDir.addConfigDefinitionsFromBundle(bundle, bundlesAdded);
            bundlesAdded.add(bundle);
        }
    }
}

