/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.application.provider;

import com.yahoo.io.HexDump;
import com.yahoo.text.Lowercase;
import com.yahoo.text.Utf8;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

class ApplicationChecksum {
    private final String checksum;

    ApplicationChecksum(File appDir) {
        this.checksum = ApplicationChecksum.computeChecksum(appDir);
    }

    public String asString() {
        return this.checksum;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ApplicationChecksum)) {
            return false;
        }
        ApplicationChecksum other = (ApplicationChecksum)o;
        return other.checksum.equals(this.checksum);
    }

    public int hashCode() {
        return this.checksum.hashCode();
    }

    public String toString() {
        return "Application checksum: " + this.checksum;
    }

    private static String computeChecksum(File appDir) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            for (File file : appDir.listFiles((dir, name) -> !name.equals("ext") && !name.startsWith("."))) {
                ApplicationChecksum.addPathToDigest(file, "", md5, true, false);
            }
            return Lowercase.toLowerCase((String)HexDump.toHexString((byte[])md5.digest()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void addPathToDigest(File path, String suffix, MessageDigest digest, boolean recursive, boolean fullPathNames) throws IOException {
        File[] files;
        if (!path.exists()) {
            return;
        }
        if (fullPathNames) {
            digest.update(path.getPath().getBytes(Utf8.getCharset()));
        } else {
            digest.update(path.getName().getBytes(Utf8.getCharset()));
        }
        if (path.isFile()) {
            FileInputStream is = new FileInputStream(path);
            ApplicationChecksum.addToDigest(is, digest);
            is.close();
        } else if (path.isDirectory() && (files = path.listFiles()) != null) {
            for (File elem : files) {
                if ((!elem.isDirectory() || !recursive) && !elem.getName().endsWith(suffix)) continue;
                ApplicationChecksum.addPathToDigest(elem, suffix, digest, recursive, fullPathNames);
            }
        }
    }

    private static void addToDigest(InputStream is, MessageDigest digest) throws IOException {
        int i;
        if (is == null) {
            return;
        }
        byte[] buffer = new byte[65536];
        do {
            if ((i = is.read(buffer)) <= 0) continue;
            digest.update(buffer, 0, i);
        } while (i != -1);
    }
}

