/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.application.provider;

import com.yahoo.component.Version;
import com.yahoo.component.Vtag;
import com.yahoo.config.application.ConfigDefinitionDir;
import com.yahoo.config.application.Xml;
import com.yahoo.config.application.XmlPreProcessor;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationMetaData;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.ComponentInfo;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.DeploymentSpec;
import com.yahoo.config.application.api.UnparsedConfigDefinition;
import com.yahoo.config.codegen.CNode;
import com.yahoo.config.codegen.DefParser;
import com.yahoo.config.model.application.AbstractApplicationPackage;
import com.yahoo.config.model.application.provider.AppSubDirs;
import com.yahoo.config.model.application.provider.ApplicationPackageXmlFilesValidator;
import com.yahoo.config.model.application.provider.Bundle;
import com.yahoo.config.model.application.provider.DeployData;
import com.yahoo.config.model.application.provider.FilesApplicationFile;
import com.yahoo.config.model.application.provider.IncludeDirs;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.ApplicationName;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.io.HexDump;
import com.yahoo.io.IOUtils;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.path.Path;
import com.yahoo.text.Lowercase;
import com.yahoo.text.Utf8;
import com.yahoo.text.XML;
import com.yahoo.vespa.config.ConfigDefinition;
import com.yahoo.vespa.config.ConfigDefinitionBuilder;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.util.ConfigUtils;
import com.yahoo.yolean.Exceptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FilesApplicationPackage
extends AbstractApplicationPackage {
    public static final String preprocessed = ".preprocessed";
    private static final Logger log = Logger.getLogger(FilesApplicationPackage.class.getName());
    private static final String META_FILE_NAME = ".applicationMetaData";
    private static final Map<Path, Set<String>> validFileExtensions = Map.ofEntries(Map.entry(Path.fromString((String)"components"), Set.of(".jar")), Map.entry(CONSTANTS_DIR, Set.of(".json", ".json.lz4")), Map.entry(Path.fromString((String)"docproc/chains"), Set.of(".xml")), Map.entry(PAGE_TEMPLATES_DIR, Set.of(".xml")), Map.entry(Path.fromString((String)"processor/chains"), Set.of(".xml")), Map.entry(QUERY_PROFILES_DIR, Set.of(".xml")), Map.entry(QUERY_PROFILE_TYPES_DIR, Set.of(".xml")), Map.entry(Path.fromString((String)"routing/tables"), Set.of(".xml")), Map.entry(RULES_DIR, Set.of(".sr")), Map.entry(SCHEMAS_DIR, Set.of(".sd", ".expression", ".profile")), Map.entry(Path.fromString((String)"search/chains"), Set.of(".xml")), Map.entry(SEARCH_DEFINITIONS_DIR, Set.of(".sd", ".expression", ".profile")), Map.entry(SECURITY_DIR, Set.of(".pem")));
    private final File appDir;
    private final File preprocessedDir;
    private final File configDefsDir;
    private final AppSubDirs appSubDirs;
    private final List<String> userIncludeDirs = new ArrayList<String>();
    private final ApplicationMetaData metaData;
    private final boolean includeSourceFiles;
    private final TransformerFactory transformerFactory;
    private DeploymentSpec deploymentSpec = null;
    private static final int MD5_BUFFER_SIZE = 65536;

    public static FilesApplicationPackage fromFile(File appDir) {
        return FilesApplicationPackage.fromFile(appDir, false);
    }

    public static FilesApplicationPackage fromFile(File appDir, boolean includeSourceFiles) {
        return new Builder(appDir).preprocessedDir(FilesApplicationPackage.applicationFile(appDir, preprocessed)).includeSourceFiles(includeSourceFiles).build();
    }

    public static FilesApplicationPackage fromFileWithDeployData(File appDir, DeployData deployData) {
        return FilesApplicationPackage.fromFileWithDeployData(appDir, deployData, false);
    }

    public static FilesApplicationPackage fromFileWithDeployData(File appDir, DeployData deployData, boolean includeSourceFiles) {
        return new Builder(appDir).includeSourceFiles(includeSourceFiles).deployData(deployData).build();
    }

    private static ApplicationMetaData metaDataFromDeployData(File appDir, DeployData deployData) {
        return new ApplicationMetaData(Long.valueOf(deployData.getDeployTimestamp()), deployData.isInternalRedeploy(), deployData.getApplicationId(), FilesApplicationPackage.computeCheckSum(appDir), Long.valueOf(deployData.getGeneration()), deployData.getCurrentlyActiveGeneration());
    }

    private FilesApplicationPackage(File appDir, File preprocessedDir, ApplicationMetaData metaData, boolean includeSourceFiles) {
        this.verifyAppDir(appDir);
        this.includeSourceFiles = includeSourceFiles;
        this.appDir = appDir;
        this.preprocessedDir = preprocessedDir;
        this.appSubDirs = new AppSubDirs(appDir);
        this.configDefsDir = FilesApplicationPackage.applicationFile(appDir, "configdefinitions");
        this.addUserIncludeDirs();
        this.metaData = metaData;
        this.transformerFactory = XML.createTransformerFactory();
    }

    public ApplicationId getApplicationId() {
        return this.metaData.getApplicationId();
    }

    public List<NamedReader> getFiles(Path relativePath, String suffix, boolean recurse) {
        return this.getFiles(relativePath, "", suffix, recurse);
    }

    public ApplicationFile getFile(Path path) {
        File file = path.isRoot() ? this.appDir : FilesApplicationPackage.applicationFile(this.appDir, path.getRelative());
        return new FilesApplicationFile(path, file);
    }

    public ApplicationMetaData getMetaData() {
        return this.metaData;
    }

    private List<NamedReader> getFiles(Path relativePath, String namePrefix, String suffix, boolean recurse) {
        try {
            ArrayList<NamedReader> readers = new ArrayList<NamedReader>();
            File dir = FilesApplicationPackage.applicationFile(this.appDir, relativePath);
            if (!dir.isDirectory()) {
                return readers;
            }
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        if (!recurse) continue;
                        readers.addAll(this.getFiles(relativePath.append(file.getName()), namePrefix + "/" + file.getName(), suffix, recurse));
                        continue;
                    }
                    if (suffix != null && !file.getName().endsWith(suffix)) continue;
                    readers.add(new NamedReader(file.getName(), (Reader)new FileReader(file)));
                }
            }
            return readers;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open (all) files in '" + String.valueOf(relativePath) + "'", e);
        }
    }

    private void verifyAppDir(File appDir) {
        Objects.requireNonNull(appDir, "Path cannot be null");
        if (!appDir.exists()) {
            throw new IllegalArgumentException("Path '" + String.valueOf(appDir) + "' does not exist");
        }
        if (!appDir.isDirectory()) {
            throw new IllegalArgumentException("Path '" + String.valueOf(appDir) + "' is not a directory");
        }
        if (!appDir.canRead()) {
            throw new IllegalArgumentException("Cannot read from application directory '" + String.valueOf(appDir) + "'");
        }
    }

    public Reader getHosts() {
        try {
            File hostsFile = this.getHostsFile();
            if (!hostsFile.exists()) {
                return null;
            }
            return new FileReader(hostsFile);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getHostSource() {
        return this.getHostsFile().getPath();
    }

    private File getHostsFile() {
        return FilesApplicationPackage.applicationFile(this.appDir, "hosts.xml");
    }

    public String getServicesSource() {
        return this.getServicesFile().getPath();
    }

    private File getServicesFile() {
        return FilesApplicationPackage.applicationFile(this.appDir, "services.xml");
    }

    public Optional<Reader> getDeployment() {
        return this.optionalFile(DEPLOYMENT_FILE);
    }

    public Optional<Reader> getValidationOverrides() {
        return this.optionalFile(VALIDATION_OVERRIDES);
    }

    private Optional<Reader> optionalFile(Path filePath) {
        try {
            return Optional.of(this.getFile(filePath).createReader());
        }
        catch (FileNotFoundException e) {
            return Optional.empty();
        }
    }

    public List<String> getUserIncludeDirs() {
        return Collections.unmodifiableList(this.userIncludeDirs);
    }

    public void addUserIncludeDirs() {
        Document services;
        try {
            services = Xml.getDocument(this.getServices());
        }
        catch (Exception e) {
            return;
        }
        NodeList includeNodes = services.getElementsByTagName("include");
        for (int i = 0; i < includeNodes.getLength(); ++i) {
            Node includeNode = includeNodes.item(i);
            this.addIncludeDir(includeNode);
        }
    }

    private void addIncludeDir(Node includeNode) {
        if (!(includeNode instanceof Element)) {
            return;
        }
        Element include = (Element)includeNode;
        if (!include.hasAttribute("dir")) {
            return;
        }
        String dir = include.getAttribute("dir");
        this.validateIncludeDir(dir);
        IncludeDirs.validateFilesInIncludedDir(dir, include.getParentNode(), this);
        log.log(Level.FINE, () -> "Adding user include dir '" + dir + "'");
        this.userIncludeDirs.add(dir);
    }

    public void validateIncludeDir(String dirName) {
        IncludeDirs.validateIncludeDir(dirName, this);
    }

    public Collection<NamedReader> getSchemas() {
        LinkedHashSet<NamedReader> ret = new LinkedHashSet<NamedReader>();
        try {
            for (File f : this.getSearchDefinitionFiles()) {
                ret.add(new NamedReader(f.getName(), (Reader)new FileReader(f)));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't get schema contents.", e);
        }
        return ret;
    }

    private Reader retrieveConfigDefReader(File defPath) {
        try {
            return new NamedReader(defPath.getPath(), (Reader)new FileReader(defPath));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read config definition file '" + String.valueOf(defPath) + "'", e);
        }
    }

    public Map<ConfigDefinitionKey, UnparsedConfigDefinition> getAllExistingConfigDefs() {
        LinkedHashMap<ConfigDefinitionKey, UnparsedConfigDefinition> defs = new LinkedHashMap<ConfigDefinitionKey, UnparsedConfigDefinition>();
        this.addAllDefsFromConfigDir(defs, this.configDefsDir);
        if (this.includeSourceFiles) {
            this.addAllDefsFromConfigDir(defs, new File("src/main/resources/configdefinitions"));
            this.addAllDefsFromConfigDir(defs, new File("src/test/resources/configdefinitions"));
        }
        this.addAllDefsFromBundles(defs, FilesApplicationPackage.getComponents(this.appDir));
        return defs;
    }

    private void addAllDefsFromBundles(Map<ConfigDefinitionKey, UnparsedConfigDefinition> defs, List<Component> components) {
        for (Component component : components) {
            Bundle bundle = component.getBundle();
            for (final Bundle.DefEntry def : bundle.getDefEntries()) {
                final ConfigDefinitionKey defKey = new ConfigDefinitionKey(def.defName, def.defNamespace);
                if (defs.containsKey(defKey)) continue;
                defs.put(defKey, new UnparsedConfigDefinition(){

                    public ConfigDefinition parse() {
                        DefParser parser = new DefParser(defKey.getName(), (Reader)new StringReader(def.contents));
                        return ConfigDefinitionBuilder.createConfigDefinition((CNode)parser.getTree());
                    }

                    public String getUnparsedContent() {
                        return def.contents;
                    }
                });
            }
        }
    }

    private void addAllDefsFromConfigDir(Map<ConfigDefinitionKey, UnparsedConfigDefinition> defs, File configDefsDir) {
        if (!configDefsDir.isDirectory()) {
            return;
        }
        log.log(Level.FINE, () -> "Getting all config definitions from '" + String.valueOf(configDefsDir) + "'");
        for (final File def : configDefsDir.listFiles((dir, name) -> name.matches(".*\\.def"))) {
            ConfigDefinitionKey key;
            String[] nv = def.getName().split("\\.def");
            try {
                key = ConfigUtils.createConfigDefinitionKeyFromDefFile((File)def);
            }
            catch (IOException e) {
                e.printStackTrace();
                break;
            }
            if (key.getNamespace().isEmpty()) {
                throw new IllegalArgumentException("Config definition '" + String.valueOf(def) + "' has no namespace");
            }
            if (defs.containsKey(key)) {
                if (nv[0].contains(".")) {
                    log.log(Level.INFO, "Two config definitions found for the same name and namespace: " + String.valueOf(key) + ". The file '" + String.valueOf(def) + "' will take precedence");
                } else {
                    log.log(Level.INFO, "Two config definitions found for the same name and namespace: " + String.valueOf(key) + ". Skipping '" + String.valueOf(def) + "', as it does not contain namespace in filename");
                    continue;
                }
            }
            defs.put(key, new UnparsedConfigDefinition(){

                public ConfigDefinition parse() {
                    DefParser parser = new DefParser(key.getName(), FilesApplicationPackage.this.retrieveConfigDefReader(def));
                    return ConfigDefinitionBuilder.createConfigDefinition((CNode)parser.getTree());
                }

                public String getUnparsedContent() {
                    return FilesApplicationPackage.this.readConfigDefinition(def);
                }
            });
        }
    }

    private String readConfigDefinition(File defPath) {
        String string;
        block8: {
            Reader reader = this.retrieveConfigDefReader(defPath);
            try {
                string = IOUtils.readAll((Reader)reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading config definition '" + String.valueOf(defPath) + "'", e);
                }
            }
            reader.close();
        }
        return string;
    }

    public Reader getServices() {
        try {
            return new FileReader(this.getServicesSource());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    static List<File> getSearchDefinitionFiles(File appDir) {
        ArrayList<File> schemaFiles = new ArrayList<File>();
        File sdDir = FilesApplicationPackage.applicationFile(appDir, SEARCH_DEFINITIONS_DIR.getRelative());
        if (sdDir.isDirectory()) {
            schemaFiles.addAll(List.of(sdDir.listFiles((dir, name) -> FilesApplicationPackage.validSchemaFilename(name))));
        }
        if ((sdDir = FilesApplicationPackage.applicationFile(appDir, SCHEMAS_DIR.getRelative())).isDirectory()) {
            schemaFiles.addAll(List.of(sdDir.listFiles((dir, name) -> FilesApplicationPackage.validSchemaFilename(name))));
        }
        return schemaFiles;
    }

    public List<File> getSearchDefinitionFiles() {
        return FilesApplicationPackage.getSearchDefinitionFiles(this.appDir);
    }

    public static List<Component> getComponents(File appDir) {
        return FilesApplicationPackage.components(appDir, Component::new);
    }

    private static List<ComponentInfo> getComponentsInfo(File appDir) {
        return FilesApplicationPackage.components(appDir, (__, info) -> info);
    }

    private static <T> List<T> components(File appDir, BiFunction<Bundle, ComponentInfo, T> toValue) {
        ArrayList<T> components = new ArrayList<T>();
        for (Bundle bundle : Bundle.getBundles(FilesApplicationPackage.applicationFile(appDir, "components"))) {
            components.add(toValue.apply(bundle, new ComponentInfo(Path.fromString((String)"components").append(bundle.getFile().getName()).getRelative())));
        }
        return components;
    }

    public List<ComponentInfo> getComponentsInfo(Version vespaVersion) {
        return FilesApplicationPackage.getComponentsInfo(this.appDir);
    }

    public List<Component> getComponents() {
        return FilesApplicationPackage.getComponents(this.appDir);
    }

    public File getAppDir() throws IOException {
        return this.appDir.getCanonicalFile();
    }

    private static ApplicationMetaData readMetaData(File appDir) {
        ApplicationMetaData applicationMetaData;
        String originalAppDir = preprocessed.equals(appDir.getName()) ? appDir.getParentFile().getName() : appDir.getName();
        ApplicationMetaData defaultMetaData = new ApplicationMetaData(Long.valueOf(0L), false, ApplicationId.from((TenantName)TenantName.defaultName(), (ApplicationName)ApplicationName.from((String)originalAppDir), (InstanceName)InstanceName.defaultName()), "", Long.valueOf(0L), 0L);
        File metaFile = FilesApplicationPackage.applicationFile(appDir, META_FILE_NAME);
        if (!metaFile.exists()) {
            return defaultMetaData;
        }
        FileReader reader = new FileReader(metaFile);
        try {
            applicationMetaData = ApplicationMetaData.fromJsonString((String)IOUtils.readAll((Reader)reader));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return defaultMetaData;
            }
        }
        reader.close();
        return applicationMetaData;
    }

    public Reader getRankingExpression(String name) {
        try {
            return IOUtils.createReader((File)this.expressionFileNameToFile(name), (String)"utf-8");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read ranking expression file '" + name + "'", e);
        }
    }

    private File expressionFileNameToFile(String name) {
        if (new File(name).isAbsolute()) {
            throw new IllegalArgumentException("Absolute path to ranking expression file is not allowed: " + name);
        }
        Path path = Path.fromString((String)name);
        File expressionFile = FilesApplicationPackage.applicationFile(this.appDir, SCHEMAS_DIR.append(path));
        if (!expressionFile.exists()) {
            expressionFile = FilesApplicationPackage.applicationFile(this.appDir, SEARCH_DEFINITIONS_DIR.append(path));
        }
        return expressionFile;
    }

    public File getFileReference(Path pathRelativeToAppDir) {
        return FilesApplicationPackage.applicationFile(this.appDir, pathRelativeToAppDir.getRelative());
    }

    public void validateXML() throws IOException {
        this.validateXMLFor(Optional.empty());
    }

    public void validateXMLFor(Optional<Version> vespaVersion) throws IOException {
        Version modelVersion = vespaVersion.orElse(Vtag.currentVersion);
        ApplicationPackageXmlFilesValidator validator = ApplicationPackageXmlFilesValidator.create(this.appDir, modelVersion);
        validator.checkApplication();
        validator.checkIncludedDirs(this);
    }

    public void writeMetaData() {
        File metaFile = FilesApplicationPackage.applicationFile(this.appDir, META_FILE_NAME);
        IOUtils.writeFile((File)metaFile, (byte[])this.metaData.asJsonBytes());
    }

    public DeploymentSpec getDeploymentSpec() {
        if (this.deploymentSpec != null) {
            return this.deploymentSpec;
        }
        this.deploymentSpec = this.parseDeploymentSpec(false);
        return this.deploymentSpec;
    }

    private void preprocessXML(File destination, File inputXml, Zone zone) throws IOException {
        if (!inputXml.exists()) {
            return;
        }
        try {
            InstanceName instance = this.metaData.getApplicationId().instance();
            Document document = new XmlPreProcessor(this.appDir, inputXml, instance, zone.environment(), zone.region(), zone.cloud().name(), this.getDeploymentSpec().tags(instance, zone.environment())).run();
            try (FileOutputStream outputStream = new FileOutputStream(destination);){
                this.transformerFactory.newTransformer().transform(new DOMSource(document), new StreamResult(outputStream));
            }
        }
        catch (ParserConfigurationException | TransformerException | SAXException e) {
            throw new RuntimeException("Error preprocessing " + inputXml.getAbsolutePath() + ": " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationPackage preprocess(Zone zone, DeployLogger logger) throws IOException {
        java.nio.file.Path tempDir = null;
        try {
            tempDir = Files.createTempDirectory(this.appDir.getParentFile().toPath(), "preprocess-tempdir", new FileAttribute[0]);
            this.preprocess(this.appDir, tempDir.toFile(), zone);
            IOUtils.recursiveDeleteDir((File)this.preprocessedDir);
            Files.move(tempDir, this.preprocessedDir.toPath(), new CopyOption[0]);
            tempDir = null;
        }
        catch (AccessDeniedException | DirectoryNotEmptyException e) {
            this.preprocess(this.appDir, this.preprocessedDir, zone);
        }
        finally {
            if (tempDir != null) {
                IOUtils.recursiveDeleteDir((File)tempDir.toFile());
            }
        }
        FilesApplicationPackage preprocessedApp = FilesApplicationPackage.fromFile(this.preprocessedDir, this.includeSourceFiles);
        preprocessedApp.copyUserDefsIntoApplication();
        return preprocessedApp;
    }

    private void preprocess(File appDir, File dir, Zone zone) throws IOException {
        this.validateServicesFile();
        IOUtils.copyDirectory((File)appDir, (File)dir, (int)-1, (__, name) -> !List.of(preprocessed, "services.xml", "hosts.xml", "configdefinitions").contains(name));
        this.preprocessXML(FilesApplicationPackage.applicationFile(dir, "services.xml"), this.getServicesFile(), zone);
        this.preprocessXML(FilesApplicationPackage.applicationFile(dir, "hosts.xml"), this.getHostsFile(), zone);
    }

    private void validateServicesFile() throws IOException {
        File servicesFile = this.getServicesFile();
        if (!servicesFile.exists()) {
            throw new IllegalArgumentException("services.xml does not exist in application package. There are " + this.filesInApplicationPackage() + " files in the directory");
        }
        if (IOUtils.readFile((File)servicesFile).isEmpty()) {
            throw new IllegalArgumentException("services.xml in application package is empty. There are " + this.filesInApplicationPackage() + " files in the directory");
        }
    }

    private long filesInApplicationPackage() {
        return (Long)Exceptions.uncheck(() -> {
            try (Stream<java.nio.file.Path> files = Files.list(this.appDir.toPath());){
                Long l = files.count();
                return l;
            }
        });
    }

    private void copyUserDefsIntoApplication() {
        File destination = this.appSubDirs.configDefs();
        destination.mkdir();
        ConfigDefinitionDir defDir = new ConfigDefinitionDir(destination);
        ArrayList<Bundle> bundlesAdded = new ArrayList<Bundle>();
        for (Component component : FilesApplicationPackage.getComponents(this.appSubDirs.root())) {
            Bundle bundle = component.getBundle();
            defDir.addConfigDefinitionsFromBundle(bundle, bundlesAdded);
            bundlesAdded.add(bundle);
        }
    }

    private static String computeCheckSum(File appDir) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            for (File file : appDir.listFiles((dir, name) -> !name.equals("ext") && !name.startsWith("."))) {
                FilesApplicationPackage.addPathToDigest(file, "", md5, true, false);
            }
            return Lowercase.toLowerCase((String)HexDump.toHexString((byte[])md5.digest()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void addPathToDigest(File path, String suffix, MessageDigest digest, boolean recursive, boolean fullPathNames) throws IOException {
        File[] files;
        if (!path.exists()) {
            return;
        }
        if (fullPathNames) {
            digest.update(path.getPath().getBytes(Utf8.getCharset()));
        } else {
            digest.update(path.getName().getBytes(Utf8.getCharset()));
        }
        if (path.isFile()) {
            FileInputStream is = new FileInputStream(path);
            FilesApplicationPackage.addToDigest(is, digest);
            is.close();
        } else if (path.isDirectory() && (files = path.listFiles()) != null) {
            for (File elem : files) {
                if ((!elem.isDirectory() || !recursive) && !elem.getName().endsWith(suffix)) continue;
                FilesApplicationPackage.addPathToDigest(elem, suffix, digest, recursive, fullPathNames);
            }
        }
    }

    private static void addToDigest(InputStream is, MessageDigest digest) throws IOException {
        int i;
        if (is == null) {
            return;
        }
        byte[] buffer = new byte[65536];
        do {
            if ((i = is.read(buffer)) <= 0) continue;
            digest.update(buffer, 0, i);
        } while (i != -1);
    }

    static File applicationFile(File parent, String path) {
        return FilesApplicationPackage.applicationFile(parent, Path.fromString((String)path));
    }

    static File applicationFile(File parent, Path path) {
        File file = new File(parent, path.getRelative());
        if (!file.getAbsolutePath().startsWith(parent.getAbsolutePath())) {
            throw new IllegalArgumentException(String.valueOf(file) + " is not a child of " + String.valueOf(parent));
        }
        return file;
    }

    public void validateFileExtensions() {
        validFileExtensions.forEach((subDir, __) -> this.validateInDir(subDir.toFile().toPath()));
    }

    private void validateInDir(java.nio.file.Path subDir) {
        java.nio.file.Path path = this.appDir.toPath().resolve(subDir);
        File subDirectory = path.toFile();
        if (!subDirectory.exists() || !subDirectory.isDirectory()) {
            return;
        }
        try (Stream<java.nio.file.Path> filesInPath = Files.list(path);){
            filesInPath.forEach(filePath -> {
                if (filePath.toFile().isDirectory()) {
                    this.validateInDir(this.appDir.toPath().relativize((java.nio.file.Path)filePath));
                } else {
                    this.validateFileExtensions((java.nio.file.Path)filePath);
                }
            });
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Unable to list files in " + String.valueOf(subDirectory), e);
        }
    }

    private void validateFileExtensions(java.nio.file.Path pathToFile) {
        Set<String> allowedExtensions = this.findAllowedExtensions(this.appDir.toPath().relativize(pathToFile).getParent());
        log.log(Level.FINE, "Checking " + String.valueOf(pathToFile) + " against " + String.valueOf(allowedExtensions));
        String fileName = pathToFile.toFile().getName();
        if (allowedExtensions.stream().noneMatch(fileName::endsWith)) {
            String message = "File in application package with unknown extension: " + String.valueOf(this.appDir.toPath().relativize(pathToFile.getParent()).resolve(fileName)) + ", please delete or move file to another directory.";
            throw new IllegalArgumentException(message);
        }
    }

    private Set<String> findAllowedExtensions(java.nio.file.Path relativeDirectory) {
        HashSet<String> validExtensions = new HashSet<String>();
        validExtensions.add(".gitignore");
        if (this.isSchemasSubDir(relativeDirectory)) {
            validExtensions.add(".profile");
        } else {
            validExtensions.addAll(validFileExtensions.entrySet().stream().filter(entry -> ((Path)entry.getKey()).equals((Object)Path.fromString((String)relativeDirectory.toString()))).map(Map.Entry::getValue).findFirst().orElse(Set.of()));
        }
        return validExtensions;
    }

    private boolean isSchemasSubDir(java.nio.file.Path relativeDirectory) {
        java.nio.file.Path searchDefinitionsPath;
        java.nio.file.Path schemasPath = SCHEMAS_DIR.toFile().toPath().getName(0);
        if (List.of(schemasPath, searchDefinitionsPath = SEARCH_DEFINITIONS_DIR.toFile().toPath().getName(0)).contains(relativeDirectory)) {
            return false;
        }
        return relativeDirectory.startsWith(String.valueOf(schemasPath) + "/") || relativeDirectory.startsWith(String.valueOf(searchDefinitionsPath) + "/");
    }

    public static class Builder {
        private final File appDir;
        private Optional<File> preprocessedDir = Optional.empty();
        private Optional<ApplicationMetaData> metaData = Optional.empty();
        private boolean includeSourceFiles = false;

        public Builder(File appDir) {
            this.appDir = appDir;
        }

        public Builder preprocessedDir(File preprocessedDir) {
            this.preprocessedDir = Optional.ofNullable(preprocessedDir);
            return this;
        }

        public Builder deployData(DeployData deployData) {
            this.metaData = Optional.of(FilesApplicationPackage.metaDataFromDeployData(this.appDir, deployData));
            return this;
        }

        public Builder includeSourceFiles(boolean includeSourceFiles) {
            this.includeSourceFiles = includeSourceFiles;
            return this;
        }

        public FilesApplicationPackage build() {
            return new FilesApplicationPackage(this.appDir, this.preprocessedDir.orElse(FilesApplicationPackage.applicationFile(this.appDir, FilesApplicationPackage.preprocessed)), this.metaData.orElse(FilesApplicationPackage.readMetaData(this.appDir)), this.includeSourceFiles);
        }
    }

    public static class Component {
        public final ComponentInfo info;
        private final Bundle bundle;

        public Component(Bundle bundle, ComponentInfo info) {
            this.bundle = bundle;
            this.info = info;
        }

        public List<Bundle.DefEntry> getDefEntries() {
            return this.bundle.getDefEntries();
        }

        public Bundle getBundle() {
            return this.bundle;
        }
    }
}

