/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application;

import com.yahoo.config.application.FileSystemWrapper;
import com.yahoo.config.application.IncludeProcessor;
import com.yahoo.config.application.OverrideProcessor;
import com.yahoo.config.application.PreProcessor;
import com.yahoo.config.application.PropertiesProcessor;
import com.yahoo.config.application.ValidationProcessor;
import com.yahoo.config.provision.CloudName;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.config.provision.RegionName;
import com.yahoo.config.provision.Tags;
import com.yahoo.text.XML;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlPreProcessor {
    static final String deployNamespace = "xmlns:deploy";
    static final String deployNamespaceUri = "vespa";
    static final String preprocessNamespace = "xmlns:preprocess";
    static final String preprocessNamespaceUri = "properties";
    private final FileSystemWrapper.FileWrapper applicationDir;
    private final Reader xmlInput;
    private final InstanceName instance;
    private final Environment environment;
    private final RegionName region;
    private final CloudName cloud;
    private final Tags tags;
    private final List<PreProcessor> chain;

    public XmlPreProcessor(File applicationDir, File xmlInput, InstanceName instance, Environment environment, RegionName region, CloudName cloud, Tags tags) throws IOException {
        this(applicationDir, (Reader)new FileReader(xmlInput), instance, environment, region, cloud, tags);
    }

    public XmlPreProcessor(File applicationDir, Reader xmlInput, InstanceName instance, Environment environment, RegionName region, CloudName cloud, Tags tags) {
        this(FileSystemWrapper.getDefault(applicationDir.toPath()).wrap(applicationDir.toPath()), xmlInput, instance, environment, region, cloud, tags);
    }

    public XmlPreProcessor(FileSystemWrapper.FileWrapper applicationDir, Reader xmlInput, InstanceName instance, Environment environment, RegionName region, CloudName cloud, Tags tags) {
        this.applicationDir = applicationDir;
        this.xmlInput = xmlInput;
        this.instance = instance;
        this.environment = environment;
        this.region = region;
        this.cloud = cloud;
        this.tags = tags;
        this.chain = this.setupChain();
    }

    public Document run() throws ParserConfigurationException, IOException, SAXException, TransformerException {
        DocumentBuilder docBuilder = XML.getDocumentBuilder();
        Document document = docBuilder.parse(new InputSource(this.xmlInput));
        return this.execute(document);
    }

    private Document execute(Document input) throws IOException, TransformerException {
        for (PreProcessor preProcessor : this.chain) {
            input = preProcessor.process(input);
        }
        return input;
    }

    private List<PreProcessor> setupChain() {
        ArrayList<PreProcessor> chain = new ArrayList<PreProcessor>();
        chain.add(new IncludeProcessor(this.applicationDir));
        chain.add(new OverrideProcessor(this.instance, this.environment, this.region, this.cloud, this.tags));
        chain.add(new PropertiesProcessor());
        chain.add(new ValidationProcessor());
        return chain;
    }
}

