/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application;

import com.yahoo.config.application.PreProcessor;
import com.yahoo.config.application.Xml;
import com.yahoo.config.provision.CloudName;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.config.provision.RegionName;
import com.yahoo.config.provision.Tags;
import com.yahoo.text.XML;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

class OverrideProcessor
implements PreProcessor {
    private static final Logger log = Logger.getLogger(OverrideProcessor.class.getName());
    private final InstanceName instance;
    private final Environment environment;
    private final RegionName region;
    private final CloudName cloud;
    private final Tags tags;
    private static final String ID_ATTRIBUTE = "id";
    private static final String IDREF_ATTRIBUTE = "idref";
    private static final String INSTANCE_ATTRIBUTE = "instance";
    private static final String ENVIRONMENT_ATTRIBUTE = "environment";
    private static final String REGION_ATTRIBUTE = "region";
    private static final String CLOUD_ATTRIBUTE = "cloud";
    private static final String TAGS_ATTRIBUTE = "tags";

    public OverrideProcessor(InstanceName instance, Environment environment, RegionName region, CloudName cloud, Tags tags) {
        this.instance = instance;
        this.environment = environment;
        this.region = region;
        this.cloud = cloud;
        this.tags = tags;
    }

    @Override
    public Document process(Document input) throws TransformerException {
        log.log(Level.FINE, () -> "Preprocessing overrides with " + this.environment + "." + this.region);
        Document ret = Xml.copyDocument(input);
        Element root = ret.getDocumentElement();
        this.applyOverrides(root, Context.empty());
        return ret;
    }

    private void applyOverrides(Element parent, Context context) {
        context = this.getParentContext(parent, context);
        Map<String, List<Element>> elementsByTagName = this.elementsByTagNameAndId(XML.getChildren((Element)parent));
        this.retainOverriddenElements(elementsByTagName);
        for (Map.Entry<String, List<Element>> entry : elementsByTagName.entrySet()) {
            this.pruneOverrides(parent, entry.getValue(), context);
        }
        for (Element child : XML.getChildren((Element)parent)) {
            this.applyOverrides(child, context);
            child.removeAttributeNS("vespa", INSTANCE_ATTRIBUTE);
            child.removeAttributeNS("vespa", ENVIRONMENT_ATTRIBUTE);
            child.removeAttributeNS("vespa", REGION_ATTRIBUTE);
            child.removeAttributeNS("vespa", CLOUD_ATTRIBUTE);
            child.removeAttributeNS("vespa", TAGS_ATTRIBUTE);
        }
    }

    private Context getParentContext(Element parent, Context context) {
        Set<InstanceName> instances = context.instances;
        Set<Environment> environments = context.environments;
        Set<RegionName> regions = context.regions;
        Set<CloudName> clouds = context.clouds;
        Tags tags = context.tags;
        if (instances.isEmpty()) {
            instances = this.getInstances(parent);
        }
        if (environments.isEmpty()) {
            environments = this.getEnvironments(parent);
        }
        if (regions.isEmpty()) {
            regions = this.getRegions(parent);
        }
        if (clouds.isEmpty()) {
            clouds = this.getClouds(parent);
        }
        if (tags.isEmpty()) {
            tags = this.getTags(parent);
        }
        return Context.create(instances, environments, regions, clouds, tags);
    }

    private void pruneOverrides(Element parent, List<Element> children, Context context) {
        this.checkConsistentInheritance(children, context);
        this.pruneNonMatching(parent, children);
        this.retainMostSpecific(parent, children, context);
    }

    private void checkConsistentInheritance(List<Element> children, Context context) {
        for (Element child : children) {
            Set<InstanceName> instances = this.getInstances(child);
            if (!(instances.isEmpty() || context.instances.isEmpty() || context.instances.containsAll(instances))) {
                throw new IllegalArgumentException("Instances in child (" + instances + ") are not a subset of those of the parent (" + context.instances + ") at " + child);
            }
            Set<Environment> environments = this.getEnvironments(child);
            if (!(environments.isEmpty() || context.environments.isEmpty() || context.environments.containsAll(environments))) {
                throw new IllegalArgumentException("Environments in child (" + environments + ") are not a subset of those of the parent (" + context.environments + ") at " + child);
            }
            Set<RegionName> regions = this.getRegions(child);
            if (!(regions.isEmpty() || context.regions.isEmpty() || context.regions.containsAll(regions))) {
                throw new IllegalArgumentException("Regions in child (" + regions + ") are not a subset of those of the parent (" + context.regions + ") at " + child);
            }
            Set<CloudName> clouds = this.getClouds(child);
            if (!(clouds.isEmpty() || context.clouds.isEmpty() || context.clouds.containsAll(clouds))) {
                throw new IllegalArgumentException("Clouds in child (" + regions + ") are not a subset of those of the parent (" + context.clouds + ") at " + child);
            }
            Tags tags = this.getTags(child);
            if (tags.isEmpty() || context.tags.isEmpty() || context.tags.containsAll(tags)) continue;
            throw new IllegalArgumentException("Tags in child (" + environments + ") are not a subset of those of the parent (" + context.tags + ") at " + child);
        }
    }

    private void pruneNonMatching(Element parent, List<Element> children) {
        Iterator<Element> elemIt = children.iterator();
        while (elemIt.hasNext()) {
            Element child = elemIt.next();
            if (this.matches(this.getInstances(child), this.getEnvironments(child), this.getRegions(child), this.getClouds(child), this.getTags(child))) continue;
            parent.removeChild(child);
            elemIt.remove();
        }
    }

    private boolean matches(Set<InstanceName> elementInstances, Set<Environment> elementEnvironments, Set<RegionName> elementRegions, Set<CloudName> elementClouds, Tags elementTags) {
        if (!elementInstances.isEmpty() && !elementInstances.contains(this.instance)) {
            return false;
        }
        if (!elementEnvironments.isEmpty() && !elementEnvironments.contains(this.environment)) {
            return false;
        }
        if (!elementRegions.isEmpty() && !elementRegions.contains(this.region)) {
            return false;
        }
        if (!elementClouds.isEmpty() && !elementClouds.contains(this.cloud)) {
            return false;
        }
        if (!elementTags.isEmpty()) {
            if (!elementTags.intersects(this.tags)) {
                return false;
            }
            if (elementEnvironments.isEmpty() && this.environment != Environment.prod) {
                return false;
            }
        }
        return true;
    }

    private void retainMostSpecific(Element parent, List<Element> children, Context context) {
        ArrayList<Element> bestMatches = new ArrayList<Element>();
        int bestMatch = 0;
        for (Element child : children) {
            bestMatch = this.updateBestMatches(bestMatches, child, bestMatch, context);
        }
        if (bestMatch > 0) {
            this.doElementSpecificProcessingOnOverride(bestMatches);
            for (Element child : children) {
                if (bestMatches.contains(child)) continue;
                parent.removeChild(child);
            }
        }
    }

    private int updateBestMatches(List<Element> bestMatches, Element child, int bestMatch, Context context) {
        int overrideCount = this.getNumberOfOverrides(child, context);
        if (overrideCount >= bestMatch) {
            if (overrideCount > bestMatch) {
                bestMatches.clear();
            }
            bestMatches.add(child);
            return overrideCount;
        }
        return bestMatch;
    }

    private int getNumberOfOverrides(Element child, Context context) {
        Tags elementTags;
        int currentMatch = 0;
        Set<InstanceName> elementInstances = this.hasInstance(child) ? this.getInstances(child) : context.instances;
        Set<Environment> elementEnvironments = this.hasEnvironment(child) ? this.getEnvironments(child) : context.environments;
        Set<RegionName> elementRegions = this.hasRegion(child) ? this.getRegions(child) : context.regions;
        Set<CloudName> elementClouds = this.hasCloud(child) ? this.getClouds(child) : context.clouds;
        Tags tags = elementTags = this.hasTag(child) ? this.getTags(child) : context.tags;
        if (!elementInstances.isEmpty() && elementInstances.contains(this.instance)) {
            ++currentMatch;
        }
        if (!elementEnvironments.isEmpty() && elementEnvironments.contains(this.environment)) {
            ++currentMatch;
        }
        if (!elementRegions.isEmpty() && elementRegions.contains(this.region)) {
            ++currentMatch;
        }
        if (!elementClouds.isEmpty() && elementClouds.contains(this.cloud)) {
            ++currentMatch;
        }
        if (elementTags.intersects(this.tags)) {
            ++currentMatch;
        }
        return currentMatch;
    }

    private void doElementSpecificProcessingOnOverride(List<Element> elements) {
        elements.forEach(element -> {
            if (element.getTagName().equals("nodes") && !OverrideProcessor.hasChildWithTagName(element, "node")) {
                element.setAttribute("required", "true");
            }
        });
    }

    private static boolean hasChildWithTagName(Element element, String childName) {
        for (Element child : XML.getChildren((Element)element)) {
            if (!child.getTagName().equals(childName)) continue;
            return true;
        }
        return false;
    }

    private void retainOverriddenElements(Map<String, List<Element>> elementsByTagName) {
        Iterator<Map.Entry<String, List<Element>>> it = elementsByTagName.entrySet().iterator();
        while (it.hasNext()) {
            List<Element> elements = it.next().getValue();
            boolean hasOverrides = false;
            for (Element element : elements) {
                if (!this.hasInstance(element) && !this.hasEnvironment(element) && !this.hasRegion(element) && !this.hasCloud(element) && !this.hasTag(element)) continue;
                hasOverrides = true;
            }
            if (hasOverrides) continue;
            it.remove();
        }
    }

    private boolean hasInstance(Element element) {
        return element.hasAttributeNS("vespa", INSTANCE_ATTRIBUTE);
    }

    private boolean hasRegion(Element element) {
        return element.hasAttributeNS("vespa", REGION_ATTRIBUTE);
    }

    private boolean hasCloud(Element element) {
        return element.hasAttributeNS("vespa", CLOUD_ATTRIBUTE);
    }

    private boolean hasEnvironment(Element element) {
        return element.hasAttributeNS("vespa", ENVIRONMENT_ATTRIBUTE);
    }

    private boolean hasTag(Element element) {
        return element.hasAttributeNS("vespa", TAGS_ATTRIBUTE);
    }

    private Set<InstanceName> getInstances(Element element) {
        String instance = element.getAttributeNS("vespa", INSTANCE_ATTRIBUTE);
        if (instance.isEmpty()) {
            return Set.of();
        }
        return Arrays.stream(instance.split(" ")).map(InstanceName::from).collect(Collectors.toSet());
    }

    private Set<Environment> getEnvironments(Element element) {
        String env = element.getAttributeNS("vespa", ENVIRONMENT_ATTRIBUTE);
        if (env.isEmpty()) {
            return Set.of();
        }
        return Arrays.stream(env.split(" ")).map(Environment::from).collect(Collectors.toSet());
    }

    private Set<RegionName> getRegions(Element element) {
        String reg = element.getAttributeNS("vespa", REGION_ATTRIBUTE);
        if (reg.isEmpty()) {
            return Set.of();
        }
        return Arrays.stream(reg.split(" ")).map(RegionName::from).collect(Collectors.toSet());
    }

    private Set<CloudName> getClouds(Element element) {
        String reg = element.getAttributeNS("vespa", CLOUD_ATTRIBUTE);
        if (reg.isEmpty()) {
            return Set.of();
        }
        return Arrays.stream(reg.split(" ")).map(CloudName::from).collect(Collectors.toSet());
    }

    private Tags getTags(Element element) {
        String env = element.getAttributeNS("vespa", TAGS_ATTRIBUTE);
        if (env.isEmpty()) {
            return Tags.empty();
        }
        return Tags.fromString((String)env);
    }

    private Map<String, List<Element>> elementsByTagNameAndId(List<Element> children) {
        LinkedHashMap<String, List<Element>> elementsByTagName = new LinkedHashMap<String, List<Element>>();
        for (Element child : children) {
            Object key = child.getTagName();
            if (child.hasAttribute(ID_ATTRIBUTE)) {
                key = (String)key + child.getAttribute(ID_ATTRIBUTE);
            }
            if (child.hasAttribute(IDREF_ATTRIBUTE)) {
                key = (String)key + child.getAttribute(IDREF_ATTRIBUTE);
            }
            if (!elementsByTagName.containsKey(key)) {
                elementsByTagName.put((String)key, new ArrayList());
            }
            ((List)elementsByTagName.get(key)).add(child);
        }
        return elementsByTagName;
    }

    private static String getPrintableElement(Element element) {
        StringBuilder sb = new StringBuilder(element.getTagName());
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            sb.append(" ").append(attributes.item(i).getNodeName());
        }
        return sb.toString();
    }

    private static String getPrintableElementRecursive(Element element) {
        StringBuilder sb = new StringBuilder();
        sb.append(element.getTagName());
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            sb.append(" ").append(attributes.item(i).getNodeName()).append("=").append(attributes.item(i).getNodeValue());
        }
        List children = XML.getChildren((Element)element);
        if (children.size() > 0) {
            sb.append("\n");
            for (Element e : children) {
                sb.append("\t").append(OverrideProcessor.getPrintableElementRecursive(e));
            }
        }
        return sb.toString();
    }

    private static final class Context {
        final Set<InstanceName> instances;
        final Set<Environment> environments;
        final Set<RegionName> regions;
        final Set<CloudName> clouds;
        final Tags tags;

        private Context(Set<InstanceName> instances, Set<Environment> environments, Set<RegionName> regions, Set<CloudName> clouds, Tags tags) {
            this.instances = Set.copyOf(instances);
            this.environments = Set.copyOf(environments);
            this.regions = Set.copyOf(regions);
            this.clouds = Set.copyOf(clouds);
            this.tags = tags;
        }

        static Context empty() {
            return new Context(Set.of(), Set.of(), Set.of(), Set.of(), Tags.empty());
        }

        public static Context create(Set<InstanceName> instances, Set<Environment> environments, Set<RegionName> regions, Set<CloudName> clouds, Tags tags) {
            return new Context(instances, environments, regions, clouds, tags);
        }
    }
}

