/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.application.provider;

import com.yahoo.component.Version;
import com.yahoo.config.model.application.provider.BaseDeployLogger;
import com.yahoo.config.model.application.provider.SchemaValidator;
import com.yahoo.io.IOUtils;
import com.yahoo.vespa.defaults.Defaults;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.xml.sax.SAXException;

public class SchemaValidators {
    private static final String schemaDirBase = System.getProperty("java.io.tmpdir", File.separator + "tmp" + File.separator + "vespa");
    private static final Logger log = Logger.getLogger(SchemaValidators.class.getName());
    private static final String servicesXmlSchemaName = "services.rnc";
    private static final String hostsXmlSchemaName = "hosts.rnc";
    private static final String deploymentXmlSchemaName = "deployment.rnc";
    private static final String validationOverridesXmlSchemaName = "validation-overrides.rnc";
    private static final String containerIncludeXmlSchemaName = "container-include.rnc";
    private static final String routingStandaloneXmlSchemaName = "routing-standalone.rnc";
    private final SchemaValidator servicesXmlValidator;
    private final SchemaValidator hostsXmlValidator;
    private final SchemaValidator deploymentXmlValidator;
    private final SchemaValidator validationOverridesXmlValidator;
    private final SchemaValidator containerIncludeXmlValidator;
    private final SchemaValidator routingStandaloneXmlValidator;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SchemaValidators(Version vespaVersion) {
        File schemaDir = null;
        try {
            schemaDir = this.saveSchemasFromJar(new File(schemaDirBase), vespaVersion);
            this.servicesXmlValidator = this.createValidator(schemaDir, servicesXmlSchemaName);
            this.hostsXmlValidator = this.createValidator(schemaDir, hostsXmlSchemaName);
            this.deploymentXmlValidator = this.createValidator(schemaDir, deploymentXmlSchemaName);
            this.validationOverridesXmlValidator = this.createValidator(schemaDir, validationOverridesXmlSchemaName);
            this.containerIncludeXmlValidator = this.createValidator(schemaDir, containerIncludeXmlSchemaName);
            this.routingStandaloneXmlValidator = this.createValidator(schemaDir, routingStandaloneXmlSchemaName);
            if (schemaDir == null) return;
        }
        catch (IOException ioe) {
            try {
                throw new RuntimeException(ioe);
                catch (Exception e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                if (schemaDir == null) throw throwable;
                IOUtils.recursiveDeleteDir(schemaDir);
                throw throwable;
            }
        }
        IOUtils.recursiveDeleteDir((File)schemaDir);
    }

    public SchemaValidator servicesXmlValidator() {
        return this.servicesXmlValidator;
    }

    public SchemaValidator hostsXmlValidator() {
        return this.hostsXmlValidator;
    }

    public SchemaValidator deploymentXmlValidator() {
        return this.deploymentXmlValidator;
    }

    SchemaValidator validationOverridesXmlValidator() {
        return this.validationOverridesXmlValidator;
    }

    SchemaValidator containerIncludeXmlValidator() {
        return this.containerIncludeXmlValidator;
    }

    SchemaValidator routingStandaloneXmlValidator() {
        return this.routingStandaloneXmlValidator;
    }

    private File saveSchemasFromJar(File tmpBase, Version vespaVersion) throws IOException {
        Class<?> schemaValidatorClass = this.getClass();
        ClassLoader classLoader = schemaValidatorClass.getClassLoader();
        Enumeration<URL> uris = classLoader.getResources("schema");
        if (uris == null) {
            throw new IllegalArgumentException("Could not find XML schemas ");
        }
        File tmpDir = Files.createTempDirectory(tmpBase.toPath(), "vespa", new FileAttribute[0]).toFile();
        log.log(Level.FINE, () -> "Will save all XML schemas for " + vespaVersion + " to " + tmpDir);
        while (uris.hasMoreElements()) {
            URL u = uris.nextElement();
            log.log(Level.FINE, () -> "uri for resource 'schema'=" + u.toString());
            if ("jar".equals(u.getProtocol())) {
                JarURLConnection jarConnection = (JarURLConnection)u.openConnection();
                JarFile jarFile = jarConnection.getJarFile();
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry je = entries.nextElement();
                    if (!je.getName().startsWith("schema/") || !je.getName().endsWith(".rnc")) continue;
                    SchemaValidators.writeContentsToFile(tmpDir, je.getName(), jarFile.getInputStream(je));
                }
                jarFile.close();
                continue;
            }
            if ("bundle".equals(u.getProtocol())) {
                Bundle bundle = FrameworkUtil.getBundle(schemaValidatorClass);
                log.log(Level.FINE, () -> "bundle=" + bundle);
                if (bundle == null) {
                    String pathPrefix = Defaults.getDefaults().underVespaHome("share/vespa/schema/");
                    File schemaPath = new File(pathPrefix + "version/" + vespaVersion.getMajor() + ".x/schema/");
                    if (!schemaPath.exists()) {
                        log.log(Level.INFO, "Found no schemas in " + schemaPath + ", fallback to schemas in " + pathPrefix);
                        schemaPath = new File(pathPrefix);
                    }
                    log.log(Level.FINE, "Using schemas found in " + schemaPath);
                    SchemaValidators.copySchemas(schemaPath, tmpDir);
                    continue;
                }
                log.log(Level.FINE, () -> String.format("Saving schemas for model bundle %s:%s", bundle.getSymbolicName(), bundle.getVersion()));
                Enumeration entries = bundle.findEntries("schema", "*.rnc", true);
                while (entries.hasMoreElements()) {
                    URL url = (URL)entries.nextElement();
                    SchemaValidators.writeContentsToFile(tmpDir, url.getFile(), url.openStream());
                }
                continue;
            }
            if (!"file".equals(u.getProtocol())) continue;
            File schemaPath = new File(u.getPath());
            SchemaValidators.copySchemas(schemaPath, tmpDir);
        }
        return tmpDir;
    }

    private static void copySchemas(File from, File to) throws IOException {
        if (!from.exists()) {
            throw new IOException("Could not find schema source directory '" + from + "'");
        }
        if (!from.isDirectory()) {
            throw new IOException("Schema source '" + from + "' is not a directory");
        }
        File sourceFile = new File(from, servicesXmlSchemaName);
        if (!sourceFile.exists()) {
            throw new IOException("Schema source file '" + sourceFile + "' not found");
        }
        IOUtils.copyDirectoryInto((File)from, (File)to);
    }

    private static void writeContentsToFile(File outDir, String outFile, InputStream inputStream) throws IOException {
        String contents = IOUtils.readAll((Reader)new InputStreamReader(inputStream));
        File out = new File(outDir, outFile);
        IOUtils.writeFile((File)out, (String)contents, (boolean)false);
    }

    private SchemaValidator createValidator(File schemaDir, String schemaFile) {
        try {
            File file = new File(schemaDir + File.separator + "schema" + File.separator + schemaFile);
            return new SchemaValidator(file, new BaseDeployLogger());
        }
        catch (SAXException e) {
            throw new RuntimeException("Invalid schema '" + schemaFile + "'", e);
        }
        catch (IOException e) {
            throw new RuntimeException("IO error reading schema '" + schemaFile + "'", e);
        }
    }
}

