/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.application.provider;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.io.IOUtils;
import com.yahoo.log.LogLevel;
import com.yahoo.path.Path;
import com.yahoo.vespa.config.util.ConfigUtils;
import com.yahoo.yolean.Exceptions;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FilesApplicationFile
extends ApplicationFile {
    private static final Logger log = Logger.getLogger("FilesApplicationFile");
    private final File file;
    private final ObjectMapper mapper = new ObjectMapper();

    public FilesApplicationFile(Path path, File file) {
        super(path);
        this.file = file;
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public boolean exists() {
        return this.file.exists();
    }

    public ApplicationFile delete() {
        log.log((Level)LogLevel.DEBUG, "Delete " + this.file);
        if (this.file.isDirectory() && !this.listFiles().isEmpty()) {
            throw new RuntimeException("files. Can't delete, directory not empty: " + this + "(" + this.listFiles() + ")." + this.listFiles().size());
        }
        if (this.file.isDirectory() && this.file.listFiles() != null && this.file.listFiles().length > 0) {
            for (File f : this.file.listFiles()) {
                FilesApplicationFile.deleteFile(f);
            }
        }
        if (!this.file.delete()) {
            throw new IllegalStateException("Unable to delete: " + this);
        }
        try {
            this.writeMetaFile("", "deleted");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public static boolean deleteFile(File path) {
        if (path.exists() && path.isDirectory()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    FilesApplicationFile.deleteFile(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    public Reader createReader() throws FileNotFoundException {
        return new FileReader(this.file);
    }

    public InputStream createInputStream() throws FileNotFoundException {
        return new FileInputStream(this.file);
    }

    public ApplicationFile createDirectory() {
        if (this.file.isDirectory()) {
            return this;
        }
        if (this.file.exists()) {
            throw new IllegalArgumentException("Unable to create directory, file exists: " + this.file);
        }
        if (!this.file.mkdirs()) {
            throw new IllegalArgumentException("Unable to create directory: " + this.file);
        }
        try {
            this.writeMetaFile("", "new");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public ApplicationFile writeFile(Reader input) {
        if (this.file.getParentFile() != null) {
            this.file.getParentFile().mkdirs();
        }
        try {
            String status = this.file.exists() ? "changed" : "new";
            String data = IOUtils.readAll((Reader)input);
            IOUtils.writeFile((File)this.file, (String)data, (boolean)false);
            this.writeMetaFile(data, status);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public ApplicationFile appendFile(String value) {
        if (this.file.getParentFile() != null) {
            this.file.getParentFile().mkdirs();
        }
        try {
            String status = this.file.exists() ? "changed" : "new";
            IOUtils.writeFile((File)this.file, (String)value, (boolean)true);
            this.writeMetaFile(value, status);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public List<ApplicationFile> listFiles(ApplicationFile.PathFilter filter) {
        ArrayList<ApplicationFile> files = new ArrayList<ApplicationFile>();
        if (!this.file.isDirectory()) {
            return files;
        }
        FileFilter fileFilter = pathname -> filter.accept(this.path.append(pathname.getName()));
        for (File child : this.file.listFiles(fileFilter)) {
            if (child.getName().startsWith(".")) continue;
            files.add(new FilesApplicationFile(this.path.append(child.getName()), child));
        }
        return files;
    }

    private void writeMetaFile(String data, String status) throws IOException {
        File metaDir = this.createMetaDir();
        log.log((Level)LogLevel.DEBUG, "meta dir=" + metaDir);
        File metaFile = new File(metaDir + "/" + this.getPath().getName());
        if (status == null) {
            status = "new";
            if (metaFile.exists()) {
                status = "changed";
            }
        }
        String hash = this.file.isDirectory() || status.equals("deleted") ? "" : ConfigUtils.getMd5((String)data);
        this.mapper.writeValue(metaFile, (Object)new ApplicationFile.MetaData(status, hash));
    }

    private File createMetaDir() {
        File metaDir = this.getMetaDir();
        if (!metaDir.exists()) {
            log.log((Level)LogLevel.DEBUG, "Creating meta dir " + metaDir);
            metaDir.mkdirs();
        }
        return metaDir;
    }

    private File getMetaDir() {
        String substring = this.file.getAbsolutePath().substring(0, this.file.getAbsolutePath().lastIndexOf("/") + 1);
        return new File(substring + Path.fromString((String)".meta/"));
    }

    public ApplicationFile.MetaData getMetaData() {
        File metaDir = this.getMetaDir();
        File metaFile = new File(metaDir + "/" + this.getPath().getName());
        log.log((Level)LogLevel.DEBUG, "Getting metadata for " + metaFile);
        if (metaFile.exists()) {
            try {
                return (ApplicationFile.MetaData)this.mapper.readValue(metaFile, ApplicationFile.MetaData.class);
            }
            catch (IOException e) {
                System.out.println("whot:" + Exceptions.toMessageString((Throwable)e));
            }
        }
        try {
            if (this.file.isDirectory()) {
                return new ApplicationFile.MetaData("new", "");
            }
            return new ApplicationFile.MetaData("new", ConfigUtils.getMd5((String)IOUtils.readAll((Reader)this.createReader())));
        }
        catch (IOException | IllegalArgumentException e) {
            return null;
        }
    }

    public int compareTo(ApplicationFile other) {
        if (other == this) {
            return 0;
        }
        return this.getPath().getName().compareTo(other.getPath().getName());
    }
}

