/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.application.provider;

import com.yahoo.component.Vtag;
import com.yahoo.config.application.ConfigDefinitionDir;
import com.yahoo.config.application.Xml;
import com.yahoo.config.application.XmlPreProcessor;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationMetaData;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.ComponentInfo;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.UnparsedConfigDefinition;
import com.yahoo.config.codegen.CNode;
import com.yahoo.config.codegen.DefParser;
import com.yahoo.config.model.application.provider.AppSubDirs;
import com.yahoo.config.model.application.provider.ApplicationPackageXmlFilesValidator;
import com.yahoo.config.model.application.provider.Bundle;
import com.yahoo.config.model.application.provider.DeployData;
import com.yahoo.config.model.application.provider.FilesApplicationFile;
import com.yahoo.config.model.application.provider.IncludeDirs;
import com.yahoo.config.provision.Version;
import com.yahoo.config.provision.Zone;
import com.yahoo.io.HexDump;
import com.yahoo.io.IOUtils;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.log.LogLevel;
import com.yahoo.path.Path;
import com.yahoo.text.Lowercase;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.config.ConfigDefinition;
import com.yahoo.vespa.config.ConfigDefinitionBuilder;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.util.ConfigUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FilesApplicationPackage
implements ApplicationPackage {
    public static final String preprocessed = ".preprocessed";
    private static final Logger log = Logger.getLogger(FilesApplicationPackage.class.getName());
    private static final String META_FILE_NAME = ".applicationMetaData";
    private final File appDir;
    private final File preprocessedDir;
    private final File configDefsDir;
    private final AppSubDirs appSubDirs;
    private final List<String> userIncludeDirs = new ArrayList<String>();
    private final ApplicationMetaData metaData;
    private final boolean includeSourceFiles;
    private static final int MD5_BUFFER_SIZE = 65536;

    public static FilesApplicationPackage fromFile(File appDir) {
        return FilesApplicationPackage.fromFile(appDir, false);
    }

    public static FilesApplicationPackage fromFile(File appDir, boolean includeSourceFiles) {
        return new Builder(appDir).preprocessedDir(new File(appDir, preprocessed)).includeSourceFiles(includeSourceFiles).build();
    }

    public static FilesApplicationPackage fromFileWithDeployData(File appDir, DeployData deployData) {
        return FilesApplicationPackage.fromFileWithDeployData(appDir, deployData, false);
    }

    public static FilesApplicationPackage fromFileWithDeployData(File appDir, DeployData deployData, boolean includeSourceFiles) {
        return new Builder(appDir).includeSourceFiles(includeSourceFiles).deployData(deployData).build();
    }

    private static ApplicationMetaData metaDataFromDeployData(File appDir, DeployData deployData) {
        return new ApplicationMetaData(deployData.getDeployedByUser(), deployData.getDeployedFromDir(), Long.valueOf(deployData.getDeployTimestamp()), deployData.isInternalRedeploy(), deployData.getApplicationName(), FilesApplicationPackage.computeCheckSum(appDir), Long.valueOf(deployData.getGeneration()), deployData.getCurrentlyActiveGeneration());
    }

    private FilesApplicationPackage(File appDir, File preprocessedDir, ApplicationMetaData metaData, boolean includeSourceFiles) {
        this.verifyAppDir(appDir);
        this.includeSourceFiles = includeSourceFiles;
        this.appDir = appDir;
        this.preprocessedDir = preprocessedDir;
        this.appSubDirs = new AppSubDirs(appDir);
        this.configDefsDir = new File(appDir, "configdefinitions");
        this.addUserIncludeDirs();
        this.metaData = metaData;
    }

    public String getApplicationName() {
        return this.metaData.getApplicationName();
    }

    public List<NamedReader> getFiles(Path relativePath, String suffix, boolean recurse) {
        return this.getFiles(relativePath, "", suffix, recurse);
    }

    public ApplicationFile getFile(Path path) {
        File file = path.isRoot() ? this.appDir : new File(this.appDir, path.getRelative());
        return new FilesApplicationFile(path, file);
    }

    public ApplicationMetaData getMetaData() {
        return this.metaData;
    }

    private List<NamedReader> getFiles(Path relativePath, String namePrefix, String suffix, boolean recurse) {
        try {
            ArrayList<NamedReader> readers = new ArrayList<NamedReader>();
            File dir = new File(this.appDir, relativePath.getRelative());
            if (!dir.isDirectory()) {
                return readers;
            }
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        if (!recurse) continue;
                        readers.addAll(this.getFiles(relativePath.append(file.getName()), namePrefix + "/" + file.getName(), suffix, recurse));
                        continue;
                    }
                    if (suffix != null && !file.getName().endsWith(suffix)) continue;
                    readers.add(new NamedReader(file.getName(), (Reader)new FileReader(file)));
                }
            }
            return readers;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open (all) files in '" + relativePath + "'", e);
        }
    }

    private void verifyAppDir(File appDir) {
        if (appDir == null || !appDir.isDirectory()) {
            throw new IllegalArgumentException("Path '" + appDir + "' is not a directory.");
        }
        if (!appDir.canRead()) {
            throw new IllegalArgumentException("Cannot read from application directory '" + appDir + "'");
        }
    }

    public Reader getHosts() {
        try {
            File hostsFile = this.getHostsFile();
            if (!hostsFile.exists()) {
                return null;
            }
            return new FileReader(hostsFile);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getHostSource() {
        return this.getHostsFile().getPath();
    }

    private File getHostsFile() {
        return new File(this.appDir, "hosts.xml");
    }

    public String getServicesSource() {
        return this.getServicesFile().getPath();
    }

    private File getServicesFile() {
        return new File(this.appDir, "services.xml");
    }

    public Optional<Reader> getDeployment() {
        return this.optionalFile(DEPLOYMENT_FILE);
    }

    public Optional<Reader> getValidationOverrides() {
        return this.optionalFile(VALIDATION_OVERRIDES);
    }

    private Optional<Reader> optionalFile(Path filePath) {
        try {
            return Optional.of(this.getFile(filePath).createReader());
        }
        catch (FileNotFoundException e) {
            return Optional.empty();
        }
    }

    public List<String> getUserIncludeDirs() {
        return Collections.unmodifiableList(this.userIncludeDirs);
    }

    public void addUserIncludeDirs() {
        Document services;
        try {
            services = Xml.getDocument(this.getServices());
        }
        catch (Exception e) {
            return;
        }
        NodeList includeNodes = services.getElementsByTagName("include");
        for (int i = 0; i < includeNodes.getLength(); ++i) {
            Node includeNode = includeNodes.item(i);
            this.addIncludeDir(includeNode);
        }
    }

    private void addIncludeDir(Node includeNode) {
        if (!(includeNode instanceof Element)) {
            return;
        }
        Element include = (Element)includeNode;
        if (!include.hasAttribute("dir")) {
            return;
        }
        String dir = include.getAttribute("dir");
        this.validateIncludeDir(dir);
        IncludeDirs.validateFilesInIncludedDir(dir, include.getParentNode(), this);
        log.log(LogLevel.INFO, "Adding user include dir '" + dir + "'");
        this.userIncludeDirs.add(dir);
    }

    public void validateIncludeDir(String dirName) {
        IncludeDirs.validateIncludeDir(dirName, this);
    }

    public Collection<NamedReader> searchDefinitionContents() {
        LinkedHashMap<String, NamedReader> ret = new LinkedHashMap<String, NamedReader>();
        LinkedHashSet<String> fileSds = new LinkedHashSet<String>();
        LinkedHashSet<String> bundleSds = new LinkedHashSet<String>();
        try {
            for (File file : this.getSearchDefinitionFiles()) {
                fileSds.add(file.getName());
                ret.put(file.getName(), new NamedReader(file.getName(), (Reader)new FileReader(file)));
            }
            for (Map.Entry entry : FilesApplicationPackage.allSdsFromDocprocBundlesAndClasspath(this.appDir).entrySet()) {
                bundleSds.add((String)entry.getKey());
                ret.put((String)entry.getKey(), new NamedReader((String)entry.getKey(), (Reader)new StringReader((String)entry.getValue())));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't get search definition contents.", e);
        }
        this.verifySdsDisjoint(fileSds, bundleSds);
        return ret.values();
    }

    private void verifySdsDisjoint(Set<String> fileSds, Set<String> bundleSds) {
        if (!Collections.disjoint(fileSds, bundleSds)) {
            ArrayList<String> disjoint = new ArrayList<String>(fileSds);
            disjoint.retainAll(bundleSds);
            throw new IllegalArgumentException("For the following search definitions names there are collisions between those specified inside docproc bundles and those in searchdefinitions/ in application package: " + disjoint);
        }
    }

    public static Map<String, String> allSdsFromDocprocBundlesAndClasspath(File appDir) throws IOException {
        File dpChains = new File(appDir, "components");
        if (!dpChains.exists() || !dpChains.isDirectory()) {
            return Collections.emptyMap();
        }
        ArrayList<String> usedNames = new ArrayList<String>();
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        FilesApplicationPackage.allSdsOnClassPath(usedNames, ret);
        for (File bundle : dpChains.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        })) {
            for (Map.Entry entry : ApplicationPackage.getBundleSdFiles((String)"", (JarFile)new JarFile(bundle)).entrySet()) {
                String sdName = (String)entry.getKey();
                if (usedNames.contains(sdName)) {
                    throw new IllegalArgumentException("The search definition name '" + sdName + "' used in bundle '" + bundle.getName() + "' is already used in classpath or previous bundle.");
                }
                usedNames.add(sdName);
                String sdPayload = (String)entry.getValue();
                ret.put(sdName, sdPayload);
            }
        }
        return ret;
    }

    private static void allSdsOnClassPath(List<String> usedNames, Map<String, String> ret) throws IOException {
        Enumeration<URL> resources = FilesApplicationPackage.class.getClassLoader().getResources(ApplicationPackage.SEARCH_DEFINITIONS_DIR.getRelative());
        while (resources.hasMoreElements()) {
            String sdName;
            URL resource = resources.nextElement();
            String protocol = resource.getProtocol();
            if ("file".equals(protocol)) {
                File file;
                try {
                    file = new File(resource.toURI());
                }
                catch (URISyntaxException e) {
                    continue;
                }
                if (!file.isDirectory()) continue;
                List<File> sdFiles = FilesApplicationPackage.getSearchDefinitionFiles(file);
                for (File file2 : sdFiles) {
                    sdName = file2.getName();
                    if (usedNames.contains(sdName)) {
                        throw new IllegalArgumentException("The search definition name '" + sdName + "' found in classpath already used earlier in classpath.");
                    }
                    usedNames.add(sdName);
                    String contents = IOUtils.readAll((Reader)new FileReader(file2));
                    ret.put(file2.getName(), contents);
                }
                continue;
            }
            if (!"jar".equals(protocol)) continue;
            JarURLConnection jarConnection = (JarURLConnection)resource.openConnection();
            JarFile jarFile = jarConnection.getJarFile();
            for (Map.Entry entry : ApplicationPackage.getBundleSdFiles((String)"", (JarFile)jarFile).entrySet()) {
                sdName = (String)entry.getKey();
                if (usedNames.contains(sdName)) {
                    throw new IllegalArgumentException("The search definitions name '" + sdName + "' used in bundle '" + jarFile.getName() + "' is already used in classpath or previous bundle.");
                }
                usedNames.add(sdName);
                String sdPayload = (String)entry.getValue();
                ret.put(sdName, sdPayload);
            }
        }
    }

    private Reader retrieveConfigDefReader(File defPath) {
        try {
            return new NamedReader(defPath.getPath(), (Reader)new FileReader(defPath));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read config definition file '" + defPath + "'", e);
        }
    }

    public Map<ConfigDefinitionKey, UnparsedConfigDefinition> getAllExistingConfigDefs() {
        LinkedHashMap<ConfigDefinitionKey, UnparsedConfigDefinition> defs = new LinkedHashMap<ConfigDefinitionKey, UnparsedConfigDefinition>();
        this.addAllDefsFromConfigDir(defs, this.configDefsDir);
        if (this.includeSourceFiles) {
            this.addAllDefsFromConfigDir(defs, new File("src/main/resources/configdefinitions"));
            this.addAllDefsFromConfigDir(defs, new File("src/test/resources/configdefinitions"));
        }
        this.addAllDefsFromBundles(defs, FilesApplicationPackage.getComponents(this.appDir));
        return defs;
    }

    private void addAllDefsFromBundles(Map<ConfigDefinitionKey, UnparsedConfigDefinition> defs, List<Component> components) {
        for (Component component : components) {
            Bundle bundle = component.getBundle();
            for (final Bundle.DefEntry def : bundle.getDefEntries()) {
                final ConfigDefinitionKey defKey = new ConfigDefinitionKey(def.defName, def.defNamespace);
                if (defs.containsKey(defKey)) continue;
                defs.put(defKey, new UnparsedConfigDefinition(){

                    public ConfigDefinition parse() {
                        DefParser parser = new DefParser(defKey.getName(), (Reader)new StringReader(def.contents));
                        return ConfigDefinitionBuilder.createConfigDefinition((CNode)parser.getTree());
                    }

                    public String getUnparsedContent() {
                        return def.contents;
                    }
                });
            }
        }
    }

    private void addAllDefsFromConfigDir(Map<ConfigDefinitionKey, UnparsedConfigDefinition> defs, File configDefsDir) {
        if (!configDefsDir.isDirectory()) {
            return;
        }
        log.log((Level)LogLevel.DEBUG, "Getting all config definitions from '" + configDefsDir + "'");
        for (final File def : configDefsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(".*\\.def");
            }
        })) {
            ConfigDefinitionKey key;
            log.log((Level)LogLevel.DEBUG, "Processing config definition '" + def + "'");
            String[] nv = def.getName().split("\\.def");
            try {
                key = ConfigUtils.createConfigDefinitionKeyFromDefFile((File)def);
            }
            catch (IOException e) {
                e.printStackTrace();
                break;
            }
            if (key.getNamespace().isEmpty()) {
                throw new IllegalArgumentException("Config definition '" + def + "' has no namespace");
            }
            if (defs.containsKey(key)) {
                if (nv[0].contains(".")) {
                    log.log(LogLevel.INFO, "Two config definitions found for the same name and namespace: " + key + ". The file '" + def + "' will take precedence");
                } else {
                    log.log(LogLevel.INFO, "Two config definitions found for the same name and namespace: " + key + ". Skipping '" + def + "', as it does not contain namespace in filename");
                    continue;
                }
            }
            defs.put(key, new UnparsedConfigDefinition(){

                public ConfigDefinition parse() {
                    DefParser parser = new DefParser(key.getName(), FilesApplicationPackage.this.retrieveConfigDefReader(def));
                    return ConfigDefinitionBuilder.createConfigDefinition((CNode)parser.getTree());
                }

                public String getUnparsedContent() {
                    return FilesApplicationPackage.this.readConfigDefinition(def);
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readConfigDefinition(File defPath) {
        try (Reader reader = this.retrieveConfigDefReader(defPath);){
            String string = IOUtils.readAll((Reader)reader);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading config definition '" + defPath + "'", e);
        }
    }

    public Reader getServices() {
        try {
            return new FileReader(this.getServicesSource());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    static List<File> getSearchDefinitionFiles(File appDir) {
        assert (".sd".charAt(0) == '.');
        ArrayList<File> ret = new ArrayList<File>();
        File sdDir = new File(appDir, ApplicationPackage.SEARCH_DEFINITIONS_DIR.getRelative());
        if (!sdDir.isDirectory()) {
            return ret;
        }
        ret.addAll(Arrays.asList(sdDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(".*\\.sd");
            }
        })));
        return ret;
    }

    public List<File> getSearchDefinitionFiles() {
        return FilesApplicationPackage.getSearchDefinitionFiles(this.appDir);
    }

    public static List<Component> getComponents(File appDir) {
        ArrayList<Component> components = new ArrayList<Component>();
        for (Bundle bundle : Bundle.getBundles(new File(appDir, "components"))) {
            components.add(new Component(bundle, new ComponentInfo(new File("components", bundle.getFile().getName()).getPath())));
        }
        return components;
    }

    private static List<ComponentInfo> getComponentsInfo(File appDir) {
        ArrayList<ComponentInfo> components = new ArrayList<ComponentInfo>();
        for (Bundle bundle : Bundle.getBundles(new File(appDir, "components"))) {
            components.add(new ComponentInfo(new File("components", bundle.getFile().getName()).getPath()));
        }
        return components;
    }

    public List<ComponentInfo> getComponentsInfo(Version vespaVersion) {
        return FilesApplicationPackage.getComponentsInfo(this.appDir);
    }

    public List<Component> getComponents() {
        return FilesApplicationPackage.getComponents(this.appDir);
    }

    public File getAppDir() throws IOException {
        return this.appDir.getCanonicalFile();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ApplicationMetaData readMetaData(File appDir) {
        ApplicationMetaData defaultMetaData = new ApplicationMetaData(appDir, "n/a", "n/a", Long.valueOf(0L), false, "", Long.valueOf(0L), 0L);
        File metaFile = new File(appDir, META_FILE_NAME);
        if (!metaFile.exists()) {
            return defaultMetaData;
        }
        try (FileReader reader = new FileReader(metaFile);){
            ApplicationMetaData applicationMetaData = ApplicationMetaData.fromJsonString((String)IOUtils.readAll((Reader)reader));
            return applicationMetaData;
        }
        catch (Exception e) {
            return defaultMetaData;
        }
    }

    public Reader getRankingExpression(String name) {
        try {
            return IOUtils.createReader((File)this.expressionFileNameToFile(name), (String)"utf-8");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read ranking expression file '" + name + "'", e);
        }
    }

    private File expressionFileNameToFile(String name) {
        File expressionFile = new File(name);
        if (expressionFile.isAbsolute()) {
            return expressionFile;
        }
        File sdDir = new File(this.appDir, ApplicationPackage.SEARCH_DEFINITIONS_DIR.getRelative());
        return new File(sdDir, name);
    }

    public File getFileReference(Path pathRelativeToAppDir) {
        return new File(this.appDir, pathRelativeToAppDir.getRelative());
    }

    public void validateXML() throws IOException {
        this.validateXML(Optional.empty());
    }

    public void validateXML(Optional<Version> vespaVersion) throws IOException {
        com.yahoo.component.Version modelVersion = vespaVersion.map(v -> new com.yahoo.component.Version(vespaVersion.toString())).orElse(Vtag.currentVersion);
        ApplicationPackageXmlFilesValidator validator = ApplicationPackageXmlFilesValidator.create(this.appDir, modelVersion);
        validator.checkApplication();
        validator.checkIncludedDirs(this);
    }

    public void writeMetaData() throws IOException {
        File metaFile = new File(this.appDir, META_FILE_NAME);
        IOUtils.writeFile((File)metaFile, (String)this.metaData.asJsonString(), (boolean)false);
    }

    public Collection<NamedReader> getSearchDefinitions() {
        return this.searchDefinitionContents();
    }

    private void preprocessXML(File destination, File inputXml, Zone zone) throws ParserConfigurationException, TransformerException, SAXException, IOException {
        Document document = new XmlPreProcessor(this.appDir, inputXml, zone.environment(), zone.region()).run();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        try (FileOutputStream outputStream = new FileOutputStream(destination);){
            transformer.transform(new DOMSource(document), new StreamResult(outputStream));
        }
    }

    public ApplicationPackage preprocess(Zone zone, DeployLogger logger) throws IOException, TransformerException, ParserConfigurationException, SAXException {
        IOUtils.recursiveDeleteDir((File)this.preprocessedDir);
        IOUtils.copyDirectory((File)this.appDir, (File)this.preprocessedDir, (int)-1, (dir, name) -> !name.equals(preprocessed) && !name.equals("services.xml") && !name.equals("hosts.xml") && !name.equals("configdefinitions"));
        this.preprocessXML(new File(this.preprocessedDir, "services.xml"), this.getServicesFile(), zone);
        if (this.getHostsFile().exists()) {
            this.preprocessXML(new File(this.preprocessedDir, "hosts.xml"), this.getHostsFile(), zone);
        }
        FilesApplicationPackage preprocessed = FilesApplicationPackage.fromFile(this.preprocessedDir, this.includeSourceFiles);
        preprocessed.copyUserDefsIntoApplication();
        return preprocessed;
    }

    private void copyUserDefsIntoApplication() {
        File destination = this.appSubDirs.configDefs();
        destination.mkdir();
        ConfigDefinitionDir defDir = new ConfigDefinitionDir(destination);
        ArrayList<Bundle> bundlesAdded = new ArrayList<Bundle>();
        for (Component component : FilesApplicationPackage.getComponents(this.appSubDirs.root())) {
            Bundle bundle = component.getBundle();
            defDir.addConfigDefinitionsFromBundle(bundle, bundlesAdded);
            bundlesAdded.add(bundle);
        }
    }

    private static String computeCheckSum(File appDir) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            for (File file : appDir.listFiles((dir, name) -> !name.equals("ext") && !name.startsWith("."))) {
                FilesApplicationPackage.addPathToDigest(file, "", md5, true, false);
            }
            return Lowercase.toLowerCase((String)HexDump.toHexString((byte[])md5.digest()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void addPathToDigest(File path, String suffix, MessageDigest digest, boolean recursive, boolean fullPathNames) throws IOException {
        File[] files;
        if (!path.exists()) {
            return;
        }
        if (fullPathNames) {
            digest.update(path.getPath().getBytes(Utf8.getCharset()));
        } else {
            digest.update(path.getName().getBytes(Utf8.getCharset()));
        }
        if (path.isFile()) {
            FileInputStream is = new FileInputStream(path);
            FilesApplicationPackage.addToDigest(is, digest);
            is.close();
        } else if (path.isDirectory() && (files = path.listFiles()) != null) {
            for (File elem : files) {
                if ((!elem.isDirectory() || !recursive) && !elem.getName().endsWith(suffix)) continue;
                FilesApplicationPackage.addPathToDigest(elem, suffix, digest, recursive, fullPathNames);
            }
        }
    }

    private static void addToDigest(InputStream is, MessageDigest digest) throws IOException {
        int i;
        if (is == null) {
            return;
        }
        byte[] buffer = new byte[65536];
        do {
            if ((i = is.read(buffer)) <= 0) continue;
            digest.update(buffer, 0, i);
        } while (i != -1);
    }

    public static class Builder {
        private final File appDir;
        private Optional<File> preprocessedDir = Optional.empty();
        private Optional<ApplicationMetaData> metaData = Optional.empty();
        private boolean includeSourceFiles = false;

        public Builder(File appDir) {
            this.appDir = appDir;
        }

        public Builder preprocessedDir(File preprocessedDir) {
            this.preprocessedDir = Optional.ofNullable(preprocessedDir);
            return this;
        }

        public Builder deployData(DeployData deployData) {
            this.metaData = Optional.of(FilesApplicationPackage.metaDataFromDeployData(this.appDir, deployData));
            return this;
        }

        public Builder includeSourceFiles(boolean includeSourceFiles) {
            this.includeSourceFiles = includeSourceFiles;
            return this;
        }

        public FilesApplicationPackage build() {
            return new FilesApplicationPackage(this.appDir, this.preprocessedDir.orElse(new File(this.appDir, FilesApplicationPackage.preprocessed)), this.metaData.orElse(FilesApplicationPackage.readMetaData(this.appDir)), this.includeSourceFiles);
        }
    }

    public static class Component {
        public final ComponentInfo info;
        private final Bundle bundle;

        public Component(Bundle bundle, ComponentInfo info) {
            this.bundle = bundle;
            this.info = info;
        }

        public List<Bundle.DefEntry> getDefEntries() {
            return this.bundle.getDefEntries();
        }

        public Bundle getBundle() {
            return this.bundle;
        }
    }
}

