/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application;

import com.yahoo.config.application.IncludeProcessor;
import com.yahoo.config.application.OverrideProcessor;
import com.yahoo.config.application.PreProcessor;
import com.yahoo.config.application.PropertiesProcessor;
import com.yahoo.config.application.Xml;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.RegionName;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlPreProcessor {
    static final String deployNamespace = "xmlns:deploy";
    static final String deployNamespaceUri = "vespa";
    static final String preprocessNamespace = "xmlns:preprocess";
    static final String preprocessNamespaceUri = "properties";
    private final File applicationDir;
    private final Reader xmlInput;
    private final Environment environment;
    private final RegionName region;
    private final List<PreProcessor> chain;

    public XmlPreProcessor(File applicationDir, File xmlInput, Environment environment, RegionName region) throws IOException {
        this(applicationDir, new FileReader(xmlInput), environment, region);
    }

    public XmlPreProcessor(File applicationDir, Reader xmlInput, Environment environment, RegionName region) throws IOException {
        this.applicationDir = applicationDir;
        this.xmlInput = xmlInput;
        this.environment = environment;
        this.region = region;
        this.chain = this.setupChain();
    }

    public Document run() throws ParserConfigurationException, IOException, SAXException, TransformerException {
        DocumentBuilder docBuilder = Xml.getPreprocessDocumentBuilder();
        Document document = docBuilder.parse(new InputSource(this.xmlInput));
        return this.execute(document);
    }

    private Document execute(Document input) throws IOException, TransformerException {
        for (PreProcessor preProcessor : this.chain) {
            input = preProcessor.process(input);
        }
        return input;
    }

    private List<PreProcessor> setupChain() throws IOException {
        ArrayList<PreProcessor> chain = new ArrayList<PreProcessor>();
        chain.add(new IncludeProcessor(this.applicationDir));
        chain.add(new OverrideProcessor(this.environment, this.region));
        chain.add(new PropertiesProcessor());
        return chain;
    }
}

