/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.component;

import com.yahoo.collections.MethodCache;
import com.yahoo.component.Component;
import com.yahoo.component.ComponentId;
import com.yahoo.protect.Process;
import java.lang.reflect.Method;

public class AbstractComponent
implements Component {
    private static final MethodCache deconstructMethods = new MethodCache("deconstruct");
    private ComponentId id;
    private final String className = this.getClass().getName();
    protected final boolean isDeconstructable;

    protected AbstractComponent() {
        this.isDeconstructable = this.setIsDeconstructable();
    }

    protected AbstractComponent(ComponentId id) {
        this.initId(id);
        this.isDeconstructable = this.setIsDeconstructable();
    }

    @Override
    public final void initId(ComponentId id) {
        if (this.id != null && !this.id.equals(id)) {
            throw new RuntimeException("Can't change component id: " + this.id + " -> " + id);
        }
        if (id == null) {
            throw new NullPointerException("A component cannot be created with a null id");
        }
        this.id = id;
    }

    @Override
    public final ComponentId getId() {
        if (this.id == null) {
            this.setTestId();
        }
        return this.id;
    }

    private void setTestId() {
        this.id = ComponentId.createAnonymousComponentId("test_" + this.getClass().getName());
    }

    public final boolean hasInitializedId() {
        return this.id != null;
    }

    public final String getIdString() {
        if (this.hasInitializedId()) {
            return this.getId().toString();
        }
        return "(anonymous)";
    }

    public String getClassName() {
        return this.className;
    }

    public String toString() {
        return "'" + this.getIdString() + "' of class '" + this.className + "'";
    }

    public AbstractComponent clone() {
        try {
            AbstractComponent clone = (AbstractComponent)super.clone();
            clone.id = null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("'" + this + "' is not clonable", e);
        }
    }

    @Override
    public int compareTo(Component other) {
        return this.id.compareTo(other.getId());
    }

    public void deconstruct() {
    }

    public final boolean isDeconstructable() {
        return this.isDeconstructable;
    }

    protected boolean setIsDeconstructable() {
        Class<?> declaringClass;
        Method deconstruct = deconstructMethods.get((Object)this);
        if (deconstruct == null) {
            Process.logAndDie((String)("Component " + this + " does not have method deconstruct() - impossible!"));
        }
        return (declaringClass = deconstruct.getDeclaringClass()) != AbstractComponent.class;
    }
}

