/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.component;

import com.yahoo.component.ComponentId;
import java.util.Arrays;
import java.util.List;

class SpecSplitter {
    final String name;
    final String version;
    final ComponentId namespace;

    SpecSplitter(String spec) {
        List<String> idAndNamespace = SpecSplitter.splitFirst(spec, '@');
        List<String> nameAndVersion = SpecSplitter.splitFirst(idAndNamespace.get(0), ':');
        this.name = nameAndVersion.get(0);
        this.version = this.second(nameAndVersion);
        this.namespace = ComponentId.fromString(this.second(idAndNamespace));
    }

    private String second(List<String> components) {
        return components.size() == 2 ? components.get(1) : null;
    }

    private static List<String> splitFirst(String string, char c) {
        int index = string.indexOf(c);
        if (index != -1) {
            if (index == string.length() - 1) {
                throw new RuntimeException("Expected characters after '" + c + "'");
            }
            return Arrays.asList(string.substring(0, index), string.substring(index + 1));
        }
        return Arrays.asList(string, null);
    }
}

