/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.utils.communication.async;

import com.yahoo.vespa.clustercontroller.utils.communication.async.AsyncCallback;
import com.yahoo.vespa.clustercontroller.utils.communication.async.AsyncOperation;
import com.yahoo.vespa.clustercontroller.utils.communication.async.AsyncOperationListenImpl;

public abstract class RedirectedAsyncOperation<S, T>
implements AsyncOperation<T> {
    protected final AsyncOperation<S> source;
    private final AsyncOperationListenImpl<T> listenImpl;

    public RedirectedAsyncOperation(AsyncOperation<S> source) {
        this.source = source;
        this.listenImpl = new AsyncOperationListenImpl(this);
        source.register(new AsyncCallback<S>(){

            @Override
            public void done(AsyncOperation<S> op) {
                RedirectedAsyncOperation.this.notifyDone();
            }
        });
    }

    private void notifyDone() {
        this.listenImpl.notifyListeners();
    }

    @Override
    public String getName() {
        return this.source.getName();
    }

    @Override
    public String getDescription() {
        return this.source.getDescription();
    }

    @Override
    public boolean cancel() {
        return this.source.cancel();
    }

    @Override
    public boolean isCanceled() {
        return this.source.isCanceled();
    }

    @Override
    public boolean isDone() {
        return this.source.isDone();
    }

    @Override
    public boolean isSuccess() {
        return this.source.isSuccess();
    }

    @Override
    public Double getProgress() {
        return this.source.getProgress();
    }

    @Override
    public Exception getCause() {
        return this.source.getCause();
    }

    @Override
    public void register(AsyncCallback<T> callback) {
        this.listenImpl.register(callback);
    }

    @Override
    public void unregister(AsyncCallback<T> callback) {
        this.listenImpl.unregister(callback);
    }
}

