/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.utils.communication.http;

import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpResult;
import com.yahoo.vespa.clustercontroller.utils.util.JSONObjectWrapper;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JsonHttpResult
extends HttpResult {
    private JSONObject json;
    private boolean failedParsing = false;

    public JsonHttpResult() {
        this.addHeader("Content-Type", "application/json");
    }

    public JsonHttpResult(HttpResult other) {
        super(other);
        if (other.getContent() == null) {
            this.setParsedJson(new JSONObject());
            return;
        }
        try {
            if (other.getContent() instanceof JSONObject) {
                this.setParsedJson((JSONObject)other.getContent());
            } else {
                this.setParsedJson(new JSONObject(other.getContent().toString()));
            }
        }
        catch (JSONException e) {
            this.failedParsing = true;
            this.setParsedJson(this.createErrorJson(e.getMessage(), other));
        }
    }

    private JSONObject createErrorJson(String error, HttpResult other) {
        return new JSONObjectWrapper().put("error", "Invalid JSON in output: " + error).put("output", other.getContent().toString());
    }

    public JsonHttpResult setJson(JSONObject o) {
        this.setContent(o);
        this.json = o;
        return this;
    }

    private void setParsedJson(JSONObject o) {
        this.json = o;
    }

    public JSONObject getJson() {
        return this.json;
    }

    @Override
    public void printContent(StringBuilder sb) {
        if (this.failedParsing) {
            super.printContent(sb);
            return;
        }
        if (this.json != null) {
            sb.append("JSON: ");
            try {
                sb.append(this.json.toString(2));
            }
            catch (JSONException e) {
                sb.append(this.json.toString());
            }
        } else {
            super.printContent(sb);
        }
    }
}

