/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.utils.communication.http;

import com.yahoo.vespa.clustercontroller.utils.communication.async.AsyncCallback;
import com.yahoo.vespa.clustercontroller.utils.communication.async.AsyncOperation;
import com.yahoo.vespa.clustercontroller.utils.communication.async.AsyncOperationImpl;
import com.yahoo.vespa.clustercontroller.utils.communication.http.AsyncHttpClient;
import com.yahoo.vespa.clustercontroller.utils.communication.http.AsyncHttpClientWithBase;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpRequest;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpResult;
import com.yahoo.vespa.clustercontroller.utils.util.Clock;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

public class TimeoutHandler<V extends HttpResult>
extends AsyncHttpClientWithBase<V> {
    private static final Logger log = Logger.getLogger(TimeoutHandler.class.getName());
    private final TreeMap<Long, InternalRequest> requests = new TreeMap();
    private final ChangeLogger changeLogger = new ChangeLogger();
    private final Clock clock;
    private boolean run = true;
    private Runnable timeoutHandler = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.fine("Starting timeout monitor thread");
            while (true) {
                TimeoutHandler.this.performTimeoutHandlerTick();
                Clock clock = TimeoutHandler.this.clock;
                synchronized (clock) {
                    try {
                        TimeoutHandler.this.clock.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!TimeoutHandler.this.run) {
                        break;
                    }
                }
            }
            log.fine("Stopped timeout monitor thread");
        }
    };

    public TimeoutHandler(Executor executor, Clock clock, AsyncHttpClient<V> client) {
        super(client);
        this.clock = clock;
        executor.execute(this.timeoutHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.clock;
        synchronized (object) {
            this.run = false;
            this.clock.notifyAll();
        }
        object = this.requests;
        synchronized (object) {
            for (InternalRequest r : this.requests.values()) {
                r.operation.cancel();
                r.setFailure(new TimeoutException("Timeout handler shutting down. Shutting down all requests monitored."));
            }
            this.requests.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncOperation<V> execute(HttpRequest r) {
        AsyncOperation op = super.execute(r);
        InternalRequest request = new InternalRequest(op, this.clock.getTimeInMillis(), r.getTimeoutMillis());
        TreeMap<Long, InternalRequest> treeMap = this.requests;
        synchronized (treeMap) {
            this.requests.put(request.getTimeoutTime(), request);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performTimeoutHandlerTick() {
        TreeMap<Long, InternalRequest> treeMap = this.requests;
        synchronized (treeMap) {
            this.removeCompletedRequestsFromTimeoutList();
            this.handleTimeoutsAtTime(this.clock.getTimeInMillis());
            this.changeLogger.logChanges(this.requests);
        }
    }

    private void removeCompletedRequestsFromTimeoutList() {
        while (!this.requests.isEmpty() && this.requests.firstEntry().getValue().operation.isDone()) {
            this.requests.remove(this.requests.firstEntry().getKey());
            log.finest("Removed completed request from operation timeout list.");
        }
    }

    private void handleTimeoutsAtTime(long currentTime) {
        SortedMap<Long, InternalRequest> timeouts = this.requests.subMap(0L, currentTime + 1L);
        for (InternalRequest r : timeouts.values()) {
            r.handleTimeout(currentTime);
            this.requests.values().remove(r);
        }
    }

    public static class ChangeLogger {
        private InternalRequest lastTimeoutLogged = null;
        private boolean emptyLogged = true;

        public void logChanges(TreeMap<Long, InternalRequest> requests) {
            if (requests.isEmpty()) {
                if (!this.emptyLogged) {
                    log.finest("No more pending requests currently.");
                    this.emptyLogged = true;
                }
            } else {
                this.emptyLogged = false;
                InternalRequest r = requests.firstEntry().getValue();
                if (this.lastTimeoutLogged == null || !this.lastTimeoutLogged.equals(r)) {
                    this.lastTimeoutLogged = r;
                    log.finest("Next operation to possibly timeout will do so at " + r.getTimeoutTime());
                }
            }
        }
    }

    public static class InternalRequest<V extends HttpResult>
    extends AsyncOperationImpl<V> {
        final AsyncOperation<V> operation;
        long startTime;
        long timeout;

        public InternalRequest(AsyncOperation<V> op, long startTime, long timeout) {
            super(op.getName(), op.getDescription());
            this.operation = op;
            this.startTime = startTime;
            this.timeout = timeout;
            op.register(new AsyncCallback<V>(){

                @Override
                public void done(AsyncOperation<V> op) {
                    if (!this.isDone()) {
                        if (op.isSuccess()) {
                            this.setResult(op.getResult());
                        } else {
                            this.setFailure(op.getCause(), op.getResult());
                        }
                    }
                }
            });
        }

        public long getTimeoutTime() {
            return this.startTime + this.timeout;
        }

        public void handleTimeout(long currentTime) {
            long timePassed = currentTime - this.startTime;
            this.setFailure(new TimeoutException("Operation timeout. " + timePassed + " ms since operation was issued. Timeout was " + this.timeout + " ms."));
            this.operation.cancel();
        }

        @Override
        public boolean cancel() {
            return this.operation.cancel();
        }

        @Override
        public boolean isCanceled() {
            return this.operation.isCanceled();
        }

        @Override
        public Double getProgress() {
            return this.isDone() ? Double.valueOf(1.0) : this.operation.getProgress();
        }
    }
}

