/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.rpc;

import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.vespa.clustercontroller.core.Communicator;
import com.yahoo.vespa.clustercontroller.core.GetNodeStateRequest;
import com.yahoo.vespa.clustercontroller.core.rpc.RPCGetNodeStateRequest;

public class RPCGetNodeStateWaiter
implements RequestWaiter {
    private final RPCGetNodeStateRequest request;
    private final Communicator.Waiter<GetNodeStateRequest> waiter;

    public RPCGetNodeStateWaiter(RPCGetNodeStateRequest request, Communicator.Waiter<GetNodeStateRequest> waiter) {
        this.request = request;
        this.waiter = waiter;
    }

    private GetNodeStateRequest.Reply convertToReply(Request req) {
        if (req.isError()) {
            return new GetNodeStateRequest.Reply(req.errorCode(), req.errorMessage());
        }
        if (req.methodName().equals("getnodestate3")) {
            String stateStr = "";
            String hostInfo = "";
            if (req.returnValues().satisfies("s*")) {
                stateStr = req.returnValues().get(0).asString();
            }
            if (req.returnValues().satisfies("ss*")) {
                hostInfo = req.returnValues().get(1).asString();
            }
            return new GetNodeStateRequest.Reply(stateStr, hostInfo);
        }
        return new GetNodeStateRequest.Reply(110, "Unknown method name " + req.methodName());
    }

    public void handleRequestDone(Request req) {
        this.request.setReply(this.convertToReply(req));
        this.waiter.done(this.request);
    }
}

