/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.status.statuspage;

import com.yahoo.vespa.clustercontroller.core.status.statuspage.StatusPageResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StatusPageServer {
    public static Logger log = Logger.getLogger(StatusPageServer.class.getName());

    public static class PatternRequestRouter
    implements RequestRouter {
        private final List<PatternRouting> patterns = new ArrayList<PatternRouting>();

        public void addHandler(RequestHandler handler) {
            this.patterns.add(new PatternRouting(Pattern.compile(handler.pattern()), handler));
        }

        @Override
        public RequestHandler resolveHandler(HttpRequest request) {
            for (PatternRouting routing : this.patterns) {
                Matcher m = routing.pattern.matcher(request.getPath());
                if (!m.matches()) continue;
                return routing.handler;
            }
            return null;
        }

        private static class PatternRouting {
            public Pattern pattern;
            public RequestHandler handler;

            private PatternRouting(Pattern pattern, RequestHandler handler) {
                this.pattern = pattern;
                this.handler = handler;
            }
        }
    }

    public static interface RequestRouter {
        public RequestHandler resolveHandler(HttpRequest var1);
    }

    public static interface RequestHandler {
        public StatusPageResponse handle(HttpRequest var1);

        public String pattern();
    }

    public static class HttpRequest {
        private final String request;
        private final String path;
        static Pattern pathPattern = Pattern.compile("^(/([\\w=./]+)?)(?:\\?((?:&?\\w+(?:=[\\w.]*)?)*))?$");

        public HttpRequest(String request) {
            this.request = request;
            Matcher m = pathPattern.matcher(request);
            if (!m.matches()) {
                throw new IllegalArgumentException("Illegal HTTP request path: " + request);
            }
            this.path = m.group(1);
        }

        public String toString() {
            return "HttpRequest(" + this.request + ")";
        }

        public String getRequest() {
            return this.request;
        }

        public String getPath() {
            return this.path;
        }
    }
}

