/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vdslib.distribution.ConfiguredNode;
import com.yahoo.vdslib.distribution.Distribution;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vespa.clustercontroller.core.ContentCluster;
import com.yahoo.vespa.clustercontroller.core.DistributorNodeInfo;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.StorageNodeInfo;
import com.yahoo.vespa.clustercontroller.core.listeners.NodeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

public class ClusterInfo {
    private final Map<Integer, ConfiguredNode> nodes = new HashMap<Integer, ConfiguredNode>();
    private final Map<Integer, DistributorNodeInfo> distributorNodeInfo = new TreeMap<Integer, DistributorNodeInfo>();
    private final Map<Integer, StorageNodeInfo> storageNodeInfo = new TreeMap<Integer, StorageNodeInfo>();
    private final Map<Node, NodeInfo> allNodeInfo = new TreeMap<Node, NodeInfo>();

    DistributorNodeInfo getDistributorNodeInfo(int index) {
        return this.distributorNodeInfo.get(index);
    }

    StorageNodeInfo getStorageNodeInfo(int index) {
        return this.storageNodeInfo.get(index);
    }

    public NodeInfo getNodeInfo(Node node) {
        return this.allNodeInfo.get(node);
    }

    Collection<DistributorNodeInfo> getDistributorNodeInfos() {
        return Collections.unmodifiableCollection(this.distributorNodeInfo.values());
    }

    Collection<StorageNodeInfo> getStorageNodeInfos() {
        return Collections.unmodifiableCollection(this.storageNodeInfo.values());
    }

    Collection<NodeInfo> getAllNodeInfos() {
        return Collections.unmodifiableCollection(this.allNodeInfo.values());
    }

    Map<Integer, ConfiguredNode> getConfiguredNodes() {
        return Collections.unmodifiableMap(this.nodes);
    }

    boolean hasConfiguredNode(int index) {
        return this.nodes.containsKey(index);
    }

    void setNodes(Collection<ConfiguredNode> newNodes, ContentCluster owner, Distribution distribution, NodeListener nodeListener) {
        HashSet<ConfiguredNode> newNodesSet = new HashSet<ConfiguredNode>(newNodes);
        for (ConfiguredNode existingNode : this.nodes.values()) {
            if (newNodesSet.contains(existingNode)) continue;
            Node existingStorageNode = this.storageNodeInfo.remove(existingNode.index()).getNode();
            this.allNodeInfo.remove(existingStorageNode);
            nodeListener.handleRemovedNode(existingStorageNode);
            Node existingDistributorNode = this.distributorNodeInfo.remove(existingNode.index()).getNode();
            this.allNodeInfo.remove(existingDistributorNode);
            nodeListener.handleRemovedNode(existingDistributorNode);
        }
        for (ConfiguredNode node : newNodes) {
            if (!this.nodes.containsKey(node.index())) {
                this.addNodeInfo(new DistributorNodeInfo(owner, node.index(), null, distribution));
                this.addNodeInfo(new StorageNodeInfo(owner, node.index(), node.retired(), null, distribution));
                continue;
            }
            this.getStorageNodeInfo(node.index()).setConfiguredRetired(node.retired());
        }
        this.nodes.clear();
        for (ConfiguredNode node : newNodes) {
            this.nodes.put(node.index(), node);
        }
    }

    private void addNodeInfo(NodeInfo nodeInfo) {
        if (nodeInfo instanceof DistributorNodeInfo) {
            this.distributorNodeInfo.put(nodeInfo.getNodeIndex(), (DistributorNodeInfo)nodeInfo);
        } else {
            this.storageNodeInfo.put(nodeInfo.getNodeIndex(), (StorageNodeInfo)nodeInfo);
        }
        this.allNodeInfo.put(nodeInfo.getNode(), nodeInfo);
        nodeInfo.setReportedState(nodeInfo.getReportedState().setDescription("Node missing."), 0L);
    }

    boolean allStatesReported() {
        if (this.nodes.isEmpty()) {
            return false;
        }
        for (ConfiguredNode node : this.nodes.values()) {
            if (this.getDistributorNodeInfo(node.index()).getReportedState().getState().oneOf("d-")) {
                return false;
            }
            if (!this.getStorageNodeInfo(node.index()).getReportedState().getState().oneOf("d-")) continue;
            return false;
        }
        return true;
    }

    public NodeInfo setRpcAddress(Node node, String rpcAddress) {
        NodeInfo nodeInfo = this.getInfo(node);
        if (nodeInfo != null) {
            nodeInfo.setRpcAddress(rpcAddress);
        }
        return nodeInfo;
    }

    private NodeInfo getInfo(Node node) {
        return switch (node.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case NodeType.DISTRIBUTOR -> this.getDistributorNodeInfo(node.getIndex());
            case NodeType.STORAGE -> this.getStorageNodeInfo(node.getIndex());
        };
    }
}

