/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.restapiv2.requests;

import com.yahoo.time.TimeBudget;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.ContentCluster;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.NodeStateChangeChecker;
import com.yahoo.vespa.clustercontroller.core.RemoteClusterControllerTask;
import com.yahoo.vespa.clustercontroller.core.listeners.NodeListener;
import com.yahoo.vespa.clustercontroller.core.restapiv2.Id;
import com.yahoo.vespa.clustercontroller.core.restapiv2.MissingIdException;
import com.yahoo.vespa.clustercontroller.core.restapiv2.Request;
import com.yahoo.vespa.clustercontroller.core.restapiv2.requests.WantedStateSetter;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.InvalidContentException;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.StateRestApiException;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.requests.SetUnitStateRequest;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.SetResponse;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.UnitState;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SetNodeStateRequest
extends Request<SetResponse> {
    private static final Logger log = Logger.getLogger(SetNodeStateRequest.class.getName());
    private final Id.Node id;
    private final Map<String, UnitState> newStates;
    private final SetUnitStateRequest.Condition condition;
    private final SetUnitStateRequest.ResponseWait responseWait;
    private final WantedStateSetter wantedState;
    private final TimeBudget timeBudget;
    private final boolean probe;

    public SetNodeStateRequest(Id.Node id, SetUnitStateRequest setUnitStateRequest) {
        this(id, setUnitStateRequest, SetNodeStateRequest::setWantedState);
    }

    public SetNodeStateRequest(Id.Node id, SetUnitStateRequest setUnitStateRequest, WantedStateSetter wantedState) {
        super(Request.MasterState.MUST_BE_MASTER);
        this.id = id;
        this.newStates = setUnitStateRequest.getNewState();
        this.condition = setUnitStateRequest.getCondition();
        this.responseWait = setUnitStateRequest.getResponseWait();
        this.wantedState = wantedState;
        this.timeBudget = setUnitStateRequest.timeBudget();
        this.probe = setUnitStateRequest.isProbe();
    }

    @Override
    public SetResponse calculateResult(RemoteClusterControllerTask.Context context) throws StateRestApiException {
        return this.wantedState.set(context.cluster, this.condition, this.newStates, this.id.getNode(), context.nodeListener, context.currentConsolidatedState, context.masterInfo.inMasterMoratorium(), this.probe);
    }

    static NodeState getRequestedNodeState(Map<String, UnitState> newStates, Node n) throws StateRestApiException {
        UnitState newState = newStates.get("user");
        if (newState == null) {
            throw new InvalidContentException("No new user state given in request");
        }
        State state = switch (newState.id().toLowerCase()) {
            case "up" -> State.UP;
            case "retired" -> State.RETIRED;
            case "maintenance" -> State.MAINTENANCE;
            case "down" -> State.DOWN;
            default -> throw new InvalidContentException("Invalid user state '" + newState.id() + "' given.");
        };
        return new NodeState(n.getType(), state).setDescription(newState.reason());
    }

    @Override
    public boolean hasVersionAckDependency() {
        return this.responseWait == SetUnitStateRequest.ResponseWait.WAIT_UNTIL_CLUSTER_ACKED;
    }

    @Override
    public Optional<Instant> getDeadline() {
        return this.timeBudget.deadline();
    }

    @Override
    public boolean isFailed() {
        return super.isFailed() || this.resultSet && !((SetResponse)this.result).getWasModified();
    }

    @Override
    public String toString() {
        return "SetNodeStateRequest{node=" + String.valueOf(this.id) + ",newState=" + String.valueOf(this.newStates.get("user")) + "," + (String)(this.probe ? "probe=" + this.probe + "," : "") + "}";
    }

    static SetResponse setWantedState(ContentCluster cluster, SetUnitStateRequest.Condition condition, Map<String, UnitState> newStates, Node node, NodeListener stateListener, ClusterState currentClusterState, boolean inMasterMoratorium, boolean probe) throws StateRestApiException {
        if (!cluster.hasConfiguredNode(node.getIndex())) {
            throw new MissingIdException(cluster.getName(), node);
        }
        NodeInfo nodeInfo = cluster.getNodeInfo(node);
        if (nodeInfo == null) {
            throw new IllegalArgumentException("Cannot set the wanted state of unknown node " + String.valueOf(node));
        }
        NodeState wantedState = nodeInfo.getUserWantedState();
        NodeState newWantedState = SetNodeStateRequest.getRequestedNodeState(newStates, node);
        NodeStateChangeChecker.Result result = cluster.calculateEffectOfNewState(node, currentClusterState, condition, wantedState, newWantedState, inMasterMoratorium);
        log.log(Level.FINE, () -> "node=" + String.valueOf(node) + " current-cluster-state=" + String.valueOf(currentClusterState) + " condition=" + String.valueOf(condition) + " wanted-state=" + String.valueOf(wantedState) + " new-wanted-state=" + String.valueOf(newWantedState) + " change-check=" + String.valueOf(result));
        boolean success = SetNodeStateRequest.setWantedStateAccordingToResult(result, newWantedState, condition, nodeInfo, cluster, stateListener, probe);
        String reason = success ? "ok" : result.reason();
        return new SetResponse(reason, success);
    }

    private static boolean setWantedStateAccordingToResult(NodeStateChangeChecker.Result result, NodeState newWantedState, SetUnitStateRequest.Condition condition, NodeInfo nodeInfo, ContentCluster cluster, NodeListener stateListener, boolean probe) {
        boolean success;
        if (result.allowed()) {
            SetNodeStateRequest.setNewWantedState(nodeInfo, newWantedState, stateListener, probe);
        }
        boolean bl = success = result.allowed() || result.isAlreadySet();
        if (success && condition == SetUnitStateRequest.Condition.SAFE && nodeInfo.isStorage()) {
            SetNodeStateRequest.setDistributorWantedState(cluster, nodeInfo.getNodeIndex(), newWantedState, stateListener, probe);
        }
        return success;
    }

    private static void setDistributorWantedState(ContentCluster cluster, int index, NodeState newStorageWantedState, NodeListener stateListener, boolean probe) {
        State newState;
        Node distributorNode = new Node(NodeType.DISTRIBUTOR, index);
        NodeInfo nodeInfo = cluster.getNodeInfo(distributorNode);
        if (nodeInfo == null) {
            throw new IllegalStateException("Missing distributor at index " + distributorNode.getIndex());
        }
        switch (newStorageWantedState.getState()) {
            case MAINTENANCE: {
                newState = State.DOWN;
                break;
            }
            case RETIRED: {
                newState = State.UP;
                break;
            }
            default: {
                newState = newStorageWantedState.getState();
                if (newState.validWantedNodeState(distributorNode.getType())) break;
                throw new IllegalStateException("Distributor cannot be set to wanted state " + String.valueOf(newState));
            }
        }
        NodeState newWantedState = new NodeState(distributorNode.getType(), newState);
        newWantedState.setDescription(newStorageWantedState.getDescription());
        NodeState currentWantedState = nodeInfo.getUserWantedState();
        if (newWantedState.getState() != currentWantedState.getState() || !Objects.equals(newWantedState.getDescription(), currentWantedState.getDescription())) {
            SetNodeStateRequest.setNewWantedState(nodeInfo, newWantedState, stateListener, probe);
        }
    }

    private static void setNewWantedState(NodeInfo nodeInfo, NodeState newWantedState, NodeListener stateListener, boolean probe) {
        if (probe) {
            return;
        }
        nodeInfo.setWantedState(newWantedState);
        stateListener.handleNewWantedNodeState(nodeInfo, newWantedState);
    }
}

