/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vespa.clustercontroller.core.ClusterStateBundle;
import com.yahoo.vespa.clustercontroller.core.ClusterStateHistoryEntry;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ClusterStateHistory {
    private final LinkedList<ClusterStateHistoryEntry> stateHistory = new LinkedList();
    private int maxHistoryEntryCount = 50;
    private ClusterStateBundle prevStateBundle = null;

    void setMaxHistoryEntryCount(int maxHistoryEntryCount) {
        this.maxHistoryEntryCount = maxHistoryEntryCount;
    }

    List<ClusterStateHistoryEntry> getHistory() {
        return Collections.unmodifiableList(this.stateHistory);
    }

    public void add(ClusterStateBundle currentClusterState, long currentTimeMs) {
        if (this.prevStateBundle != null) {
            this.stateHistory.addFirst(ClusterStateHistoryEntry.makeSuccessor(currentClusterState, this.prevStateBundle, currentTimeMs));
        } else {
            this.stateHistory.addFirst(ClusterStateHistoryEntry.makeFirstEntry(currentClusterState, currentTimeMs));
        }
        this.prevStateBundle = currentClusterState;
        while (this.stateHistory.size() > this.maxHistoryEntryCount) {
            this.stateHistory.removeLast();
        }
    }
}

