/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vespa.clustercontroller.core.hostinfo.ResponseStats;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ContentNodeErrorStats {
    private final int nodeIndex;
    private final Map<Integer, DistributorErrorStats> statsFromDistributors;

    public ContentNodeErrorStats(int nodeIndex) {
        this.nodeIndex = nodeIndex;
        this.statsFromDistributors = new HashMap<Integer, DistributorErrorStats>();
    }

    public ContentNodeErrorStats(int nodeIndex, Map<Integer, DistributorErrorStats> statsFromDistributors) {
        this.nodeIndex = nodeIndex;
        this.statsFromDistributors = statsFromDistributors;
    }

    public int getNodeIndex() {
        return this.nodeIndex;
    }

    public void addErrorStatsFrom(int distributorIndex, ContentNodeErrorStats stats) {
        this.mergeErrorStatsFrom(distributorIndex, stats, 1);
    }

    public void subtractErrorStatsFrom(int distributorIndex, ContentNodeErrorStats stats) {
        this.mergeErrorStatsFrom(distributorIndex, stats, -1);
    }

    private void mergeErrorStatsFrom(int distributorIndex, ContentNodeErrorStats stats, int factor) {
        DistributorErrorStats existing = this.statsFromDistributors.get(distributorIndex);
        DistributorErrorStats newStats = stats.statsFromDistributors.get(distributorIndex);
        if (existing == null && newStats != null && factor == 1) {
            existing = DistributorErrorStats.createEmpty();
            this.statsFromDistributors.put(distributorIndex, existing);
        }
        if (existing != null) {
            if (newStats != null) {
                existing.merge(newStats, factor);
            }
            if (factor == -1 && !existing.hasErrors()) {
                this.statsFromDistributors.remove(distributorIndex);
            }
        }
    }

    public Map<Integer, DistributorErrorStats> getStatsFromDistributors() {
        return this.statsFromDistributors;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentNodeErrorStats that = (ContentNodeErrorStats)o;
        return Objects.equals(this.statsFromDistributors, that.statsFromDistributors);
    }

    public int hashCode() {
        return Objects.hashCode(this.statsFromDistributors);
    }

    public String toString() {
        return String.format("{statsFromDistributors=[%s]}", Arrays.toString(this.statsFromDistributors.entrySet().toArray()));
    }

    public static class DistributorErrorStats {
        private long responsesTotal;
        private long networkErrors;

        public DistributorErrorStats(long responsesTotal, long networkErrors) {
            this.responsesTotal = responsesTotal;
            this.networkErrors = networkErrors;
        }

        public static DistributorErrorStats createEmpty() {
            return new DistributorErrorStats(0L, 0L);
        }

        public void add(DistributorErrorStats rhs) {
            this.networkErrors += rhs.networkErrors;
            this.responsesTotal += rhs.responsesTotal;
        }

        public void subtract(DistributorErrorStats rhs) {
            this.networkErrors -= rhs.networkErrors;
            this.responsesTotal -= rhs.responsesTotal;
        }

        public void merge(DistributorErrorStats rhs, int factor) {
            if (factor == 1) {
                this.add(rhs);
            } else {
                this.subtract(rhs);
            }
        }

        public long responsesTotal() {
            return this.responsesTotal;
        }

        public long networkErrors() {
            return this.networkErrors;
        }

        public double networkErrorRatio() {
            if (this.responsesTotal == 0L) {
                return 0.0;
            }
            return (double)this.networkErrors / (double)this.responsesTotal;
        }

        public boolean hasErrors() {
            return this.networkErrors > 0L;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DistributorErrorStats that = (DistributorErrorStats)o;
            return this.responsesTotal == that.responsesTotal && this.networkErrors == that.networkErrors;
        }

        public int hashCode() {
            return Objects.hash(this.responsesTotal, this.networkErrors);
        }

        public String toString() {
            return "DistributorErrorStats{responsesTotal=" + this.responsesTotal + ", networkErrors=" + this.networkErrors + "}";
        }

        public static DistributorErrorStats fromHostInfoStats(ResponseStats hostInfoStats) {
            return new DistributorErrorStats(hostInfoStats.totalResponseCount(), hostInfoStats.networkErrorCount());
        }
    }
}

