/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.database;

import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.ClusterStateBundle;
import com.yahoo.vespa.clustercontroller.core.ContentCluster;
import com.yahoo.vespa.clustercontroller.core.FleetController;
import com.yahoo.vespa.clustercontroller.core.FleetControllerContext;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.Timer;
import com.yahoo.vespa.clustercontroller.core.database.CasWriteFailed;
import com.yahoo.vespa.clustercontroller.core.database.Database;
import com.yahoo.vespa.clustercontroller.core.database.DatabaseFactory;
import com.yahoo.vespa.clustercontroller.core.listeners.NodeListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.zookeeper.KeeperException;

public class DatabaseHandler {
    private static final Logger logger = Logger.getLogger(DatabaseHandler.class.getName());
    private final FleetControllerContext fleetControllerContext;
    private final DatabaseFactory databaseFactory;
    private final Timer timer;
    private final Object monitor;
    private String zooKeeperAddress;
    private int zooKeeperSessionTimeout = 5000;
    private final Object databaseMonitor = new Object();
    private Database database;
    private final DatabaseListener dbListener = new DatabaseListener();
    private final Data currentlyStored = new Data();
    private final Data pendingStore = new Data();
    private int lastKnownStateBundleVersionWrittenBySelf = -1;
    private long lastZooKeeperConnectionAttempt = 0L;
    private int minimumWaitBetweenFailedConnectionAttempts = 10000;
    private boolean lostZooKeeperConnectionEvent = false;
    private Map<Integer, Integer> masterDataEvent = null;

    public DatabaseHandler(FleetControllerContext fleetControllerContext, DatabaseFactory databaseFactory, Timer timer, String zooKeeperAddress, Object monitor) throws InterruptedException {
        this.fleetControllerContext = fleetControllerContext;
        this.databaseFactory = databaseFactory;
        this.timer = timer;
        this.pendingStore.masterVote = fleetControllerContext.id().index();
        this.monitor = monitor;
        this.zooKeeperAddress = zooKeeperAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDatabaseClosedSafe() {
        Object object = this.databaseMonitor;
        synchronized (object) {
            return this.isClosed();
        }
    }

    public void shutdown(DatabaseContext databaseContext) {
        this.relinquishDatabaseConnectivity(databaseContext);
    }

    public boolean isClosed() {
        return this.database == null || this.database.isClosed();
    }

    public int getLastKnownStateBundleVersionWrittenBySelf() {
        return this.lastKnownStateBundleVersionWrittenBySelf;
    }

    public void setMinimumWaitBetweenFailedConnectionAttempts(int minimumWaitBetweenFailedConnectionAttempts) {
        this.minimumWaitBetweenFailedConnectionAttempts = minimumWaitBetweenFailedConnectionAttempts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(DatabaseContext databaseContext) {
        boolean wasRunning;
        Object object = this.databaseMonitor;
        synchronized (object) {
            boolean bl = wasRunning = this.database != null;
            if (wasRunning) {
                this.fleetControllerContext.log(logger, Level.INFO, "Resetting database state");
                this.database.close();
                this.database = null;
            }
        }
        this.clearSessionMetaData(true);
        databaseContext.getFleetController().lostDatabaseConnection();
        if (wasRunning) {
            this.fleetControllerContext.log(logger, Level.INFO, "Done resetting database state");
        }
    }

    private void clearSessionMetaData(boolean clearPendingStateWrites) {
        Integer currentVote = this.pendingStore.masterVote != null ? this.pendingStore.masterVote : this.currentlyStored.masterVote;
        this.currentlyStored.clear();
        if (clearPendingStateWrites) {
            this.pendingStore.clear();
        } else {
            this.pendingStore.clearNonClusterStateFields();
        }
        this.pendingStore.masterVote = currentVote;
        this.fleetControllerContext.log(logger, Level.FINE, () -> "Cleared session metadata. Pending master vote is now " + this.pendingStore.masterVote);
    }

    public void setZooKeeperAddress(String address, DatabaseContext databaseContext) {
        if (address == null && this.zooKeeperAddress == null) {
            return;
        }
        if (address != null && address.equals(this.zooKeeperAddress)) {
            return;
        }
        if (this.zooKeeperAddress != null) {
            this.fleetControllerContext.log(logger, Level.INFO, (String)(address == null ? "Stopped using ZooKeeper." : "Got new ZooKeeper address to use: " + address));
        }
        this.zooKeeperAddress = address;
        this.reset(databaseContext);
    }

    public void setZooKeeperSessionTimeout(int timeout, DatabaseContext databaseContext) {
        if (timeout == this.zooKeeperSessionTimeout) {
            return;
        }
        this.fleetControllerContext.log(logger, Level.FINE, () -> "Got new ZooKeeper session timeout of " + timeout + " milliseconds.");
        this.zooKeeperSessionTimeout = timeout;
        this.reset(databaseContext);
    }

    private boolean usingZooKeeper() {
        return this.zooKeeperAddress != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(long currentTime) {
        try {
            this.lastZooKeeperConnectionAttempt = currentTime;
            Object object = this.databaseMonitor;
            synchronized (object) {
                if (this.database != null) {
                    this.database.close();
                }
                this.clearSessionMetaData(false);
                this.fleetControllerContext.log(logger, Level.INFO, "Setting up new ZooKeeper session at " + this.zooKeeperAddress);
                DatabaseFactory.Params params = new DatabaseFactory.Params().databaseAddress(this.zooKeeperAddress).databaseSessionTimeout(this.zooKeeperSessionTimeout).databaseListener(this.dbListener);
                this.database = this.databaseFactory.create(params);
            }
        }
        catch (KeeperException.NodeExistsException e) {
            this.fleetControllerContext.log(logger, Level.FINE, () -> "Cannot create ephemeral fleetcontroller node. ZooKeeper server not seen old fleetcontroller instance disappear? It already exists. Will retry later: " + e.getMessage());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (KeeperException.ConnectionLossException e) {
            this.fleetControllerContext.log(logger, Level.WARNING, "Failed to connect to ZooKeeper at " + this.zooKeeperAddress + " with session timeout " + this.zooKeeperSessionTimeout + ": " + e.getMessage());
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.fleetControllerContext.log(logger, Level.WARNING, "Failed to connect to ZooKeeper at " + this.zooKeeperAddress + " with session timeout " + this.zooKeeperSessionTimeout + ": " + sw);
        }
        this.fleetControllerContext.log(logger, Level.INFO, "Done setting up new ZooKeeper session at " + this.zooKeeperAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doNextZooKeeperTask(DatabaseContext databaseContext) {
        boolean didWork = false;
        Object object = this.monitor;
        synchronized (object) {
            if (this.lostZooKeeperConnectionEvent) {
                this.fleetControllerContext.log(logger, Level.FINE, () -> "doNextZooKeeperTask(): lost connection");
                databaseContext.getFleetController().lostDatabaseConnection();
                this.lostZooKeeperConnectionEvent = false;
                didWork = true;
                if (this.masterDataEvent != null) {
                    this.fleetControllerContext.log(logger, Level.FINE, () -> "Had new master data queued on disconnect. Removing master data event");
                    this.masterDataEvent = null;
                }
            }
            if (this.masterDataEvent != null) {
                this.fleetControllerContext.log(logger, Level.FINE, () -> "doNextZooKeeperTask(): new master data");
                if (!this.masterDataEvent.containsKey(this.fleetControllerContext.id().index())) {
                    Integer currentVote;
                    Integer n = currentVote = this.pendingStore.masterVote != null ? this.pendingStore.masterVote : this.currentlyStored.masterVote;
                    assert (currentVote != null);
                    this.masterDataEvent.put(this.fleetControllerContext.id().index(), currentVote);
                }
                databaseContext.getFleetController().handleFleetData(this.masterDataEvent);
                this.masterDataEvent = null;
                didWork = true;
            }
        }
        if (this.isDatabaseClosedSafe() && this.zooKeeperIsConfigured()) {
            long currentTime = this.timer.getCurrentTimeInMillis();
            if (currentTime - this.lastZooKeeperConnectionAttempt < (long)this.minimumWaitBetweenFailedConnectionAttempts) {
                return false;
            }
            didWork = true;
            this.connect(currentTime);
        }
        try {
            Object currentTime = this.databaseMonitor;
            synchronized (currentTime) {
                if (this.database == null || this.database.isClosed()) {
                    return didWork;
                }
                didWork |= this.performZooKeeperWrites();
            }
        }
        catch (CasWriteFailed e) {
            this.fleetControllerContext.log(logger, Level.WARNING, String.format("CaS write to ZooKeeper failed, another controller has likely taken over ownership: %s", e.getMessage()));
            this.relinquishDatabaseConnectivity(databaseContext);
        }
        return didWork;
    }

    private boolean zooKeeperIsConfigured() {
        return this.zooKeeperAddress != null;
    }

    private void relinquishDatabaseConnectivity(DatabaseContext databaseContext) {
        this.reset(databaseContext);
    }

    private boolean performZooKeeperWrites() {
        boolean didWork = false;
        if (this.pendingStore.masterVote != null) {
            didWork = true;
            this.fleetControllerContext.log(logger, Level.FINE, () -> "Attempting to store master vote " + this.pendingStore.masterVote + " into zookeeper.");
            if (this.database.storeMasterVote(this.pendingStore.masterVote)) {
                this.fleetControllerContext.log(logger, Level.FINE, () -> "Managed to store master vote " + this.pendingStore.masterVote + " into zookeeper.");
                this.currentlyStored.masterVote = this.pendingStore.masterVote;
                this.pendingStore.masterVote = null;
            } else {
                this.fleetControllerContext.log(logger, Level.WARNING, "Failed to store master vote");
                return true;
            }
        }
        if (this.pendingStore.lastSystemStateVersion != null) {
            didWork = true;
            this.fleetControllerContext.log(logger, Level.FINE, () -> "Attempting to store last system state version " + this.pendingStore.lastSystemStateVersion + " into zookeeper.");
            if (this.database.storeLatestSystemStateVersion(this.pendingStore.lastSystemStateVersion)) {
                this.currentlyStored.lastSystemStateVersion = this.pendingStore.lastSystemStateVersion;
                this.pendingStore.lastSystemStateVersion = null;
            } else {
                return true;
            }
        }
        if (this.pendingStore.startTimestamps != null) {
            didWork = true;
            this.fleetControllerContext.log(logger, Level.FINE, () -> "Attempting to store " + this.pendingStore.startTimestamps.size() + " start timestamps into zookeeper.");
            if (this.database.storeStartTimestamps(this.pendingStore.startTimestamps)) {
                this.currentlyStored.startTimestamps = this.pendingStore.startTimestamps;
                this.pendingStore.startTimestamps = null;
            } else {
                return true;
            }
        }
        if (this.pendingStore.wantedStates != null) {
            didWork = true;
            this.fleetControllerContext.log(logger, Level.FINE, () -> "Attempting to store " + this.pendingStore.wantedStates.size() + " wanted states into zookeeper.");
            if (this.database.storeWantedStates(this.pendingStore.wantedStates)) {
                this.currentlyStored.wantedStates = this.pendingStore.wantedStates;
                this.pendingStore.wantedStates = null;
            } else {
                return true;
            }
        }
        if (this.pendingStore.clusterStateBundle != null) {
            didWork = true;
            this.fleetControllerContext.log(logger, Level.FINE, () -> "Attempting to store last cluster state bundle with version " + this.pendingStore.clusterStateBundle.getVersion() + " into zookeeper.");
            if (this.database.storeLastPublishedStateBundle(this.pendingStore.clusterStateBundle)) {
                this.lastKnownStateBundleVersionWrittenBySelf = this.pendingStore.clusterStateBundle.getVersion();
                this.currentlyStored.clusterStateBundle = this.pendingStore.clusterStateBundle;
                this.pendingStore.clusterStateBundle = null;
            } else {
                return true;
            }
        }
        return didWork;
    }

    public void setMasterVote(DatabaseContext databaseContext, int wantedMasterCandidate) {
        this.fleetControllerContext.log(logger, Level.FINE, () -> "Checking if master vote has been updated and need to be stored.");
        if (this.pendingStore.masterVote != null || this.currentlyStored.masterVote == null || this.currentlyStored.masterVote != wantedMasterCandidate) {
            this.fleetControllerContext.log(logger, Level.FINE, () -> "Scheduling master vote " + wantedMasterCandidate + " to be stored in zookeeper.");
            this.pendingStore.masterVote = wantedMasterCandidate;
            this.doNextZooKeeperTask(databaseContext);
        }
    }

    public void saveLatestSystemStateVersion(DatabaseContext databaseContext, int version) throws InterruptedException {
        this.fleetControllerContext.log(logger, Level.FINE, () -> "Checking if latest system state version has been updated and need to be stored.");
        if (this.pendingStore.lastSystemStateVersion != null || this.currentlyStored.lastSystemStateVersion == null || this.currentlyStored.lastSystemStateVersion != version) {
            this.fleetControllerContext.log(logger, Level.FINE, () -> "Scheduling new last system state version " + version + " to be stored in zookeeper.");
            this.pendingStore.lastSystemStateVersion = version;
            this.doNextZooKeeperTask(databaseContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLatestSystemStateVersion() {
        this.fleetControllerContext.log(logger, Level.FINE, () -> "Retrieving latest system state version.");
        Object object = this.databaseMonitor;
        synchronized (object) {
            if (this.database != null) {
                this.currentlyStored.lastSystemStateVersion = this.database.retrieveLatestSystemStateVersion();
            }
        }
        Integer version = this.currentlyStored.lastSystemStateVersion;
        if (version == null) {
            if (this.usingZooKeeper()) {
                this.fleetControllerContext.log(logger, Level.WARNING, "Failed to retrieve latest system state version from ZooKeeper. Returning version 0.");
            }
            return 0;
        }
        return version;
    }

    public void saveLatestClusterStateBundle(DatabaseContext databaseContext, ClusterStateBundle clusterStateBundle) {
        this.fleetControllerContext.log(logger, Level.FINE, () -> "Scheduling bundle " + clusterStateBundle + " to be saved to ZooKeeper");
        this.pendingStore.clusterStateBundle = clusterStateBundle;
        this.doNextZooKeeperTask(databaseContext);
        if (this.zooKeeperAddress == null) {
            logger.warning(() -> "Simulating ZK write of version " + clusterStateBundle.getVersion() + ". This should not happen in production!");
            this.lastKnownStateBundleVersionWrittenBySelf = clusterStateBundle.getVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingClusterStateMetaDataStore() {
        Object object = this.databaseMonitor;
        synchronized (object) {
            return this.zooKeeperAddress != null && (this.pendingStore.clusterStateBundle != null || this.pendingStore.lastSystemStateVersion != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterStateBundle getLatestClusterStateBundle() {
        this.fleetControllerContext.log(logger, Level.FINE, () -> "Retrieving latest cluster state bundle from ZooKeeper");
        Object object = this.databaseMonitor;
        synchronized (object) {
            if (this.database != null && !this.database.isClosed()) {
                return this.database.retrieveLastPublishedStateBundle();
            }
            return ClusterStateBundle.empty();
        }
    }

    public boolean saveWantedStates(DatabaseContext databaseContext) {
        this.fleetControllerContext.log(logger, Level.FINE, () -> "Checking whether wanted states have changed compared to zookeeper version.");
        TreeMap<Node, NodeState> wantedStates = new TreeMap<Node, NodeState>();
        for (NodeInfo info : databaseContext.getCluster().getNodeInfos()) {
            if (info.getUserWantedState().equals((Object)new NodeState(info.getNode().getType(), State.UP))) continue;
            wantedStates.put(info.getNode(), info.getUserWantedState());
        }
        if (this.pendingStore.wantedStates != null || this.currentlyStored.wantedStates == null || !this.currentlyStored.wantedStates.equals(wantedStates)) {
            this.fleetControllerContext.log(logger, Level.FINE, () -> "Scheduling new wanted states to be stored into zookeeper.");
            this.pendingStore.wantedStates = wantedStates;
            this.doNextZooKeeperTask(databaseContext);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadWantedStates(DatabaseContext databaseContext) {
        this.fleetControllerContext.log(logger, Level.FINE, () -> "Retrieving node wanted states.");
        Object object = this.databaseMonitor;
        synchronized (object) {
            if (this.database != null && !this.database.isClosed()) {
                this.currentlyStored.wantedStates = this.database.retrieveWantedStates();
            }
        }
        Map<Node, NodeState> wantedStates = this.currentlyStored.wantedStates;
        if (wantedStates == null) {
            if (this.usingZooKeeper()) {
                this.fleetControllerContext.log(logger, Level.FINE, () -> "Failed to retrieve wanted states from ZooKeeper. Assuming UP for all nodes.");
            }
            wantedStates = new TreeMap<Node, NodeState>();
        }
        boolean altered = false;
        for (Node node : wantedStates.keySet()) {
            NodeInfo nodeInfo = databaseContext.getCluster().getNodeInfo(node);
            if (nodeInfo == null) {
                databaseContext.getNodeStateUpdateListener().handleRemovedNode(node);
                altered = true;
                continue;
            }
            NodeState wantedState = wantedStates.get(node);
            if (!nodeInfo.getUserWantedState().equals((Object)wantedState)) {
                nodeInfo.setWantedState(wantedState);
                databaseContext.getNodeStateUpdateListener().handleNewWantedNodeState(nodeInfo, wantedState);
                altered = true;
            }
            this.fleetControllerContext.log(logger, Level.FINE, () -> "Node " + node + " has wanted state " + wantedState);
        }
        for (NodeInfo info : databaseContext.getCluster().getNodeInfos()) {
            NodeState wantedState = wantedStates.get(info.getNode());
            if (wantedState != null || info.getUserWantedState().equals((Object)new NodeState(info.getNode().getType(), State.UP))) continue;
            info.setWantedState(null);
            databaseContext.getNodeStateUpdateListener().handleNewWantedNodeState(info, info.getWantedState().clone());
            altered = true;
        }
        return altered;
    }

    public void saveStartTimestamps(DatabaseContext databaseContext) {
        this.fleetControllerContext.log(logger, Level.FINE, () -> "Scheduling start timestamps to be stored into zookeeper.");
        this.pendingStore.startTimestamps = databaseContext.getCluster().getStartTimestamps();
        this.doNextZooKeeperTask(databaseContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadStartTimestamps(ContentCluster cluster) {
        this.fleetControllerContext.log(logger, Level.FINE, () -> "Retrieving start timestamps");
        Object object = this.databaseMonitor;
        synchronized (object) {
            if (this.database == null || this.database.isClosed()) {
                return false;
            }
            this.currentlyStored.startTimestamps = this.database.retrieveStartTimestamps();
        }
        Map<Node, Long> startTimestamps = this.currentlyStored.startTimestamps;
        if (startTimestamps == null) {
            if (this.usingZooKeeper()) {
                this.fleetControllerContext.log(logger, Level.WARNING, "Failed to retrieve start timestamps from ZooKeeper. Cluster state will be bloated with timestamps until we get them set.");
            }
            startTimestamps = new TreeMap<Node, Long>();
        }
        for (Map.Entry<Node, Long> e : startTimestamps.entrySet()) {
            cluster.setStartTimestamp(e.getKey(), e.getValue());
            this.fleetControllerContext.log(logger, Level.FINE, () -> "Node " + e.getKey() + " has start timestamp " + e.getValue());
        }
        return true;
    }

    private class DatabaseListener
    implements Database.DatabaseListener {
        private DatabaseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleZooKeeperSessionDown() {
            DatabaseHandler.this.fleetControllerContext.log(logger, Level.FINE, () -> "Lost contact with zookeeper server");
            Object object = DatabaseHandler.this.monitor;
            synchronized (object) {
                DatabaseHandler.this.lostZooKeeperConnectionEvent = true;
                DatabaseHandler.this.monitor.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMasterData(Map<Integer, Integer> data) {
            Object object = DatabaseHandler.this.monitor;
            synchronized (object) {
                if (DatabaseHandler.this.masterDataEvent != null && DatabaseHandler.this.masterDataEvent.equals(data)) {
                    DatabaseHandler.this.fleetControllerContext.log(logger, Level.FINE, () -> "New master data was the same as the last one. Not responding to it");
                } else {
                    DatabaseHandler.this.masterDataEvent = data;
                }
                DatabaseHandler.this.monitor.notifyAll();
            }
        }
    }

    private static class Data {
        Integer masterVote;
        Integer lastSystemStateVersion;
        Map<Node, NodeState> wantedStates;
        Map<Node, Long> startTimestamps;
        ClusterStateBundle clusterStateBundle;

        private Data() {
        }

        void clear() {
            this.clearNonClusterStateFields();
            this.lastSystemStateVersion = null;
            this.clusterStateBundle = null;
        }

        void clearNonClusterStateFields() {
            this.masterVote = null;
            this.wantedStates = null;
            this.startTimestamps = null;
        }
    }

    public static interface DatabaseContext {
        public ContentCluster getCluster();

        public FleetController getFleetController();

        public NodeListener getNodeStateUpdateListener();
    }
}

