/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.ClusterStatsAggregator;
import com.yahoo.vespa.clustercontroller.core.ContentClusterErrorStats;
import com.yahoo.vespa.clustercontroller.core.ContentClusterStats;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.hostinfo.HostInfo;
import com.yahoo.vespa.clustercontroller.core.hostinfo.StorageNodeStatsBridge;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClusterStateView {
    private static final Logger log = Logger.getLogger(ClusterStateView.class.getName());
    private final ClusterState clusterState;
    private final ClusterStatsAggregator statsAggregator;

    public static ClusterStateView create(String serializedClusterState) throws ParseException {
        ClusterState clusterState = new ClusterState(serializedClusterState);
        return new ClusterStateView(clusterState, ClusterStateView.createNewAggregator(clusterState));
    }

    public static ClusterStateView create(ClusterState clusterState) {
        return new ClusterStateView(clusterState, ClusterStateView.createNewAggregator(clusterState));
    }

    private static ClusterStatsAggregator createNewAggregator(ClusterState clusterState) {
        Set<Integer> upDistributors = ClusterStateView.getIndicesOfUpNodes(clusterState, NodeType.DISTRIBUTOR);
        Set<Integer> upStorageNodes = ClusterStateView.getIndicesOfUpNodes(clusterState, NodeType.STORAGE);
        return new ClusterStatsAggregator(upDistributors, upStorageNodes);
    }

    ClusterStateView(ClusterState clusterState, ClusterStatsAggregator statsAggregator) {
        this.clusterState = clusterState;
        this.statsAggregator = statsAggregator;
    }

    static Set<Integer> getIndicesOfUpNodes(ClusterState clusterState, NodeType type) {
        int nodeCount = clusterState.getNodeCount(type);
        HashSet<Integer> nodesBeingUp = new HashSet<Integer>();
        for (int i = 0; i < nodeCount; ++i) {
            Node node = new Node(type, i);
            NodeState nodeState = clusterState.getNodeState(node);
            State state = nodeState.getState();
            if (state != State.UP && state != State.INITIALIZING && state != State.RETIRED && state != State.MAINTENANCE) continue;
            nodesBeingUp.add(i);
        }
        return nodesBeingUp;
    }

    public ClusterState getClusterState() {
        return this.clusterState;
    }

    public void handleUpdatedHostInfo(NodeInfo node, HostInfo hostInfo, boolean aggregateErrorReports) {
        if (!node.isDistributor()) {
            return;
        }
        if (hostInfo.getClusterStateVersionOrNull() == null) {
            return;
        }
        int hostVersion = hostInfo.getClusterStateVersionOrNull();
        int currentStateVersion = this.clusterState.getVersion();
        if (aggregateErrorReports) {
            ContentClusterErrorStats errorStats = StorageNodeStatsBridge.generateErrors(node.getNodeIndex(), hostInfo.getDistributor());
            this.statsAggregator.updateErrorStatsFromDistributor(node.getNodeIndex(), errorStats);
        } else {
            this.statsAggregator.clearAllErrorStatsFromDistributors();
        }
        if (hostVersion != currentStateVersion) {
            log.log(Level.FINE, () -> "Current state version is " + currentStateVersion + ", while host info received from distributor " + node.getNodeIndex() + " is " + hostVersion);
            return;
        }
        ContentClusterStats stats = StorageNodeStatsBridge.generate(hostInfo.getDistributor());
        this.statsAggregator.updateForDistributor(node.getNodeIndex(), stats);
    }

    public void handleUpdatedHostInfo(NodeInfo node, HostInfo hostInfo) {
        this.handleUpdatedHostInfo(node, hostInfo, false);
    }

    public ClusterStatsAggregator getStatsAggregator() {
        return this.statsAggregator;
    }

    public String toString() {
        return this.clusterState.toString();
    }
}

