/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.hostinfo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yahoo.vespa.clustercontroller.core.hostinfo.ResponseStats;
import java.util.ArrayList;
import java.util.List;

public class StorageNode {
    private final Integer index;
    @JsonProperty(value="min-current-replication-factor")
    private Integer minCurrentReplicationFactor;
    @JsonProperty(value="bucket-spaces")
    private List<BucketSpaceStats> bucketSpacesStats = new ArrayList<BucketSpaceStats>();
    @JsonProperty(value="response-stats")
    private ResponseStats responseStats = ResponseStats.makeEmpty();

    @JsonCreator
    public StorageNode(@JsonProperty(value="node-index") Integer index) {
        this.index = index;
    }

    public Integer getIndex() {
        return this.index;
    }

    public Integer getMinCurrentReplicationFactorOrNull() {
        return this.minCurrentReplicationFactor;
    }

    public List<BucketSpaceStats> getBucketSpacesStats() {
        return this.bucketSpacesStats;
    }

    public ResponseStats getResponseStats() {
        return this.responseStats;
    }

    public static class BucketSpaceStats {
        private final String name;
        @JsonProperty(value="buckets")
        private BucketStats bucketStats = null;

        @JsonCreator
        public BucketSpaceStats(@JsonProperty(value="name") String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean valid() {
            return this.bucketStats != null;
        }

        public BucketStats getBucketStats() {
            return this.bucketStats;
        }
    }

    public static class BucketStats {
        private final long total;
        private final long pending;

        @JsonCreator
        public BucketStats(@JsonProperty(value="total") Long total, @JsonProperty(value="pending") Long pending) {
            this.total = total;
            this.pending = pending;
        }

        public long getTotal() {
            return this.total;
        }

        public long getPending() {
            return this.pending;
        }
    }
}

