/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class DistributionDiff {
    private final TreeMap<String, NodeDiff> groupDiffs;
    private final IntegerDiff groupCountDiff;
    private final IntegerDiff redundancyDiff;
    private final IntegerDiff searchableCopiesDiff;

    public DistributionDiff(TreeMap<String, NodeDiff> groupDiffs, IntegerDiff groupCountDiff, IntegerDiff redundancyDiff, IntegerDiff searchableCopiesDiff) {
        this.groupCountDiff = groupCountDiff;
        this.groupDiffs = groupDiffs;
        this.redundancyDiff = redundancyDiff;
        this.searchableCopiesDiff = searchableCopiesDiff;
    }

    public String toString() {
        ArrayList<String> diffs = new ArrayList<String>();
        DistributionDiff.addIfDiffers(this.redundancyDiff, "redundancy", diffs);
        DistributionDiff.addIfDiffers(this.searchableCopiesDiff, "searchable-copies", diffs);
        DistributionDiff.addIfDiffers(this.groupCountDiff, "groups", diffs);
        for (Map.Entry<String, NodeDiff> kv : this.groupDiffs.entrySet()) {
            DistributionDiff.addGroupDiffStringIfDiffers(kv, diffs);
        }
        return String.join((CharSequence)", ", diffs);
    }

    private static void addIfDiffers(IntegerDiff diff, String name, List<String> diffs) {
        if (diff.differs()) {
            diffs.add("%s: %d -> %d".formatted(name, diff.before, diff.after));
        }
    }

    private static void addGroupDiffStringIfDiffers(Map.Entry<String, NodeDiff> kv, List<String> diffs) {
        NodeDiff v = kv.getValue();
        if (v.added.isEmpty() && v.removed.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(kv.getKey()).append(": ");
        if (!v.added.isEmpty()) {
            DistributionDiff.appendIntsAsSet(sb, "added", v.added);
        }
        if (!v.removed.isEmpty()) {
            if (!v.added.isEmpty()) {
                sb.append(' ');
            }
            DistributionDiff.appendIntsAsSet(sb, "removed", v.removed);
        }
        diffs.add(sb.toString());
    }

    private static void appendIntsAsSet(StringBuilder sb, String setName, List<Integer> ints) {
        sb.append(setName).append(" {");
        sb.append(ints.stream().map(i -> Integer.toString(i)).collect(Collectors.joining(", ")));
        sb.append('}');
    }

    public record IntegerDiff(int before, int after) {
        boolean differs() {
            return this.before != this.after;
        }

        static IntegerDiff of(int before, int after) {
            return new IntegerDiff(before, after);
        }
    }

    public record NodeDiff(List<Integer> added, List<Integer> removed) {
    }
}

