/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.jrt.slobrok.api.BackOffPolicy;
import com.yahoo.vdslib.distribution.ConfiguredNode;
import com.yahoo.vdslib.distribution.Distribution;
import com.yahoo.vdslib.state.NodeType;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class FleetControllerOptions {
    private final String fleetControllerConfigId;
    private final String slobrokConfigId;
    private final String clusterName;
    private final int fleetControllerIndex;
    private final int fleetControllerCount;
    private final int stateGatherCount;
    private final String[] slobrokConnectionSpecs;
    private final int rpcPort;
    private final int httpPort;
    private final int distributionBits;
    private final int zooKeeperSessionTimeout;
    private final int masterZooKeeperCooldownPeriod;
    private final String zooKeeperServerAddress;
    private final int statePollingFrequency;
    private final Map<NodeType, Integer> maxTransitionTime;
    private final int maxInitProgressTime;
    private final int maxPrematureCrashes;
    private final long stableStateTimePeriod;
    private final int eventLogMaxSize;
    private final int eventNodeLogMaxSize;
    private final int minDistributorNodesUp;
    private final int minStorageNodesUp;
    private final double minRatioOfDistributorNodesUp;
    private final double minRatioOfStorageNodesUp;
    private final double minNodeRatioPerGroup;
    private final int cycleWaitTime;
    private final long minTimeBeforeFirstSystemStateBroadcast;
    private final int nodeStateRequestTimeoutMS;
    private final int nodeStateRequestTimeoutEarliestPercentage;
    private final int nodeStateRequestTimeoutLatestPercentage;
    private final int nodeStateRequestRoundTripTimeMaxSeconds;
    private final int minTimeBetweenNewSystemStates;
    private final boolean showLocalSystemStatesInEventLog;
    private final int maxSlobrokDisconnectGracePeriod;
    private final BackOffPolicy slobrokBackOffPolicy;
    private final Distribution storageDistribution;
    private final Set<ConfiguredNode> nodes;
    private final Duration maxDeferredTaskVersionWaitTime;
    private final boolean clusterHasGlobalDocumentTypes;
    private final boolean enableTwoPhaseClusterStateActivation;
    private final double minMergeCompletionRatio;
    private final int maxDivergentNodesPrintedInTaskErrorMessages;
    private final boolean clusterFeedBlockEnabled;
    private final Map<String, Double> clusterFeedBlockLimit;
    private final double clusterFeedBlockNoiseLevel;

    private FleetControllerOptions(String fleetControllerConfigId, String slobrokConfigId, String clusterName, int fleetControllerIndex, int fleetControllerCount, int stateGatherCount, String[] slobrokConnectionSpecs, int rpcPort, int httpPort, int distributionBits, int zooKeeperSessionTimeout, int masterZooKeeperCooldownPeriod, String zooKeeperServerAddress, int statePollingFrequency, Map<NodeType, Integer> maxTransitionTime, int maxInitProgressTime, int maxPrematureCrashes, long stableStateTimePeriod, int eventLogMaxSize, int eventNodeLogMaxSize, int minDistributorNodesUp, int minStorageNodesUp, double minRatioOfDistributorNodesUp, double minRatioOfStorageNodesUp, double minNodeRatioPerGroup, int cycleWaitTime, long minTimeBeforeFirstSystemStateBroadcast, int nodeStateRequestTimeoutMS, int nodeStateRequestTimeoutEarliestPercentage, int nodeStateRequestTimeoutLatestPercentage, int nodeStateRequestRoundTripTimeMaxSeconds, int minTimeBetweenNewSystemStates, boolean showLocalSystemStatesInEventLog, int maxSlobrokDisconnectGracePeriod, BackOffPolicy slobrokBackOffPolicy, Distribution storageDistribution, Set<ConfiguredNode> nodes, Duration maxDeferredTaskVersionWaitTime, boolean clusterHasGlobalDocumentTypes, boolean enableTwoPhaseClusterStateActivation, double minMergeCompletionRatio, int maxDivergentNodesPrintedInTaskErrorMessages, boolean clusterFeedBlockEnabled, Map<String, Double> clusterFeedBlockLimit, double clusterFeedBlockNoiseLevel) {
        this.fleetControllerConfigId = fleetControllerConfigId;
        this.slobrokConfigId = slobrokConfigId;
        this.clusterName = clusterName;
        this.fleetControllerIndex = fleetControllerIndex;
        this.fleetControllerCount = fleetControllerCount;
        this.stateGatherCount = stateGatherCount;
        this.slobrokConnectionSpecs = slobrokConnectionSpecs;
        this.rpcPort = rpcPort;
        this.httpPort = httpPort;
        this.distributionBits = distributionBits;
        this.zooKeeperSessionTimeout = zooKeeperSessionTimeout;
        this.masterZooKeeperCooldownPeriod = masterZooKeeperCooldownPeriod;
        this.zooKeeperServerAddress = zooKeeperServerAddress;
        this.statePollingFrequency = statePollingFrequency;
        this.maxTransitionTime = maxTransitionTime;
        this.maxInitProgressTime = maxInitProgressTime;
        this.maxPrematureCrashes = maxPrematureCrashes;
        this.stableStateTimePeriod = stableStateTimePeriod;
        this.eventLogMaxSize = eventLogMaxSize;
        this.eventNodeLogMaxSize = eventNodeLogMaxSize;
        this.minDistributorNodesUp = minDistributorNodesUp;
        this.minStorageNodesUp = minStorageNodesUp;
        this.minRatioOfDistributorNodesUp = minRatioOfDistributorNodesUp;
        this.minRatioOfStorageNodesUp = minRatioOfStorageNodesUp;
        this.minNodeRatioPerGroup = minNodeRatioPerGroup;
        this.cycleWaitTime = cycleWaitTime;
        this.minTimeBeforeFirstSystemStateBroadcast = minTimeBeforeFirstSystemStateBroadcast;
        this.nodeStateRequestTimeoutMS = nodeStateRequestTimeoutMS;
        this.nodeStateRequestTimeoutEarliestPercentage = nodeStateRequestTimeoutEarliestPercentage;
        this.nodeStateRequestTimeoutLatestPercentage = nodeStateRequestTimeoutLatestPercentage;
        this.nodeStateRequestRoundTripTimeMaxSeconds = nodeStateRequestRoundTripTimeMaxSeconds;
        this.minTimeBetweenNewSystemStates = minTimeBetweenNewSystemStates;
        this.showLocalSystemStatesInEventLog = showLocalSystemStatesInEventLog;
        this.maxSlobrokDisconnectGracePeriod = maxSlobrokDisconnectGracePeriod;
        this.slobrokBackOffPolicy = slobrokBackOffPolicy;
        this.storageDistribution = storageDistribution;
        this.nodes = nodes;
        this.maxDeferredTaskVersionWaitTime = maxDeferredTaskVersionWaitTime;
        this.clusterHasGlobalDocumentTypes = clusterHasGlobalDocumentTypes;
        this.enableTwoPhaseClusterStateActivation = enableTwoPhaseClusterStateActivation;
        this.minMergeCompletionRatio = minMergeCompletionRatio;
        this.maxDivergentNodesPrintedInTaskErrorMessages = maxDivergentNodesPrintedInTaskErrorMessages;
        this.clusterFeedBlockEnabled = clusterFeedBlockEnabled;
        this.clusterFeedBlockLimit = clusterFeedBlockLimit;
        this.clusterFeedBlockNoiseLevel = clusterFeedBlockNoiseLevel;
    }

    public Duration getMaxDeferredTaskVersionWaitTime() {
        return this.maxDeferredTaskVersionWaitTime;
    }

    public long storageNodeMaxTransitionTimeMs() {
        return this.maxTransitionTime.getOrDefault(NodeType.STORAGE, 10000).intValue();
    }

    public String fleetControllerConfigId() {
        return this.fleetControllerConfigId;
    }

    public String slobrokConfigId() {
        return this.slobrokConfigId;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public int fleetControllerIndex() {
        return this.fleetControllerIndex;
    }

    public int fleetControllerCount() {
        return this.fleetControllerCount;
    }

    public int stateGatherCount() {
        return this.stateGatherCount;
    }

    public String[] slobrokConnectionSpecs() {
        return this.slobrokConnectionSpecs;
    }

    public int rpcPort() {
        return this.rpcPort;
    }

    public int httpPort() {
        return this.httpPort;
    }

    public int distributionBits() {
        return this.distributionBits;
    }

    public int zooKeeperSessionTimeout() {
        return this.zooKeeperSessionTimeout;
    }

    public int masterZooKeeperCooldownPeriod() {
        return this.masterZooKeeperCooldownPeriod;
    }

    public String zooKeeperServerAddress() {
        return this.zooKeeperServerAddress;
    }

    public int statePollingFrequency() {
        return this.statePollingFrequency;
    }

    public Map<NodeType, Integer> maxTransitionTime() {
        return this.maxTransitionTime;
    }

    public int maxInitProgressTime() {
        return this.maxInitProgressTime;
    }

    public int maxPrematureCrashes() {
        return this.maxPrematureCrashes;
    }

    public long stableStateTimePeriod() {
        return this.stableStateTimePeriod;
    }

    public int eventLogMaxSize() {
        return this.eventLogMaxSize;
    }

    public int eventNodeLogMaxSize() {
        return this.eventNodeLogMaxSize;
    }

    public int minDistributorNodesUp() {
        return this.minDistributorNodesUp;
    }

    public int minStorageNodesUp() {
        return this.minStorageNodesUp;
    }

    public double minRatioOfDistributorNodesUp() {
        return this.minRatioOfDistributorNodesUp;
    }

    public double minRatioOfStorageNodesUp() {
        return this.minRatioOfStorageNodesUp;
    }

    public double minNodeRatioPerGroup() {
        return this.minNodeRatioPerGroup;
    }

    public int cycleWaitTime() {
        return this.cycleWaitTime;
    }

    public long minTimeBeforeFirstSystemStateBroadcast() {
        return this.minTimeBeforeFirstSystemStateBroadcast;
    }

    public int nodeStateRequestTimeoutMS() {
        return this.nodeStateRequestTimeoutMS;
    }

    public int nodeStateRequestTimeoutEarliestPercentage() {
        return this.nodeStateRequestTimeoutEarliestPercentage;
    }

    public int nodeStateRequestTimeoutLatestPercentage() {
        return this.nodeStateRequestTimeoutLatestPercentage;
    }

    public int nodeStateRequestRoundTripTimeMaxSeconds() {
        return this.nodeStateRequestRoundTripTimeMaxSeconds;
    }

    public int minTimeBetweenNewSystemStates() {
        return this.minTimeBetweenNewSystemStates;
    }

    public boolean showLocalSystemStatesInEventLog() {
        return this.showLocalSystemStatesInEventLog;
    }

    public int maxSlobrokDisconnectGracePeriod() {
        return this.maxSlobrokDisconnectGracePeriod;
    }

    public BackOffPolicy slobrokBackOffPolicy() {
        return this.slobrokBackOffPolicy;
    }

    public Distribution storageDistribution() {
        return this.storageDistribution;
    }

    public Set<ConfiguredNode> nodes() {
        return this.nodes;
    }

    public Duration maxDeferredTaskVersionWaitTime() {
        return this.maxDeferredTaskVersionWaitTime;
    }

    public boolean clusterHasGlobalDocumentTypes() {
        return this.clusterHasGlobalDocumentTypes;
    }

    public boolean enableTwoPhaseClusterStateActivation() {
        return this.enableTwoPhaseClusterStateActivation;
    }

    public double minMergeCompletionRatio() {
        return this.minMergeCompletionRatio;
    }

    public int maxDivergentNodesPrintedInTaskErrorMessages() {
        return this.maxDivergentNodesPrintedInTaskErrorMessages;
    }

    public boolean clusterFeedBlockEnabled() {
        return this.clusterFeedBlockEnabled;
    }

    public Map<String, Double> clusterFeedBlockLimit() {
        return this.clusterFeedBlockLimit;
    }

    public double clusterFeedBlockNoiseLevel() {
        return this.clusterFeedBlockNoiseLevel;
    }

    public static class Builder {
        private String fleetControllerConfigId;
        private String slobrokConfigId;
        private String clusterName;
        private int index = 0;
        private int count = 1;
        private int stateGatherCount = 2;
        private String[] slobrokConnectionSpecs;
        private int rpcPort = 0;
        private int httpPort = 0;
        private int distributionBits = 16;
        private int zooKeeperSessionTimeout = 300000;
        private int masterZooKeeperCooldownPeriod = 15000;
        private String zooKeeperServerAddress = null;
        private int statePollingFrequency = 5000;
        private Map<NodeType, Integer> maxTransitionTime = new TreeMap<NodeType, Integer>();
        private int maxInitProgressTime = 5000;
        private int maxPrematureCrashes = 4;
        private long stableStateTimePeriod = 0x6DDD00L;
        private int eventLogMaxSize = 1024;
        private int eventNodeLogMaxSize = 1024;
        private int minDistributorNodesUp = 1;
        private int minStorageNodesUp = 1;
        private double minRatioOfDistributorNodesUp = 0.5;
        private double minRatioOfStorageNodesUp = 0.5;
        private double minNodeRatioPerGroup = 0.0;
        private int cycleWaitTime = 100;
        private long minTimeBeforeFirstSystemStateBroadcast = 0L;
        private int nodeStateRequestTimeoutMS = 300000;
        private int nodeStateRequestTimeoutEarliestPercentage = 80;
        private int nodeStateRequestTimeoutLatestPercentage = 95;
        private int nodeStateRequestRoundTripTimeMaxSeconds = 5;
        private int minTimeBetweenNewSystemStates = 0;
        private boolean showLocalSystemStatesInEventLog = true;
        private int maxSlobrokDisconnectGracePeriod = 1000;
        private BackOffPolicy slobrokBackOffPolicy = null;
        private Distribution storageDistribution;
        private Set<ConfiguredNode> nodes;
        private Duration maxDeferredTaskVersionWaitTime = Duration.ofSeconds(30L);
        private boolean clusterHasGlobalDocumentTypes = false;
        private boolean enableTwoPhaseClusterStateActivation = false;
        private double minMergeCompletionRatio = 1.0;
        private int maxDivergentNodesPrintedInTaskErrorMessages = 10;
        private boolean clusterFeedBlockEnabled = false;
        private Map<String, Double> clusterFeedBlockLimit = Collections.emptyMap();
        private double clusterFeedBlockNoiseLevel = 0.01;

        public Builder(String clusterName, Collection<ConfiguredNode> nodes) {
            this.clusterName = clusterName;
            this.nodes = new TreeSet<ConfiguredNode>(nodes);
            this.maxTransitionTime.put(NodeType.DISTRIBUTOR, 0);
            this.maxTransitionTime.put(NodeType.STORAGE, 5000);
        }

        public String clusterName() {
            return this.clusterName;
        }

        public Builder setClusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public int fleetControllerIndex() {
            return this.index;
        }

        public Builder setIndex(int index) {
            this.index = index;
            return this;
        }

        public Builder setCount(int count) {
            this.count = count;
            return this;
        }

        public Builder setStateGatherCount(int stateGatherCount) {
            this.stateGatherCount = stateGatherCount;
            return this;
        }

        public String[] slobrokConnectionSpecs() {
            return this.slobrokConnectionSpecs;
        }

        public Builder setSlobrokConnectionSpecs(String[] slobrokConnectionSpecs) {
            Objects.requireNonNull(slobrokConnectionSpecs, "slobrokConnectionSpecs cannot be null");
            this.slobrokConnectionSpecs = slobrokConnectionSpecs;
            return this;
        }

        public Builder setRpcPort(int rpcPort) {
            this.rpcPort = rpcPort;
            return this;
        }

        public Builder setHttpPort(int httpPort) {
            this.httpPort = httpPort;
            return this;
        }

        public Builder setDistributionBits(int distributionBits) {
            this.distributionBits = distributionBits;
            return this;
        }

        public Builder setZooKeeperSessionTimeout(int zooKeeperSessionTimeout) {
            this.zooKeeperSessionTimeout = zooKeeperSessionTimeout;
            return this;
        }

        public Builder setMasterZooKeeperCooldownPeriod(int masterZooKeeperCooldownPeriod) {
            this.masterZooKeeperCooldownPeriod = masterZooKeeperCooldownPeriod;
            return this;
        }

        public String zooKeeperServerAddress() {
            return this.zooKeeperServerAddress;
        }

        public Builder setZooKeeperServerAddress(String zooKeeperServerAddress) {
            if (zooKeeperServerAddress == null || "".equals(zooKeeperServerAddress)) {
                throw new IllegalArgumentException("zookeeper server address must be set, was '" + zooKeeperServerAddress + "'");
            }
            this.zooKeeperServerAddress = zooKeeperServerAddress;
            return this;
        }

        public Builder setStatePollingFrequency(int statePollingFrequency) {
            this.statePollingFrequency = statePollingFrequency;
            return this;
        }

        public Map<NodeType, Integer> maxTransitionTime() {
            return this.maxTransitionTime;
        }

        public Builder setMaxTransitionTime(NodeType nodeType, Integer maxTransitionTime) {
            this.maxTransitionTime.put(nodeType, maxTransitionTime);
            return this;
        }

        public int maxInitProgressTime() {
            return this.maxInitProgressTime;
        }

        public Builder setMaxInitProgressTime(int maxInitProgressTime) {
            this.maxInitProgressTime = maxInitProgressTime;
            return this;
        }

        public int maxPrematureCrashes() {
            return this.maxPrematureCrashes;
        }

        public Builder setMaxPrematureCrashes(int maxPrematureCrashes) {
            this.maxPrematureCrashes = maxPrematureCrashes;
            return this;
        }

        public long stableStateTimePeriod() {
            return this.stableStateTimePeriod;
        }

        public Builder setStableStateTimePeriod(long stableStateTimePeriod) {
            this.stableStateTimePeriod = stableStateTimePeriod;
            return this;
        }

        public Builder setEventLogMaxSize(int eventLogMaxSize) {
            this.eventLogMaxSize = eventLogMaxSize;
            return this;
        }

        public Builder setEventNodeLogMaxSize(int eventNodeLogMaxSize) {
            this.eventNodeLogMaxSize = eventNodeLogMaxSize;
            return this;
        }

        public Builder setMinDistributorNodesUp(int minDistributorNodesUp) {
            this.minDistributorNodesUp = minDistributorNodesUp;
            return this;
        }

        public Builder setMinStorageNodesUp(int minStorageNodesUp) {
            this.minStorageNodesUp = minStorageNodesUp;
            return this;
        }

        public Builder setMinRatioOfDistributorNodesUp(double minRatioOfDistributorNodesUp) {
            this.minRatioOfDistributorNodesUp = minRatioOfDistributorNodesUp;
            return this;
        }

        public Builder setMinRatioOfStorageNodesUp(double minRatioOfStorageNodesUp) {
            this.minRatioOfStorageNodesUp = minRatioOfStorageNodesUp;
            return this;
        }

        public Builder setMinNodeRatioPerGroup(double minNodeRatioPerGroup) {
            this.minNodeRatioPerGroup = minNodeRatioPerGroup;
            return this;
        }

        public Builder setCycleWaitTime(int cycleWaitTime) {
            this.cycleWaitTime = cycleWaitTime;
            return this;
        }

        public Builder setMinTimeBeforeFirstSystemStateBroadcast(long minTimeBeforeFirstSystemStateBroadcast) {
            this.minTimeBeforeFirstSystemStateBroadcast = minTimeBeforeFirstSystemStateBroadcast;
            return this;
        }

        public int nodeStateRequestTimeoutMS() {
            return this.nodeStateRequestTimeoutMS;
        }

        public Builder setNodeStateRequestTimeoutMS(int nodeStateRequestTimeoutMS) {
            this.nodeStateRequestTimeoutMS = nodeStateRequestTimeoutMS;
            return this;
        }

        public Builder setNodeStateRequestTimeoutEarliestPercentage(int nodeStateRequestTimeoutEarliestPercentage) {
            this.nodeStateRequestTimeoutEarliestPercentage = nodeStateRequestTimeoutEarliestPercentage;
            return this;
        }

        public Builder setNodeStateRequestTimeoutLatestPercentage(int nodeStateRequestTimeoutLatestPercentage) {
            this.nodeStateRequestTimeoutLatestPercentage = nodeStateRequestTimeoutLatestPercentage;
            return this;
        }

        public Builder setMinTimeBetweenNewSystemStates(int minTimeBetweenNewSystemStates) {
            this.minTimeBetweenNewSystemStates = minTimeBetweenNewSystemStates;
            return this;
        }

        public Builder setShowLocalSystemStatesInEventLog(boolean showLocalSystemStatesInEventLog) {
            this.showLocalSystemStatesInEventLog = showLocalSystemStatesInEventLog;
            return this;
        }

        public int maxSlobrokDisconnectGracePeriod() {
            return this.maxSlobrokDisconnectGracePeriod;
        }

        public Builder setMaxSlobrokDisconnectGracePeriod(int maxSlobrokDisconnectGracePeriod) {
            this.maxSlobrokDisconnectGracePeriod = maxSlobrokDisconnectGracePeriod;
            return this;
        }

        public Builder setStorageDistribution(Distribution storageDistribution) {
            this.storageDistribution = storageDistribution;
            return this;
        }

        public Set<ConfiguredNode> nodes() {
            return this.nodes;
        }

        public Builder setNodes(Set<ConfiguredNode> nodes) {
            this.nodes = nodes;
            return this;
        }

        public Builder setMaxDeferredTaskVersionWaitTime(Duration maxDeferredTaskVersionWaitTime) {
            this.maxDeferredTaskVersionWaitTime = maxDeferredTaskVersionWaitTime;
            return this;
        }

        public Builder setClusterHasGlobalDocumentTypes(boolean clusterHasGlobalDocumentTypes) {
            this.clusterHasGlobalDocumentTypes = clusterHasGlobalDocumentTypes;
            return this;
        }

        public Builder enableTwoPhaseClusterStateActivation(boolean enableTwoPhaseClusterStateActivation) {
            this.enableTwoPhaseClusterStateActivation = enableTwoPhaseClusterStateActivation;
            return this;
        }

        public double minMergeCompletionRatio() {
            return this.minMergeCompletionRatio;
        }

        public Builder setMinMergeCompletionRatio(double minMergeCompletionRatio) {
            this.minMergeCompletionRatio = minMergeCompletionRatio;
            return this;
        }

        public Builder setMaxDivergentNodesPrintedInTaskErrorMessages(int maxDivergentNodesPrintedInTaskErrorMessages) {
            this.maxDivergentNodesPrintedInTaskErrorMessages = maxDivergentNodesPrintedInTaskErrorMessages;
            return this;
        }

        public Builder setClusterFeedBlockEnabled(boolean clusterFeedBlockEnabled) {
            this.clusterFeedBlockEnabled = clusterFeedBlockEnabled;
            return this;
        }

        public Builder setClusterFeedBlockLimit(Map<String, Double> clusterFeedBlockLimit) {
            this.clusterFeedBlockLimit = Map.copyOf(clusterFeedBlockLimit);
            return this;
        }

        public Builder setClusterFeedBlockNoiseLevel(double clusterFeedBlockNoiseLevel) {
            this.clusterFeedBlockNoiseLevel = clusterFeedBlockNoiseLevel;
            return this;
        }

        public FleetControllerOptions build() {
            return new FleetControllerOptions(this.fleetControllerConfigId, this.slobrokConfigId, this.clusterName, this.index, this.count, this.stateGatherCount, this.slobrokConnectionSpecs, this.rpcPort, this.httpPort, this.distributionBits, this.zooKeeperSessionTimeout, this.masterZooKeeperCooldownPeriod, this.zooKeeperServerAddress, this.statePollingFrequency, this.maxTransitionTime, this.maxInitProgressTime, this.maxPrematureCrashes, this.stableStateTimePeriod, this.eventLogMaxSize, this.eventNodeLogMaxSize, this.minDistributorNodesUp, this.minStorageNodesUp, this.minRatioOfDistributorNodesUp, this.minRatioOfStorageNodesUp, this.minNodeRatioPerGroup, this.cycleWaitTime, this.minTimeBeforeFirstSystemStateBroadcast, this.nodeStateRequestTimeoutMS, this.nodeStateRequestTimeoutEarliestPercentage, this.nodeStateRequestTimeoutLatestPercentage, this.nodeStateRequestRoundTripTimeMaxSeconds, this.minTimeBetweenNewSystemStates, this.showLocalSystemStatesInEventLog, this.maxSlobrokDisconnectGracePeriod, this.slobrokBackOffPolicy, this.storageDistribution, this.nodes, this.maxDeferredTaskVersionWaitTime, this.clusterHasGlobalDocumentTypes, this.enableTwoPhaseClusterStateActivation, this.minMergeCompletionRatio, this.maxDivergentNodesPrintedInTaskErrorMessages, this.clusterFeedBlockEnabled, this.clusterFeedBlockLimit, this.clusterFeedBlockNoiseLevel);
        }

        public static Builder copy(FleetControllerOptions options) {
            Builder builder = new Builder(options.clusterName(), options.nodes());
            builder.fleetControllerConfigId = options.fleetControllerConfigId;
            builder.slobrokConfigId = options.slobrokConfigId;
            builder.clusterName = options.clusterName;
            builder.index = options.fleetControllerIndex;
            builder.count = options.fleetControllerCount;
            builder.stateGatherCount = options.stateGatherCount;
            builder.slobrokConnectionSpecs = options.slobrokConnectionSpecs;
            builder.rpcPort = options.rpcPort;
            builder.httpPort = options.httpPort;
            builder.distributionBits = options.distributionBits;
            builder.zooKeeperSessionTimeout = options.zooKeeperSessionTimeout;
            builder.masterZooKeeperCooldownPeriod = options.masterZooKeeperCooldownPeriod;
            builder.zooKeeperServerAddress = options.zooKeeperServerAddress;
            builder.statePollingFrequency = options.statePollingFrequency;
            builder.maxTransitionTime = Map.copyOf(options.maxTransitionTime);
            builder.maxInitProgressTime = options.maxInitProgressTime;
            builder.maxPrematureCrashes = options.maxPrematureCrashes;
            builder.stableStateTimePeriod = options.stableStateTimePeriod;
            builder.eventLogMaxSize = options.eventLogMaxSize;
            builder.eventNodeLogMaxSize = options.eventNodeLogMaxSize;
            builder.minDistributorNodesUp = options.minDistributorNodesUp;
            builder.minStorageNodesUp = options.minStorageNodesUp;
            builder.minRatioOfDistributorNodesUp = options.minRatioOfStorageNodesUp;
            builder.minRatioOfStorageNodesUp = options.minRatioOfStorageNodesUp;
            builder.minNodeRatioPerGroup = options.minNodeRatioPerGroup;
            builder.cycleWaitTime = options.cycleWaitTime;
            builder.minTimeBeforeFirstSystemStateBroadcast = options.minTimeBeforeFirstSystemStateBroadcast;
            builder.nodeStateRequestTimeoutMS = options.nodeStateRequestTimeoutMS;
            builder.nodeStateRequestTimeoutEarliestPercentage = options.nodeStateRequestTimeoutEarliestPercentage;
            builder.nodeStateRequestTimeoutLatestPercentage = options.nodeStateRequestTimeoutLatestPercentage;
            builder.nodeStateRequestRoundTripTimeMaxSeconds = options.nodeStateRequestRoundTripTimeMaxSeconds;
            builder.minTimeBetweenNewSystemStates = options.minTimeBetweenNewSystemStates;
            builder.showLocalSystemStatesInEventLog = options.showLocalSystemStatesInEventLog;
            builder.maxSlobrokDisconnectGracePeriod = options.maxSlobrokDisconnectGracePeriod;
            builder.slobrokBackOffPolicy = options.slobrokBackOffPolicy;
            builder.storageDistribution = options.storageDistribution;
            builder.nodes = Set.copyOf(options.nodes);
            builder.maxDeferredTaskVersionWaitTime = options.maxDeferredTaskVersionWaitTime;
            builder.clusterHasGlobalDocumentTypes = options.clusterHasGlobalDocumentTypes;
            builder.enableTwoPhaseClusterStateActivation = options.enableTwoPhaseClusterStateActivation;
            builder.minMergeCompletionRatio = options.minMergeCompletionRatio;
            builder.maxDivergentNodesPrintedInTaskErrorMessages = options.maxDivergentNodesPrintedInTaskErrorMessages;
            builder.clusterFeedBlockEnabled = options.clusterFeedBlockEnabled;
            builder.clusterFeedBlockLimit = Map.copyOf(options.clusterFeedBlockLimit);
            builder.clusterFeedBlockNoiseLevel = options.clusterFeedBlockNoiseLevel;
            return builder;
        }
    }
}

