/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.jrt.slobrok.api.BackOffPolicy;
import com.yahoo.vdslib.distribution.ConfiguredNode;
import com.yahoo.vdslib.distribution.Distribution;
import com.yahoo.vdslib.state.NodeType;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class FleetControllerOptions
implements Cloneable {
    public String fleetControllerConfigId;
    public String slobrokConfigId;
    public String clusterName;
    public int fleetControllerIndex = 0;
    public int fleetControllerCount = 1;
    public int stateGatherCount = 2;
    public String[] slobrokConnectionSpecs;
    public int rpcPort = 0;
    public int httpPort = 0;
    public int distributionBits = 16;
    public int zooKeeperSessionTimeout = 300000;
    public int masterZooKeeperCooldownPeriod = 15000;
    public String zooKeeperServerAddress = null;
    public int statePollingFrequency = 5000;
    public Map<NodeType, Integer> maxTransitionTime = new TreeMap<NodeType, Integer>();
    public int maxInitProgressTime = 5000;
    public int maxPrematureCrashes = 4;
    public long stableStateTimePeriod = 0x6DDD00L;
    public int eventLogMaxSize = 1024;
    public int eventNodeLogMaxSize = 1024;
    public int minDistributorNodesUp = 1;
    public int minStorageNodesUp = 1;
    public double minRatioOfDistributorNodesUp = 0.5;
    public double minRatioOfStorageNodesUp = 0.5;
    public double minNodeRatioPerGroup = 0.0;
    public int cycleWaitTime = 100;
    public long minTimeBeforeFirstSystemStateBroadcast = 0L;
    public int nodeStateRequestTimeoutMS = 300000;
    public int nodeStateRequestTimeoutEarliestPercentage = 80;
    public int nodeStateRequestTimeoutLatestPercentage = 95;
    public int nodeStateRequestRoundTripTimeMaxSeconds = 5;
    public int minTimeBetweenNewSystemStates = 0;
    public boolean showLocalSystemStatesInEventLog = true;
    public int maxSlobrokDisconnectGracePeriod = 1000;
    public BackOffPolicy slobrokBackOffPolicy = null;
    public Distribution storageDistribution;
    public Set<ConfiguredNode> nodes;
    public Duration maxDeferredTaskVersionWaitTime = Duration.ofSeconds(30L);
    public boolean clusterHasGlobalDocumentTypes = false;
    public boolean enableTwoPhaseClusterStateActivation = false;
    public double minMergeCompletionRatio = 1.0;
    public int maxDivergentNodesPrintedInTaskErrorMessages = 10;
    public boolean clusterFeedBlockEnabled = false;
    public Map<String, Double> clusterFeedBlockLimit = Collections.emptyMap();
    public double clusterFeedBlockNoiseLevel = 0.01;

    public FleetControllerOptions(String clusterName, Collection<ConfiguredNode> nodes) {
        this.clusterName = clusterName;
        this.maxTransitionTime.put(NodeType.DISTRIBUTOR, 0);
        this.maxTransitionTime.put(NodeType.STORAGE, 5000);
        this.nodes = new TreeSet<ConfiguredNode>(nodes);
    }

    public void setStorageDistribution(Distribution distribution) {
        this.storageDistribution = distribution;
    }

    public Duration getMaxDeferredTaskVersionWaitTime() {
        return this.maxDeferredTaskVersionWaitTime;
    }

    public void setMaxDeferredTaskVersionWaitTime(Duration maxDeferredTaskVersionWaitTime) {
        this.maxDeferredTaskVersionWaitTime = maxDeferredTaskVersionWaitTime;
    }

    public long storageNodeMaxTransitionTimeMs() {
        return this.maxTransitionTime.getOrDefault(NodeType.STORAGE, 10000).intValue();
    }

    public FleetControllerOptions clone() {
        try {
            return (FleetControllerOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Will not happen");
        }
    }
}

