/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vespa.clustercontroller.core.AnnotatedClusterState;
import com.yahoo.vespa.clustercontroller.core.ClusterStateBundle;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class ClusterStateHistoryEntry {
    public static final String BASELINE = "-";
    private final long time;
    private final Map<String, String> states = new TreeMap<String, String>();
    private final Map<String, String> diffs = new TreeMap<String, String>();

    ClusterStateHistoryEntry(ClusterStateBundle state, long time) {
        this.time = time;
        this.populateStateStrings(state);
    }

    ClusterStateHistoryEntry(ClusterStateBundle state, ClusterStateBundle prevState, long time) {
        this.time = time;
        this.populateStateStrings(state);
        this.populateDiffStrings(state, prevState);
    }

    private void populateStateStrings(ClusterStateBundle state) {
        this.states.put(BASELINE, state.getBaselineClusterState().toString());
        Map<String, String> derivedStates = state.getDerivedBucketSpaceStates().entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((AnnotatedClusterState)entry.getValue()).getClusterState().toString()));
        this.states.putAll(derivedStates);
    }

    private void populateDiffStrings(ClusterStateBundle state, ClusterStateBundle prevState) {
        this.diffs.put(BASELINE, prevState.getBaselineClusterState().getHtmlDifference(state.getBaselineClusterState()));
        Map<String, String> spaceDiffs = state.getDerivedBucketSpaceStates().entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ClusterStateHistoryEntry.derivedStateOf(prevState, (String)entry.getKey()).getHtmlDifference(((AnnotatedClusterState)entry.getValue()).getClusterState())));
        this.diffs.putAll(spaceDiffs);
    }

    public static ClusterStateHistoryEntry makeFirstEntry(ClusterStateBundle state, long time) {
        return new ClusterStateHistoryEntry(state, time);
    }

    public static ClusterStateHistoryEntry makeSuccessor(ClusterStateBundle state, ClusterStateBundle prevState, long time) {
        return new ClusterStateHistoryEntry(state, prevState, time);
    }

    private static ClusterState derivedStateOf(ClusterStateBundle state, String space) {
        return state.getDerivedBucketSpaceStates().getOrDefault(space, AnnotatedClusterState.emptyState()).getClusterState();
    }

    public Map<String, String> getRawStates() {
        return this.states;
    }

    public String getStateString(String space) {
        return this.states.getOrDefault(space, "");
    }

    public String getDiffString(String space) {
        return this.diffs.getOrDefault(space, "");
    }

    public long time() {
        return this.time;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterStateHistoryEntry that = (ClusterStateHistoryEntry)o;
        return this.time == that.time && Objects.equals(this.states, that.states) && Objects.equals(this.diffs, that.diffs);
    }

    public int hashCode() {
        return Objects.hash(this.time, this.states, this.diffs);
    }

    public String toString() {
        return String.format("state '%s' at time %d", this.getStateString(BASELINE), this.time);
    }
}

