/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.AnnotatedClusterState;
import com.yahoo.vespa.clustercontroller.core.ClusterStateReason;
import com.yahoo.vespa.clustercontroller.core.ContentCluster;
import com.yahoo.vespa.clustercontroller.core.FleetControllerOptions;
import com.yahoo.vespa.clustercontroller.core.GroupAvailabilityCalculator;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.NodeStateReason;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

public class ClusterStateGenerator {
    static AnnotatedClusterState generatedStateFrom(Params params) {
        ContentCluster cluster = params.cluster;
        ClusterState workingState = ClusterState.emptyState();
        HashMap<Node, NodeStateReason> nodeStateReasons = new HashMap<Node, NodeStateReason>();
        for (NodeInfo nodeInfo : cluster.getNodeInfos()) {
            NodeState nodeState = ClusterStateGenerator.computeEffectiveNodeState(nodeInfo, params, nodeStateReasons);
            workingState.setNodeState(nodeInfo.getNode(), nodeState);
        }
        ClusterStateGenerator.takeDownGroupsWithTooLowAvailability(workingState, nodeStateReasons, params);
        Optional<ClusterStateReason> reasonToBeDown = ClusterStateGenerator.clusterDownReason(workingState, params);
        if (reasonToBeDown.isPresent()) {
            workingState.setClusterState(State.DOWN);
        }
        workingState.setDistributionBits(ClusterStateGenerator.inferDistributionBitCount(cluster, workingState, params));
        return new AnnotatedClusterState(workingState, reasonToBeDown, nodeStateReasons);
    }

    private static boolean nodeIsConsideredTooUnstable(NodeInfo nodeInfo, Params params) {
        return params.maxPrematureCrashes != 0 && nodeInfo.getPrematureCrashCount() > params.maxPrematureCrashes;
    }

    private static void applyWantedStateToBaselineState(NodeState baseline, NodeState wanted) {
        baseline.setState(wanted.getState());
        baseline.setDescription(wanted.getDescription());
    }

    private static NodeState computeEffectiveNodeState(NodeInfo nodeInfo, Params params, Map<Node, NodeStateReason> nodeStateReasons) {
        NodeState reported = nodeInfo.getReportedState();
        NodeState wanted = nodeInfo.getWantedState();
        NodeState baseline = reported.clone();
        if (ClusterStateGenerator.nodeIsConsideredTooUnstable(nodeInfo, params)) {
            baseline.setState(State.DOWN);
        }
        if (ClusterStateGenerator.startupTimestampAlreadyObservedByAllNodes(nodeInfo, baseline)) {
            baseline.setStartTimestamp(0L);
        }
        if (nodeInfo.isStorage()) {
            ClusterStateGenerator.applyStorageSpecificStateTransforms(nodeInfo, params, reported, wanted, baseline, nodeStateReasons);
        }
        if (baseline.above(wanted)) {
            ClusterStateGenerator.applyWantedStateToBaselineState(baseline, wanted);
        }
        return baseline;
    }

    private static void applyStorageSpecificStateTransforms(NodeInfo nodeInfo, Params params, NodeState reported, NodeState wanted, NodeState baseline, Map<Node, NodeStateReason> nodeStateReasons) {
        if (reported.getState() == State.INITIALIZING) {
            if (ClusterStateGenerator.timedOutWithoutNewInitProgress(reported, nodeInfo, params) || ClusterStateGenerator.shouldForceInitToDown(reported) || nodeInfo.recentlyObservedUnstableDuringInit()) {
                baseline.setState(State.DOWN);
            }
            if (ClusterStateGenerator.shouldForceInitToMaintenance(reported, wanted)) {
                baseline.setState(State.MAINTENANCE);
            }
        }
        if (ClusterStateGenerator.withinTemporalMaintenancePeriod(nodeInfo, baseline, nodeStateReasons, params) && wanted.getState() != State.DOWN) {
            baseline.setState(State.MAINTENANCE);
        }
    }

    private static boolean timedOutWithoutNewInitProgress(NodeState reported, NodeInfo nodeInfo, Params params) {
        if (reported.getState() != State.INITIALIZING) {
            return false;
        }
        if (params.maxInitProgressTimeMs <= 0) {
            return false;
        }
        return nodeInfo.getInitProgressTime() + (long)params.maxInitProgressTimeMs <= params.currentTimeInMillis;
    }

    private static boolean shouldForceInitToDown(NodeState reported) {
        return reported.getInitProgress() <= (double)NodeState.getListingBucketsInitProgressLimit() + 1.0E-5;
    }

    private static boolean shouldForceInitToMaintenance(NodeState reported, NodeState wanted) {
        return reported.getState() == State.INITIALIZING && wanted.getState() == State.RETIRED;
    }

    private static boolean startupTimestampAlreadyObservedByAllNodes(NodeInfo nodeInfo, NodeState baseline) {
        return baseline.getStartTimestamp() == nodeInfo.getStartTimestamp();
    }

    private static boolean withinTemporalMaintenancePeriod(NodeInfo nodeInfo, NodeState baseline, Map<Node, NodeStateReason> nodeStateReasons, Params params) {
        Integer transitionTime = params.transitionTimes.get(nodeInfo.getNode().getType());
        if (transitionTime == 0 || !baseline.getState().oneOf("sd")) {
            return false;
        }
        if (nodeInfo.getTransitionTime() + (long)transitionTime.intValue() > params.currentTimeInMillis) {
            return true;
        }
        nodeStateReasons.put(nodeInfo.getNode(), NodeStateReason.NODE_NOT_BACK_UP_WITHIN_GRACE_PERIOD);
        return false;
    }

    private static void takeDownGroupsWithTooLowAvailability(ClusterState workingState, Map<Node, NodeStateReason> nodeStateReasons, Params params) {
        GroupAvailabilityCalculator calc = new GroupAvailabilityCalculator.Builder().withMinNodeRatioPerGroup(params.minNodeRatioPerGroup).withDistribution(params.cluster.getDistribution()).withNodesSafelySetToMaintenance(params.cluster.nodesSafelySetTo(State.MAINTENANCE)).build();
        GroupAvailabilityCalculator.Result result = calc.calculate(workingState);
        for (int index : result.nodesThatShouldBeMaintained()) {
            ClusterStateGenerator.setNewNodeState(index, NodeType.STORAGE, State.MAINTENANCE, "too many safe maintenance nodes in group", NodeStateReason.GROUP_IN_MAINTENANCE, workingState, nodeStateReasons);
            ClusterStateGenerator.setNewNodeState(index, NodeType.DISTRIBUTOR, State.DOWN, "too many safe maintenance nodes in group", NodeStateReason.GROUP_IN_MAINTENANCE, workingState, nodeStateReasons);
        }
        for (int index : result.nodesThatShouldBeDown()) {
            ClusterStateGenerator.setNewNodeState(index, NodeType.STORAGE, State.DOWN, "group node availability below configured threshold", NodeStateReason.GROUP_IS_DOWN, workingState, nodeStateReasons);
        }
    }

    private static void setNewNodeState(int index, NodeType nodeType, State newState, String description, NodeStateReason nodeStateReason, ClusterState workingState, Map<Node, NodeStateReason> nodeStateReasons) {
        Node node = new Node(nodeType, index);
        NodeState newNodeState = new NodeState(nodeType, newState).setDescription(description);
        workingState.setNodeState(node, newNodeState);
        nodeStateReasons.put(node, nodeStateReason);
    }

    private static Node storageNode(int index) {
        return new Node(NodeType.STORAGE, index);
    }

    private static int inferDistributionBitCount(ContentCluster cluster, ClusterState state, Params params) {
        int bitCount = params.idealDistributionBits;
        Optional<Integer> minBits = cluster.getConfiguredNodes().values().stream().map(configuredNode -> cluster.getNodeInfo(ClusterStateGenerator.storageNode(configuredNode.index()))).filter(node -> state.getNodeState(node.getNode()).getState().oneOf("iur")).map(nodeInfo -> nodeInfo.getReportedState().getMinUsedBits()).min(Integer::compare);
        if (minBits.isPresent() && minBits.get() < bitCount) {
            bitCount = minBits.get();
        }
        if (bitCount > params.lowestObservedDistributionBitCount && bitCount < params.idealDistributionBits) {
            bitCount = params.lowestObservedDistributionBitCount;
        }
        return bitCount;
    }

    private static boolean nodeStateIsConsideredAvailable(NodeState ns) {
        return ns.getState() == State.UP || ns.getState() == State.RETIRED || ns.getState() == State.INITIALIZING;
    }

    private static long countAvailableNodesOfType(NodeType type, ContentCluster cluster, ClusterState state) {
        return cluster.getConfiguredNodes().values().stream().map(node -> state.getNodeState(new Node(type, node.index()))).filter(ClusterStateGenerator::nodeStateIsConsideredAvailable).count();
    }

    private static Optional<ClusterStateReason> clusterDownReason(ClusterState state, Params params) {
        ContentCluster cluster = params.cluster;
        long upStorageCount = ClusterStateGenerator.countAvailableNodesOfType(NodeType.STORAGE, cluster, state);
        long upDistributorCount = ClusterStateGenerator.countAvailableNodesOfType(NodeType.DISTRIBUTOR, cluster, state);
        long nodeCount = cluster.getConfiguredNodes().size();
        if (upStorageCount < (long)params.minStorageNodesUp) {
            return Optional.of(ClusterStateReason.TOO_FEW_STORAGE_NODES_AVAILABLE);
        }
        if (upDistributorCount < (long)params.minDistributorNodesUp) {
            return Optional.of(ClusterStateReason.TOO_FEW_DISTRIBUTOR_NODES_AVAILABLE);
        }
        if (params.minRatioOfStorageNodesUp * (double)nodeCount > (double)upStorageCount) {
            return Optional.of(ClusterStateReason.TOO_LOW_AVAILABLE_STORAGE_NODE_RATIO);
        }
        if (params.minRatioOfDistributorNodesUp * (double)nodeCount > (double)upDistributorCount) {
            return Optional.of(ClusterStateReason.TOO_LOW_AVAILABLE_DISTRIBUTOR_NODE_RATIO);
        }
        return Optional.empty();
    }

    static class Params {
        public ContentCluster cluster;
        public Map<NodeType, Integer> transitionTimes = Params.buildTransitionTimeMap(0, 0);
        public long currentTimeInMillis = 0L;
        public int maxPrematureCrashes = 0;
        public int minStorageNodesUp = 1;
        public int minDistributorNodesUp = 1;
        public double minRatioOfStorageNodesUp = 0.0;
        public double minRatioOfDistributorNodesUp = 0.0;
        public double minNodeRatioPerGroup = 0.0;
        public int idealDistributionBits = 16;
        public int highestObservedDistributionBitCount = 16;
        public int lowestObservedDistributionBitCount = 16;
        public int maxInitProgressTimeMs = 5000;

        Params() {
        }

        static Map<NodeType, Integer> buildTransitionTimeMap(int distributorTransitionTimeMs, int storageTransitionTimeMs) {
            TreeMap<NodeType, Integer> maxTransitionTime = new TreeMap<NodeType, Integer>();
            maxTransitionTime.put(NodeType.DISTRIBUTOR, distributorTransitionTimeMs);
            maxTransitionTime.put(NodeType.STORAGE, storageTransitionTimeMs);
            return maxTransitionTime;
        }

        Params cluster(ContentCluster cluster) {
            this.cluster = cluster;
            return this;
        }

        Params maxInitProgressTime(int maxTimeMs) {
            this.maxInitProgressTimeMs = maxTimeMs;
            return this;
        }

        Params transitionTimes(int timeMs) {
            this.transitionTimes = Params.buildTransitionTimeMap(timeMs, timeMs);
            return this;
        }

        Params transitionTimes(Map<NodeType, Integer> timesMs) {
            this.transitionTimes = timesMs;
            return this;
        }

        Params currentTimeInMillis(long currentTimeMs) {
            this.currentTimeInMillis = currentTimeMs;
            return this;
        }

        Params maxPrematureCrashes(int count) {
            this.maxPrematureCrashes = count;
            return this;
        }

        Params minStorageNodesUp(int nodes) {
            this.minStorageNodesUp = nodes;
            return this;
        }

        Params minDistributorNodesUp(int nodes) {
            this.minDistributorNodesUp = nodes;
            return this;
        }

        Params minRatioOfStorageNodesUp(double minRatio) {
            this.minRatioOfStorageNodesUp = minRatio;
            return this;
        }

        Params minRatioOfDistributorNodesUp(double minRatio) {
            this.minRatioOfDistributorNodesUp = minRatio;
            return this;
        }

        Params minNodeRatioPerGroup(double minRatio) {
            this.minNodeRatioPerGroup = minRatio;
            return this;
        }

        Params idealDistributionBits(int distributionBits) {
            this.idealDistributionBits = distributionBits;
            return this;
        }

        Params highestObservedDistributionBitCount(int bitCount) {
            this.highestObservedDistributionBitCount = bitCount;
            return this;
        }

        Params lowestObservedDistributionBitCount(int bitCount) {
            this.lowestObservedDistributionBitCount = bitCount;
            return this;
        }

        static Params fromOptions(FleetControllerOptions opts) {
            return new Params().maxPrematureCrashes(opts.maxPrematureCrashes).minStorageNodesUp(opts.minStorageNodesUp).minDistributorNodesUp(opts.minDistributorNodesUp).minRatioOfStorageNodesUp(opts.minRatioOfStorageNodesUp).minRatioOfDistributorNodesUp(opts.minRatioOfDistributorNodesUp).minNodeRatioPerGroup(opts.minNodeRatioPerGroup).idealDistributionBits(opts.distributionBits).transitionTimes(opts.maxTransitionTime);
        }
    }
}

