/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.document.FixedBucketSpaces;
import com.yahoo.vdslib.distribution.ConfiguredNode;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.AggregatedClusterStats;
import com.yahoo.vespa.clustercontroller.core.AnnotatedClusterState;
import com.yahoo.vespa.clustercontroller.core.ClusterEvent;
import com.yahoo.vespa.clustercontroller.core.ClusterStateBundle;
import com.yahoo.vespa.clustercontroller.core.ClusterStateDeriver;
import com.yahoo.vespa.clustercontroller.core.ClusterStateGenerator;
import com.yahoo.vespa.clustercontroller.core.Communicator;
import com.yahoo.vespa.clustercontroller.core.ContentCluster;
import com.yahoo.vespa.clustercontroller.core.Event;
import com.yahoo.vespa.clustercontroller.core.EventDiffCalculator;
import com.yahoo.vespa.clustercontroller.core.EventLog;
import com.yahoo.vespa.clustercontroller.core.FleetControllerContext;
import com.yahoo.vespa.clustercontroller.core.FleetControllerContextImpl;
import com.yahoo.vespa.clustercontroller.core.FleetControllerId;
import com.yahoo.vespa.clustercontroller.core.FleetControllerOptions;
import com.yahoo.vespa.clustercontroller.core.GlobalBucketSyncStatsCalculator;
import com.yahoo.vespa.clustercontroller.core.MaintenanceTransitionConstraint;
import com.yahoo.vespa.clustercontroller.core.MaintenanceWhenPendingGlobalMerges;
import com.yahoo.vespa.clustercontroller.core.MasterElectionHandler;
import com.yahoo.vespa.clustercontroller.core.MasterInterface;
import com.yahoo.vespa.clustercontroller.core.MetricUpdater;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.NodeLookup;
import com.yahoo.vespa.clustercontroller.core.NodeResourceExhaustion;
import com.yahoo.vespa.clustercontroller.core.NodeStateGatherer;
import com.yahoo.vespa.clustercontroller.core.RealTimer;
import com.yahoo.vespa.clustercontroller.core.RemoteClusterControllerTask;
import com.yahoo.vespa.clustercontroller.core.RemoteClusterControllerTaskScheduler;
import com.yahoo.vespa.clustercontroller.core.ResourceExhaustionCalculator;
import com.yahoo.vespa.clustercontroller.core.ResourceUsageStats;
import com.yahoo.vespa.clustercontroller.core.StateChangeHandler;
import com.yahoo.vespa.clustercontroller.core.StateVersionTracker;
import com.yahoo.vespa.clustercontroller.core.SystemStateBroadcaster;
import com.yahoo.vespa.clustercontroller.core.Timer;
import com.yahoo.vespa.clustercontroller.core.UpEdgeMaintenanceTransitionConstraint;
import com.yahoo.vespa.clustercontroller.core.VersionDependentTaskCompletion;
import com.yahoo.vespa.clustercontroller.core.database.DatabaseHandler;
import com.yahoo.vespa.clustercontroller.core.hostinfo.HostInfo;
import com.yahoo.vespa.clustercontroller.core.listeners.NodeListener;
import com.yahoo.vespa.clustercontroller.core.listeners.SlobrokListener;
import com.yahoo.vespa.clustercontroller.core.listeners.SystemStateListener;
import com.yahoo.vespa.clustercontroller.core.rpc.RPCCommunicator;
import com.yahoo.vespa.clustercontroller.core.rpc.RpcServer;
import com.yahoo.vespa.clustercontroller.core.rpc.SlobrokClient;
import com.yahoo.vespa.clustercontroller.core.status.ClusterStateRequestHandler;
import com.yahoo.vespa.clustercontroller.core.status.LegacyIndexPageRequestHandler;
import com.yahoo.vespa.clustercontroller.core.status.LegacyNodePageRequestHandler;
import com.yahoo.vespa.clustercontroller.core.status.NodeHealthRequestHandler;
import com.yahoo.vespa.clustercontroller.core.status.StatusHandler;
import com.yahoo.vespa.clustercontroller.core.status.statuspage.StatusPageServer;
import com.yahoo.vespa.clustercontroller.utils.util.MetricReporter;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class FleetController
implements NodeListener,
SlobrokListener,
SystemStateListener,
Runnable,
RemoteClusterControllerTaskScheduler {
    private static final Logger logger = Logger.getLogger(FleetController.class.getName());
    private final FleetControllerContext context;
    private final Timer timer;
    private final Object monitor;
    private final EventLog eventLog;
    private final NodeLookup nodeLookup;
    private final ContentCluster cluster;
    private final Communicator communicator;
    private final NodeStateGatherer stateGatherer;
    private final StateChangeHandler stateChangeHandler;
    private final SystemStateBroadcaster systemStateBroadcaster;
    private final StateVersionTracker stateVersionTracker;
    private final StatusHandler.ContainerStatusPageServer statusPageServer;
    private final RpcServer rpcServer;
    private final DatabaseHandler database;
    private final MasterElectionHandler masterElectionHandler;
    private Thread runner = null;
    private final AtomicBoolean running = new AtomicBoolean(true);
    private FleetControllerOptions options;
    private FleetControllerOptions nextOptions;
    private final List<SystemStateListener> systemStateListeners = new CopyOnWriteArrayList<SystemStateListener>();
    private boolean processingCycle = false;
    private boolean wantedStateChanged = false;
    private long cycleCount = 0L;
    private long lastMetricUpdateCycleCount = 0L;
    private long nextStateSendTime = 0L;
    private Long controllerThreadId = null;
    private boolean waitingForCycle = false;
    private final StatusPageServer.PatternRequestRouter statusRequestRouter = new StatusPageServer.PatternRequestRouter();
    private final List<ClusterStateBundle> newStates = new ArrayList<ClusterStateBundle>();
    private final List<ClusterStateBundle> convergedStates = new ArrayList<ClusterStateBundle>();
    private final Queue<RemoteClusterControllerTask> remoteTasks = new LinkedList<RemoteClusterControllerTask>();
    private final MetricUpdater metricUpdater;
    private final LegacyIndexPageRequestHandler indexPageRequestHandler;
    private boolean isMaster = false;
    private boolean inMasterMoratorium = false;
    private boolean isStateGatherer = false;
    private long firstAllowedStateBroadcast = Long.MAX_VALUE;
    private long tickStartTime = Long.MAX_VALUE;
    private final List<RemoteClusterControllerTask> tasksPendingStateRecompute = new ArrayList<RemoteClusterControllerTask>();
    private final Queue<VersionDependentTaskCompletion> taskCompletionQueue = new ArrayDeque<VersionDependentTaskCompletion>();
    private final Set<String> configuredBucketSpaces = Set.of(FixedBucketSpaces.defaultSpace(), FixedBucketSpaces.globalSpace());
    public final DatabaseHandler.DatabaseContext databaseContext = new DatabaseHandler.DatabaseContext(){

        @Override
        public ContentCluster getCluster() {
            return FleetController.this.cluster;
        }

        @Override
        public FleetController getFleetController() {
            return FleetController.this;
        }

        @Override
        public NodeListener getNodeStateUpdateListener() {
            return FleetController.this;
        }
    };

    public FleetController(FleetControllerContext context, Timer timer, EventLog eventLog, ContentCluster cluster, NodeStateGatherer nodeStateGatherer, Communicator communicator, RpcServer server, NodeLookup nodeLookup, DatabaseHandler database, StateChangeHandler stateChangeHandler, SystemStateBroadcaster systemStateBroadcaster, MasterElectionHandler masterElectionHandler, MetricUpdater metricUpdater, FleetControllerOptions options) {
        context.log(logger, Level.FINE, "Created");
        this.context = context;
        this.timer = timer;
        this.monitor = timer;
        this.eventLog = eventLog;
        this.options = options;
        this.nodeLookup = nodeLookup;
        this.cluster = cluster;
        this.communicator = communicator;
        this.database = database;
        this.stateGatherer = nodeStateGatherer;
        this.stateChangeHandler = stateChangeHandler;
        this.systemStateBroadcaster = systemStateBroadcaster;
        this.stateVersionTracker = new StateVersionTracker(options.minMergeCompletionRatio());
        this.metricUpdater = metricUpdater;
        this.statusPageServer = new StatusHandler.ContainerStatusPageServer();
        this.rpcServer = server;
        this.masterElectionHandler = masterElectionHandler;
        this.statusRequestRouter.addHandler(new LegacyNodePageRequestHandler(timer, eventLog, cluster));
        this.statusRequestRouter.addHandler(new NodeHealthRequestHandler());
        this.statusRequestRouter.addHandler(new ClusterStateRequestHandler(this.stateVersionTracker));
        this.indexPageRequestHandler = new LegacyIndexPageRequestHandler(timer, cluster, masterElectionHandler, this.stateVersionTracker, eventLog, options);
        this.statusRequestRouter.addHandler(this.indexPageRequestHandler);
        this.propagateOptions();
    }

    public static FleetController create(FleetControllerOptions options, MetricReporter metricReporter) throws Exception {
        FleetControllerContextImpl context = new FleetControllerContextImpl(options);
        RealTimer timer = new RealTimer();
        MetricUpdater metricUpdater = new MetricUpdater(metricReporter, options.fleetControllerIndex(), options.clusterName());
        EventLog log = new EventLog(timer, metricUpdater);
        ContentCluster cluster = new ContentCluster(options);
        NodeStateGatherer stateGatherer = new NodeStateGatherer(timer, timer, log);
        RPCCommunicator communicator = new RPCCommunicator(RPCCommunicator.createRealSupervisor(), timer, options.fleetControllerIndex(), options.nodeStateRequestTimeoutMS(), options.nodeStateRequestTimeoutEarliestPercentage(), options.nodeStateRequestTimeoutLatestPercentage(), options.nodeStateRequestRoundTripTimeMaxSeconds());
        DatabaseHandler database = new DatabaseHandler(context, options.dbFactoryFn().apply(context), timer, options.zooKeeperServerAddress(), timer);
        SlobrokClient lookUp = new SlobrokClient(context, timer, options.slobrokConnectionSpecs());
        StateChangeHandler stateGenerator = new StateChangeHandler(context, timer, log);
        SystemStateBroadcaster stateBroadcaster = new SystemStateBroadcaster(context, timer, timer);
        MasterElectionHandler masterElectionHandler = new MasterElectionHandler(context, options.fleetControllerIndex(), options.fleetControllerCount(), timer, timer);
        FleetController controller = new FleetController(context, timer, log, cluster, stateGatherer, communicator, null, lookUp, database, stateGenerator, stateBroadcaster, masterElectionHandler, metricUpdater, options);
        controller.start();
        return controller;
    }

    public void start() {
        this.runner = new Thread(this);
        this.runner.start();
    }

    public Object getMonitor() {
        return this.monitor;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMaster() {
        Object object = this.monitor;
        synchronized (object) {
            return this.isMaster;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterState getClusterState() {
        Object object = this.monitor;
        synchronized (object) {
            return this.systemStateBroadcaster.getClusterState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterStateBundle getClusterStateBundle() {
        Object object = this.monitor;
        synchronized (object) {
            return this.systemStateBroadcaster.getClusterStateBundle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(RemoteClusterControllerTask task) {
        Object object = this.monitor;
        synchronized (object) {
            this.context.log(logger, Level.FINE, "Scheduled remote task " + task.getClass().getName() + " for execution");
            this.remoteTasks.add(task);
        }
    }

    public void addSystemStateListener(SystemStateListener listener) {
        this.systemStateListeners.add(listener);
        ClusterState state = this.getSystemState();
        listener.handleNewPublishedState(ClusterStateBundle.ofBaselineOnly(AnnotatedClusterState.withoutAnnotations(state)));
        ClusterStateBundle convergedState = this.systemStateBroadcaster.getLastClusterStateBundleConverged();
        if (convergedState != null) {
            listener.handleStateConvergedInCluster(convergedState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FleetControllerOptions getOptions() {
        Object object = this.monitor;
        synchronized (object) {
            return FleetControllerOptions.Builder.copy(this.options).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeState getReportedNodeState(Node n) {
        Object object = this.monitor;
        synchronized (object) {
            NodeInfo node = this.cluster.getNodeInfo(n);
            if (node == null) {
                throw new IllegalStateException("Did not find node " + n + " in cluster " + this.cluster);
            }
            return node.getReportedState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeState getWantedNodeState(Node n) {
        Object object = this.monitor;
        synchronized (object) {
            return this.cluster.getNodeInfo(n).getWantedState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterState getSystemState() {
        Object object = this.monitor;
        synchronized (object) {
            return this.stateVersionTracker.getVersionedClusterState();
        }
    }

    public int getRpcPort() {
        return this.rpcServer.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws InterruptedException {
        if (this.runner != null && this.isRunning()) {
            this.context.log(logger, Level.INFO, "Joining event thread.");
            this.running.set(false);
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notifyAll();
            }
            this.runner.join();
        }
        this.context.log(logger, Level.INFO, "FleetController done shutting down event thread.");
        this.controllerThreadId = Thread.currentThread().getId();
        this.database.shutdown(this.databaseContext);
        if (this.rpcServer != null) {
            this.rpcServer.shutdown();
        }
        this.communicator.shutdown();
        this.nodeLookup.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOptions(FleetControllerOptions options) {
        FleetControllerId newId = FleetControllerId.fromOptions(options);
        Object object = this.monitor;
        synchronized (object) {
            assert (newId.equals(this.context.id()));
            this.context.log(logger, Level.INFO, "FleetController has new options");
            this.nextOptions = FleetControllerOptions.Builder.copy(options).build();
            this.monitor.notifyAll();
        }
    }

    private void verifyInControllerThread() {
        if (this.controllerThreadId != null && this.controllerThreadId.longValue() != Thread.currentThread().getId()) {
            throw new IllegalStateException("Function called from non-controller thread. Shouldn't happen.");
        }
    }

    private ClusterState latestCandidateClusterState() {
        return this.stateVersionTracker.getLatestCandidateState().getClusterState();
    }

    @Override
    public void handleNewNodeState(NodeInfo node, NodeState newState) {
        this.verifyInControllerThread();
        this.stateChangeHandler.handleNewReportedNodeState(this.latestCandidateClusterState(), node, newState, this);
    }

    @Override
    public void handleNewWantedNodeState(NodeInfo node, NodeState newState) {
        this.verifyInControllerThread();
        this.wantedStateChanged = true;
        this.stateChangeHandler.proposeNewNodeState(this.stateVersionTracker.getVersionedClusterState(), node, newState);
    }

    @Override
    public void handleRemovedNode(Node node) {
        this.verifyInControllerThread();
        this.wantedStateChanged = true;
    }

    @Override
    public void handleUpdatedHostInfo(NodeInfo nodeInfo, HostInfo newHostInfo) {
        this.verifyInControllerThread();
        this.triggerBundleRecomputationIfResourceExhaustionStateChanged(nodeInfo, newHostInfo);
        this.stateVersionTracker.handleUpdatedHostInfo(nodeInfo, newHostInfo);
    }

    private void triggerBundleRecomputationIfResourceExhaustionStateChanged(NodeInfo nodeInfo, HostInfo newHostInfo) {
        Set<NodeResourceExhaustion> nowExhausted;
        if (!this.options.clusterFeedBlockEnabled()) {
            return;
        }
        ResourceExhaustionCalculator calc = this.createResourceExhaustionCalculator();
        Set<NodeResourceExhaustion> previouslyExhausted = calc.enumerateNodeResourceExhaustions(nodeInfo);
        if (!previouslyExhausted.equals(nowExhausted = calc.resourceExhaustionsFromHostInfo(nodeInfo, newHostInfo))) {
            this.context.log(logger, Level.FINE, () -> String.format("Triggering state recomputation due to change in cluster feed block: %s -> %s", previouslyExhausted, nowExhausted));
            this.stateChangeHandler.setStateChangedFlag();
        }
    }

    @Override
    public void handleNewNode(NodeInfo node) {
        this.verifyInControllerThread();
        this.stateChangeHandler.handleNewNode(node);
    }

    @Override
    public void handleMissingNode(NodeInfo node) {
        this.verifyInControllerThread();
        this.stateChangeHandler.handleMissingNode(this.stateVersionTracker.getVersionedClusterState(), node, this);
    }

    @Override
    public void handleNewRpcAddress(NodeInfo node) {
        this.verifyInControllerThread();
        this.stateChangeHandler.handleNewRpcAddress(node);
    }

    @Override
    public void handleReturnedRpcAddress(NodeInfo node) {
        this.verifyInControllerThread();
        this.stateChangeHandler.handleReturnedRpcAddress(node);
    }

    @Override
    public void handleNewPublishedState(ClusterStateBundle stateBundle) {
        this.verifyInControllerThread();
        ClusterState baselineState = stateBundle.getBaselineClusterState();
        this.newStates.add(stateBundle);
        this.metricUpdater.updateClusterStateMetrics(this.cluster, baselineState, ResourceUsageStats.calculateFrom(this.cluster.getNodeInfos(), this.options.clusterFeedBlockLimit(), stateBundle.getFeedBlock()));
        this.lastMetricUpdateCycleCount = this.cycleCount;
        this.systemStateBroadcaster.handleNewClusterStates(stateBundle);
        if (this.isMaster) {
            this.storeClusterStateMetaDataToZooKeeper(stateBundle);
        }
    }

    public EventLog getEventLog() {
        return this.eventLog;
    }

    private boolean maybePublishOldMetrics() {
        this.verifyInControllerThread();
        if (this.isMaster() && this.cycleCount > 300L + this.lastMetricUpdateCycleCount) {
            ClusterStateBundle stateBundle = this.stateVersionTracker.getVersionedClusterStateBundle();
            ClusterState baselineState = stateBundle.getBaselineClusterState();
            this.metricUpdater.updateClusterStateMetrics(this.cluster, baselineState, ResourceUsageStats.calculateFrom(this.cluster.getNodeInfos(), this.options.clusterFeedBlockLimit(), stateBundle.getFeedBlock()));
            this.lastMetricUpdateCycleCount = this.cycleCount;
            return true;
        }
        return false;
    }

    private void storeClusterStateMetaDataToZooKeeper(ClusterStateBundle stateBundle) {
        this.database.saveLatestSystemStateVersion(this.databaseContext, stateBundle.getVersion());
        this.database.saveLatestClusterStateBundle(this.databaseContext, stateBundle);
    }

    public void handleFleetData(Map<Integer, Integer> data) {
        this.verifyInControllerThread();
        this.context.log(logger, Level.FINEST, "Sending fleet data event on to master election handler");
        this.metricUpdater.updateMasterElectionMetrics(data);
        this.masterElectionHandler.handleFleetData(data);
    }

    public void lostDatabaseConnection() {
        this.verifyInControllerThread();
        boolean wasMaster = this.isMaster;
        this.masterElectionHandler.lostDatabaseConnection();
        if (wasMaster) {
            this.dropLeadershipState();
            this.metricUpdater.updateMasterState(false);
        }
    }

    private void failAllVersionDependentTasks() {
        this.tasksPendingStateRecompute.forEach(task -> {
            task.handleFailure(RemoteClusterControllerTask.Failure.of(RemoteClusterControllerTask.FailureCondition.LEADERSHIP_LOST));
            task.notifyCompleted();
        });
        this.tasksPendingStateRecompute.clear();
        this.taskCompletionQueue.forEach(task -> {
            task.getTask().handleFailure(RemoteClusterControllerTask.Failure.of(RemoteClusterControllerTask.FailureCondition.LEADERSHIP_LOST));
            task.getTask().notifyCompleted();
        });
        this.taskCompletionQueue.clear();
    }

    public void handleAllDistributorsInSync(DatabaseHandler database, DatabaseHandler.DatabaseContext dbContext) {
        HashSet<ConfiguredNode> nodes = new HashSet<ConfiguredNode>(this.cluster.clusterInfo().getConfiguredNodes().values());
        ClusterStateBundle currentBundle = this.stateVersionTracker.getVersionedClusterStateBundle();
        this.context.log(logger, Level.FINE, () -> String.format("All distributors have ACKed cluster state version %d", currentBundle.getVersion()));
        this.stateChangeHandler.handleAllDistributorsInSync(currentBundle.getBaselineClusterState(), nodes, database, dbContext);
        this.convergedStates.add(currentBundle);
    }

    private boolean changesConfiguredNodeSet(Collection<ConfiguredNode> newNodes) {
        if (newNodes.size() != this.cluster.getConfiguredNodes().size()) {
            return true;
        }
        if (!this.cluster.getConfiguredNodes().values().containsAll(newNodes)) {
            return true;
        }
        for (ConfiguredNode node : newNodes) {
            if (node.retired() == this.cluster.getConfiguredNodes().get(node.index()).retired()) continue;
            return true;
        }
        return false;
    }

    private void propagateOptions() {
        this.verifyInControllerThread();
        this.selfTerminateIfConfiguredNodeIndexHasChanged();
        if (this.changesConfiguredNodeSet(this.options.nodes())) {
            this.cluster.setSlobrokGenerationCount(0);
        }
        this.stateVersionTracker.setMinMergeCompletionRatio(this.options.minMergeCompletionRatio());
        this.communicator.propagateOptions(this.options);
        this.indexPageRequestHandler.propagateOptions(this.options);
        if (this.nodeLookup instanceof SlobrokClient) {
            ((SlobrokClient)this.nodeLookup).setSlobrokConnectionSpecs(this.options.slobrokConnectionSpecs());
        }
        this.eventLog.setMaxSize(this.options.eventLogMaxSize(), this.options.eventNodeLogMaxSize());
        this.cluster.setDistribution(this.options.storageDistribution());
        this.cluster.setNodes(this.options.nodes(), this.databaseContext.getNodeStateUpdateListener());
        this.database.setZooKeeperAddress(this.options.zooKeeperServerAddress(), this.databaseContext);
        this.database.setZooKeeperSessionTimeout(this.options.zooKeeperSessionTimeout(), this.databaseContext);
        this.stateGatherer.setMaxSlobrokDisconnectGracePeriod(this.options.maxSlobrokDisconnectGracePeriod());
        this.stateGatherer.setNodeStateRequestTimeout(this.options.nodeStateRequestTimeoutMS());
        this.stateChangeHandler.reconfigureFromOptions(this.options);
        this.masterElectionHandler.setFleetControllerCount(this.options.fleetControllerCount());
        this.masterElectionHandler.setMasterZooKeeperCooldownPeriod(this.options.masterZooKeeperCooldownPeriod());
        if (this.rpcServer != null) {
            this.rpcServer.setMasterElectionHandler(this.masterElectionHandler);
            this.rpcServer.setSlobrokConnectionSpecs(this.options.slobrokConnectionSpecs(), this.options.rpcPort());
        }
        long currentTime = this.timer.getCurrentTimeInMillis();
        this.nextStateSendTime = Math.min(currentTime + (long)this.options.minTimeBetweenNewSystemStates(), this.nextStateSendTime);
    }

    private void selfTerminateIfConfiguredNodeIndexHasChanged() {
        FleetControllerId newId = new FleetControllerId(this.options.clusterName(), this.options.fleetControllerIndex());
        if (!newId.equals(this.context.id())) {
            this.context.log(logger, Level.WARNING, this.context.id() + " got new configuration for " + newId + ". We do not support doing this live; immediately exiting now to force new configuration");
            this.prepareShutdownEdge();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() throws Exception {
        Object object = this.monitor;
        synchronized (object) {
            boolean didWork = this.metricUpdater.forWork("doNextZooKeeperTask", () -> this.database.doNextZooKeeperTask(this.databaseContext));
            didWork |= this.metricUpdater.forWork("updateMasterElectionState", this::updateMasterElectionState);
            didWork |= this.metricUpdater.forWork("handleLeadershipEdgeTransitions", this::handleLeadershipEdgeTransitions);
            this.stateChangeHandler.setMaster(this.isMaster);
            if (!this.isRunning()) {
                return;
            }
            didWork |= this.metricUpdater.forWork("stateGatherer-processResponses", () -> this.stateGatherer.processResponses(this));
            if (!this.isRunning()) {
                return;
            }
            if (this.masterElectionHandler.isFirstInLine()) {
                didWork |= this.resyncLocallyCachedState();
            } else {
                this.stepDownAsStateGatherer();
            }
            if (!this.isRunning()) {
                return;
            }
            didWork |= this.metricUpdater.forWork("systemStateBroadcaster-processResponses", this.systemStateBroadcaster::processResponses);
            if (!this.isRunning()) {
                return;
            }
            if (this.isMaster) {
                didWork |= this.metricUpdater.forWork("broadcastClusterStateToEligibleNodes", this::broadcastClusterStateToEligibleNodes);
                this.systemStateBroadcaster.checkIfClusterStateIsAckedByAllDistributors(this.database, this.databaseContext, this);
            }
            if (!this.isRunning()) {
                return;
            }
            didWork |= this.metricUpdater.forWork("processAnyPendingStatusPageRequest", this::processAnyPendingStatusPageRequest);
            if (!this.isRunning()) {
                return;
            }
            if (this.rpcServer != null) {
                didWork |= this.metricUpdater.forWork("handleRpcRequests", () -> this.rpcServer.handleRpcRequests(this.cluster, this.consolidatedClusterState(), this));
            }
            if (!this.isRunning()) {
                return;
            }
            didWork |= this.metricUpdater.forWork("processNextQueuedRemoteTask", this::processNextQueuedRemoteTask);
            didWork |= this.metricUpdater.forWork("completeSatisfiedVersionDependentTasks", this::completeSatisfiedVersionDependentTasks);
            didWork |= this.metricUpdater.forWork("maybePublishOldMetrics", this::maybePublishOldMetrics);
            this.updateClusterSyncMetrics();
            this.processingCycle = false;
            ++this.cycleCount;
            long tickStopTime = this.timer.getCurrentTimeInMillis();
            if (tickStopTime >= this.tickStartTime) {
                this.metricUpdater.addTickTime(tickStopTime - this.tickStartTime, didWork);
            }
            this.monitor.wait(didWork || this.waitingForCycle ? 1L : (long)this.options.cycleWaitTime());
            if (!this.isRunning()) {
                return;
            }
            this.tickStartTime = this.timer.getCurrentTimeInMillis();
            this.processingCycle = true;
            if (this.nextOptions != null) {
                this.switchToNewConfig();
            }
        }
        if (this.isRunning()) {
            this.propagateNewStatesToListeners();
        }
    }

    private void updateClusterSyncMetrics() {
        AggregatedClusterStats stats = this.stateVersionTracker.getAggregatedClusterStats().getAggregatedStats();
        if (stats.hasUpdatesFromAllDistributors()) {
            GlobalBucketSyncStatsCalculator.clusterBucketsOutOfSyncRatio(stats.getGlobalStats()).ifPresent(this.metricUpdater::updateClusterBucketsOutOfSyncRatio);
        }
    }

    private boolean updateMasterElectionState() {
        try {
            return this.masterElectionHandler.watchMasterElection(this.database, this.databaseContext);
        }
        catch (Exception e) {
            this.context.log(logger, Level.WARNING, "Failed to watch master election: " + e);
            return false;
        }
    }

    private void stepDownAsStateGatherer() {
        if (this.isStateGatherer) {
            this.cluster.clearStates();
            this.eventLog.add(new ClusterEvent(ClusterEvent.Type.MASTER_ELECTION, "This node is no longer a node state gatherer.", this.timer.getCurrentTimeInMillis()));
        }
        this.isStateGatherer = false;
    }

    private void switchToNewConfig() {
        this.options = this.nextOptions;
        this.nextOptions = null;
        try {
            this.propagateOptions();
        }
        catch (Exception e) {
            this.context.log(logger, Level.SEVERE, "Failed to handle new fleet controller config", e);
        }
    }

    private boolean processAnyPendingStatusPageRequest() {
        StatusPageServer.HttpRequest statusRequest = this.statusPageServer.getCurrentHttpRequest();
        if (statusRequest != null) {
            this.verifyInControllerThread();
            this.statusPageServer.fetchStatusPage(statusRequest, this.statusRequestRouter, this.timer);
            return true;
        }
        return false;
    }

    private boolean broadcastClusterStateToEligibleNodes() {
        if (this.database.hasPendingClusterStateMetaDataStore()) {
            this.context.log(logger, Level.FINE, "Can't publish current cluster state as it has one or more pending ZooKeeper stores");
            return false;
        }
        boolean sentAny = false;
        long currentTime = this.timer.getCurrentTimeInMillis();
        if ((currentTime >= this.firstAllowedStateBroadcast || this.cluster.allStatesReported()) && currentTime >= this.nextStateSendTime) {
            if (this.inMasterMoratorium) {
                this.context.log(logger, Level.INFO, currentTime < this.firstAllowedStateBroadcast ? "Master moratorium complete: all nodes have reported in" : "Master moratorium complete: timed out waiting for all nodes to report in");
                this.firstAllowedStateBroadcast = currentTime;
                this.inMasterMoratorium = false;
            }
            if (sentAny = this.systemStateBroadcaster.broadcastNewStateBundleIfRequired(this.databaseContext, this.communicator, this.database.getLastKnownStateBundleVersionWrittenBySelf())) {
                this.nextStateSendTime = currentTime + (long)this.options.minTimeBetweenNewSystemStates();
            }
        }
        return sentAny |= this.systemStateBroadcaster.broadcastStateActivationsIfRequired(this.databaseContext, this.communicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propagateNewStatesToListeners() {
        List<SystemStateListener> list;
        if (!this.newStates.isEmpty()) {
            list = this.systemStateListeners;
            synchronized (list) {
                for (ClusterStateBundle stateBundle : this.newStates) {
                    for (SystemStateListener listener : this.systemStateListeners) {
                        listener.handleNewPublishedState(stateBundle);
                    }
                }
                this.newStates.clear();
            }
        }
        if (!this.convergedStates.isEmpty()) {
            list = this.systemStateListeners;
            synchronized (list) {
                for (ClusterStateBundle stateBundle : this.convergedStates) {
                    for (SystemStateListener listener : this.systemStateListeners) {
                        listener.handleStateConvergedInCluster(stateBundle);
                    }
                }
                this.convergedStates.clear();
            }
        }
    }

    private boolean processNextQueuedRemoteTask() {
        this.metricUpdater.updateRemoteTaskQueueSize(this.remoteTasks.size());
        RemoteClusterControllerTask task = this.remoteTasks.poll();
        if (task == null) {
            return false;
        }
        RemoteClusterControllerTask.Context taskContext = this.createRemoteTaskProcessingContext();
        this.context.log(logger, Level.FINEST, () -> String.format("Processing remote task of type '%s'", task.getClass().getName()));
        task.doRemoteFleetControllerTask(taskContext);
        if (this.taskMayBeCompletedImmediately(task)) {
            this.context.log(logger, Level.FINEST, () -> String.format("Done processing remote task of type '%s'", task.getClass().getName()));
            task.notifyCompleted();
        } else {
            this.context.log(logger, Level.FINEST, () -> String.format("Remote task of type '%s' queued until state recomputation", task.getClass().getName()));
            this.tasksPendingStateRecompute.add(task);
        }
        return true;
    }

    private boolean taskMayBeCompletedImmediately(RemoteClusterControllerTask task) {
        return !task.hasVersionAckDependency() || task.isFailed() || !this.isMaster;
    }

    private RemoteClusterControllerTask.Context createRemoteTaskProcessingContext() {
        RemoteClusterControllerTask.Context context = new RemoteClusterControllerTask.Context();
        context.cluster = this.cluster;
        context.currentConsolidatedState = this.consolidatedClusterState();
        context.publishedClusterStateBundle = this.stateVersionTracker.getVersionedClusterStateBundle();
        context.aggregatedClusterStats = this.stateVersionTracker.getAggregatedClusterStats().getAggregatedStats();
        context.masterInfo = new MasterInterface(){

            @Override
            public boolean isMaster() {
                return FleetController.this.isMaster;
            }

            @Override
            public Integer getMaster() {
                return FleetController.this.masterElectionHandler.getMaster();
            }

            @Override
            public boolean inMasterMoratorium() {
                return FleetController.this.inMasterMoratorium;
            }
        };
        context.nodeListener = this;
        context.slobrokListener = this;
        return context;
    }

    private static long effectiveActivatedStateVersion(NodeInfo nodeInfo, ClusterStateBundle bundle) {
        return bundle.deferredActivation() ? (long)nodeInfo.getClusterStateVersionActivationAcked() : (long)nodeInfo.getClusterStateVersionBundleAcknowledged();
    }

    private List<Node> enumerateNodesNotYetAckedAtLeastVersion(long version) {
        ClusterStateBundle bundle = this.systemStateBroadcaster.getClusterStateBundle();
        if (bundle == null) {
            return List.of();
        }
        return this.cluster.getNodeInfos().stream().filter(n -> FleetController.effectiveActivatedStateVersion(n, bundle) < version).map(NodeInfo::getNode).toList();
    }

    private static <E> String stringifyListWithLimits(List<E> list, int limit) {
        if (list.size() > limit) {
            List<E> sub = list.subList(0, limit);
            return String.format("%s (... and %d more)", sub.stream().map(Object::toString).collect(Collectors.joining(", ")), list.size() - limit);
        }
        return list.stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    private String buildNodesNotYetConvergedMessage(long taskConvergeVersion) {
        List<Node> nodes = this.enumerateNodesNotYetAckedAtLeastVersion(taskConvergeVersion);
        if (nodes.isEmpty()) {
            return "";
        }
        return String.format("the following nodes have not converged to at least version %d: %s", taskConvergeVersion, FleetController.stringifyListWithLimits(nodes, this.options.maxDivergentNodesPrintedInTaskErrorMessages()));
    }

    private boolean completeSatisfiedVersionDependentTasks() {
        int publishedVersion = this.systemStateBroadcaster.lastClusterStateVersionInSync();
        long queueSizeBefore = this.taskCompletionQueue.size();
        long now = this.timer.getCurrentTimeInMillis();
        while (!this.taskCompletionQueue.isEmpty()) {
            VersionDependentTaskCompletion taskCompletion = this.taskCompletionQueue.peek();
            if ((long)publishedVersion >= taskCompletion.getMinimumVersion()) {
                this.context.log(logger, Level.FINE, () -> String.format("Deferred task of type '%s' has minimum version %d, published is %d; completing", taskCompletion.getTask().getClass().getName(), taskCompletion.getMinimumVersion(), publishedVersion));
                taskCompletion.getTask().notifyCompleted();
                this.taskCompletionQueue.remove();
                continue;
            }
            if (taskCompletion.getDeadlineTimePointMs() > now) break;
            String details = this.buildNodesNotYetConvergedMessage(taskCompletion.getMinimumVersion());
            this.context.log(logger, Level.WARNING, () -> String.format("Deferred task of type '%s' has exceeded wait deadline; completing with failure (details: %s)", taskCompletion.getTask().getClass().getName(), details));
            taskCompletion.getTask().handleFailure(RemoteClusterControllerTask.Failure.of(RemoteClusterControllerTask.FailureCondition.DEADLINE_EXCEEDED, details));
            taskCompletion.getTask().notifyCompleted();
            this.taskCompletionQueue.remove();
        }
        return (long)this.taskCompletionQueue.size() != queueSizeBefore;
    }

    ClusterState consolidatedClusterState() {
        ClusterState publishedState = this.stateVersionTracker.getVersionedClusterState();
        if (publishedState.getClusterState() == State.UP) {
            return publishedState;
        }
        ClusterState current = this.stateVersionTracker.getLatestCandidateState().getClusterState().clone();
        current.setVersion(publishedState.getVersion());
        return current;
    }

    private boolean resyncLocallyCachedState() {
        boolean didWork = false;
        if (!this.isMaster && this.cycleCount % 100L == 0L) {
            didWork = this.metricUpdater.forWork("loadWantedStates", () -> this.database.loadWantedStates(this.databaseContext));
            didWork |= this.metricUpdater.forWork("loadStartTimestamps", () -> this.database.loadStartTimestamps(this.cluster));
        }
        didWork |= this.metricUpdater.forWork("updateCluster", () -> this.nodeLookup.updateCluster(this.cluster, this));
        didWork |= this.metricUpdater.forWork("sendMessages", () -> this.stateGatherer.sendMessages(this.cluster, this.communicator, this));
        didWork |= this.metricUpdater.forWork("watchTimers", () -> this.stateChangeHandler.watchTimers(this.cluster, this.stateVersionTracker.getLatestCandidateState().getClusterState(), this));
        didWork |= this.metricUpdater.forWork("recomputeClusterStateIfRequired", this::recomputeClusterStateIfRequired);
        if (!this.isStateGatherer && !this.isMaster) {
            this.eventLog.add(new ClusterEvent(ClusterEvent.Type.MASTER_ELECTION, "This node just became node state gatherer as we are fleetcontroller master candidate.", this.timer.getCurrentTimeInMillis()));
            this.stateVersionTracker.setVersionRetrievedFromZooKeeper(this.database.getLatestSystemStateVersion());
            this.stateChangeHandler.setStateChangedFlag();
        }
        this.isStateGatherer = true;
        return didWork;
    }

    private void invokeCandidateStateListeners(ClusterStateBundle candidateBundle) {
        this.systemStateListeners.forEach(listener -> listener.handleNewCandidateState(candidateBundle));
    }

    private boolean hasPassedFirstStateBroadcastTimePoint(long timeNowMs) {
        return timeNowMs >= this.firstAllowedStateBroadcast || this.cluster.allStatesReported();
    }

    private boolean recomputeClusterStateIfRequired() {
        boolean stateWasChanged = false;
        if (this.mustRecomputeCandidateClusterState()) {
            this.stateChangeHandler.unsetStateChangedFlag();
            AnnotatedClusterState candidate = this.computeCurrentAnnotatedState();
            ClusterStateBundle candidateBundle = ClusterStateBundle.builder(candidate).bucketSpaces(this.configuredBucketSpaces).stateDeriver(this.createBucketSpaceStateDeriver()).deferredActivation(this.options.enableTwoPhaseClusterStateActivation()).feedBlock(this.createResourceExhaustionCalculator().inferContentClusterFeedBlockOrNull(this.cluster)).deriveAndBuild();
            this.stateVersionTracker.updateLatestCandidateStateBundle(candidateBundle);
            this.invokeCandidateStateListeners(candidateBundle);
            long timeNowMs = this.timer.getCurrentTimeInMillis();
            if (this.hasPassedFirstStateBroadcastTimePoint(timeNowMs) && (this.stateVersionTracker.candidateChangedEnoughFromCurrentToWarrantPublish() || this.stateVersionTracker.hasReceivedNewVersionFromZooKeeper())) {
                ClusterStateBundle before = this.stateVersionTracker.getVersionedClusterStateBundle();
                this.stateVersionTracker.promoteCandidateToVersionedState(timeNowMs);
                this.emitEventsForAlteredStateEdges(before, this.stateVersionTracker.getVersionedClusterStateBundle(), timeNowMs);
                this.handleNewPublishedState(this.stateVersionTracker.getVersionedClusterStateBundle());
                stateWasChanged = true;
            }
        }
        this.scheduleVersionDependentTasksForFutureCompletion(this.stateVersionTracker.getCurrentVersion());
        return stateWasChanged;
    }

    private ClusterStateDeriver createBucketSpaceStateDeriver() {
        if (this.options.clusterHasGlobalDocumentTypes()) {
            return new MaintenanceWhenPendingGlobalMerges(this.stateVersionTracker.createMergePendingChecker(), this.createDefaultSpaceMaintenanceTransitionConstraint());
        }
        return FleetController.createIdentityClonedBucketSpaceStateDeriver();
    }

    private ResourceExhaustionCalculator createResourceExhaustionCalculator() {
        return new ResourceExhaustionCalculator(this.options.clusterFeedBlockEnabled(), this.options.clusterFeedBlockLimit(), this.stateVersionTracker.getLatestCandidateStateBundle().getFeedBlockOrNull(), this.options.clusterFeedBlockNoiseLevel());
    }

    private static ClusterStateDeriver createIdentityClonedBucketSpaceStateDeriver() {
        return (state, space) -> state.clone();
    }

    private MaintenanceTransitionConstraint createDefaultSpaceMaintenanceTransitionConstraint() {
        AnnotatedClusterState currentDefaultSpaceState = this.stateVersionTracker.getVersionedClusterStateBundle().getDerivedBucketSpaceStates().getOrDefault(FixedBucketSpaces.defaultSpace(), AnnotatedClusterState.emptyState());
        return UpEdgeMaintenanceTransitionConstraint.forPreviouslyPublishedState(currentDefaultSpaceState.getClusterState());
    }

    private void scheduleVersionDependentTasksForFutureCompletion(int completeAtVersion) {
        long maxDeadlineTimePointMs = this.timer.getCurrentTimeInMillis() + this.options.getMaxDeferredTaskVersionWaitTime().toMillis();
        for (RemoteClusterControllerTask task : this.tasksPendingStateRecompute) {
            this.context.log(logger, Level.INFO, task + " will be completed at version " + completeAtVersion);
            this.taskCompletionQueue.add(new VersionDependentTaskCompletion(completeAtVersion, task, maxDeadlineTimePointMs));
        }
        this.tasksPendingStateRecompute.clear();
    }

    private AnnotatedClusterState computeCurrentAnnotatedState() {
        ClusterStateGenerator.Params params = ClusterStateGenerator.Params.fromOptions(this.options);
        params.currentTimeInMillis(this.timer.getCurrentTimeInMillis()).cluster(this.cluster).lowestObservedDistributionBitCount(this.stateVersionTracker.getLowestObservedDistributionBits());
        return ClusterStateGenerator.generatedStateFrom(params);
    }

    private void emitEventsForAlteredStateEdges(ClusterStateBundle fromState, ClusterStateBundle toState, long timeNowMs) {
        List<Event> deltaEvents = EventDiffCalculator.computeEventDiff(EventDiffCalculator.params().cluster(this.cluster).fromState(fromState).toState(toState).currentTimeMs(timeNowMs).maxMaintenanceGracePeriodTimeMs(this.options.storageNodeMaxTransitionTimeMs()));
        for (Event event : deltaEvents) {
            this.eventLog.add(event, this.isMaster);
        }
        this.emitStateAppliedEvents(timeNowMs, fromState.getBaselineClusterState(), toState.getBaselineClusterState());
    }

    private void emitStateAppliedEvents(long timeNowMs, ClusterState fromClusterState, ClusterState toClusterState) {
        this.eventLog.add(new ClusterEvent(ClusterEvent.Type.SYSTEMSTATE, "New cluster state version " + toClusterState.getVersion() + ". Change from last: " + fromClusterState.getTextualDifference(toClusterState), timeNowMs), this.isMaster);
        if (toClusterState.getDistributionBitCount() != fromClusterState.getDistributionBitCount()) {
            this.eventLog.add(new ClusterEvent(ClusterEvent.Type.SYSTEMSTATE, "Altering distribution bits in system from " + fromClusterState.getDistributionBitCount() + " to " + toClusterState.getDistributionBitCount(), timeNowMs), this.isMaster);
        }
    }

    private boolean atFirstClusterStateSendTimeEdge() {
        if (!this.isMaster || this.systemStateBroadcaster.hasBroadcastedClusterStateBundle()) {
            return false;
        }
        return this.hasPassedFirstStateBroadcastTimePoint(this.timer.getCurrentTimeInMillis());
    }

    private boolean mustRecomputeCandidateClusterState() {
        return this.stateChangeHandler.stateMayHaveChanged() || this.stateVersionTracker.bucketSpaceMergeCompletionStateHasChanged() || this.atFirstClusterStateSendTimeEdge();
    }

    private boolean handleLeadershipEdgeTransitions() {
        boolean didWork = false;
        if (this.masterElectionHandler.isMaster()) {
            if (!this.isMaster) {
                this.stateChangeHandler.setStateChangedFlag();
                this.systemStateBroadcaster.resetBroadcastedClusterStateBundle();
                this.stateVersionTracker.setVersionRetrievedFromZooKeeper(this.database.getLatestSystemStateVersion());
                ClusterStateBundle previousBundle = this.database.getLatestClusterStateBundle();
                this.database.loadStartTimestamps(this.cluster);
                this.database.loadWantedStates(this.databaseContext);
                this.context.log(logger, Level.INFO, () -> String.format("Loaded previous cluster state bundle from ZooKeeper: %s", previousBundle));
                this.stateVersionTracker.setClusterStateBundleRetrievedFromZooKeeper(previousBundle);
                this.eventLog.add(new ClusterEvent(ClusterEvent.Type.MASTER_ELECTION, "This node just became fleetcontroller master. Bumped version to " + this.stateVersionTracker.getCurrentVersion() + " to be in line.", this.timer.getCurrentTimeInMillis()));
                long currentTime = this.timer.getCurrentTimeInMillis();
                this.firstAllowedStateBroadcast = currentTime + this.options.minTimeBeforeFirstSystemStateBroadcast();
                this.isMaster = true;
                this.inMasterMoratorium = true;
                this.context.log(logger, Level.FINE, () -> "At time " + currentTime + " we set first system state broadcast time to be " + this.options.minTimeBeforeFirstSystemStateBroadcast() + " ms after at time " + this.firstAllowedStateBroadcast + ".");
                didWork = true;
            }
            if (this.wantedStateChanged) {
                didWork |= this.database.saveWantedStates(this.databaseContext);
                this.wantedStateChanged = false;
            }
        } else {
            this.dropLeadershipState();
        }
        this.metricUpdater.updateMasterState(this.isMaster);
        return didWork;
    }

    private void dropLeadershipState() {
        if (this.isMaster) {
            this.eventLog.add(new ClusterEvent(ClusterEvent.Type.MASTER_ELECTION, "This node is no longer fleetcontroller master.", this.timer.getCurrentTimeInMillis()));
            this.firstAllowedStateBroadcast = Long.MAX_VALUE;
            this.failAllVersionDependentTasks();
        }
        this.wantedStateChanged = false;
        this.isMaster = false;
        this.inMasterMoratorium = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.controllerThreadId = Thread.currentThread().getId();
        this.context.log(logger, Level.INFO, "Starting tick loop");
        try {
            this.processingCycle = true;
            while (this.isRunning()) {
                this.tick();
            }
            this.context.log(logger, Level.INFO, "Tick loop stopped");
        }
        catch (InterruptedException e) {
            this.context.log(logger, Level.INFO, "Event thread stopped by interrupt exception: ", e);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.context.log(logger, Level.SEVERE, "Fatal error killed fleet controller", t);
            Object object = this.monitor;
            synchronized (object) {
                this.running.set(false);
            }
            System.exit(1);
        }
        finally {
            this.prepareShutdownEdge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareShutdownEdge() {
        this.running.set(false);
        this.failAllVersionDependentTasks();
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notifyAll();
        }
    }

    /*
     * Exception decompiling
     */
    public void waitForCompleteCycle(Duration timeout) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void waitForNodesHavingSystemStateVersionEqualToOrAbove(int version, int nodeCount, Duration timeout) throws InterruptedException {
        Instant endTime = Instant.now().plus(timeout);
        Object object = this.monitor;
        synchronized (object) {
            while (true) {
                int ackedNodes = 0;
                for (NodeInfo node : this.cluster.getNodeInfos()) {
                    if (node.getClusterStateVersionBundleAcknowledged() < version) continue;
                    ++ackedNodes;
                }
                if (ackedNodes >= nodeCount) {
                    this.context.log(logger, Level.INFO, ackedNodes + " nodes now have acked system state " + version + " or higher.");
                    return;
                }
                if (Instant.now().isAfter(endTime)) {
                    throw new IllegalStateException("Did not get " + nodeCount + " nodes to system state " + version + " within timeout of " + timeout);
                }
                this.monitor.wait(10L);
            }
        }
    }

    public void waitForNodesInSlobrok(int distNodeCount, int storNodeCount, Duration timeout) throws InterruptedException {
        Instant endTime = Instant.now().plus(timeout);
        Object object = this.monitor;
        synchronized (object) {
            while (true) {
                int distCount = 0;
                int storCount = 0;
                for (NodeInfo info : this.cluster.getNodeInfos()) {
                    if (!info.isInSlobrok()) continue;
                    if (info.isDistributor()) {
                        ++distCount;
                        continue;
                    }
                    ++storCount;
                }
                if (distCount == distNodeCount && storCount == storNodeCount) {
                    return;
                }
                if (Instant.now().isAfter(endTime)) {
                    throw new IllegalStateException("Did not get all " + distNodeCount + " distributors and " + storNodeCount + " storage nodes registered in slobrok within timeout of " + timeout + ". (Got " + distCount + " distributors and " + storCount + " storage nodes)");
                }
                this.monitor.wait(10L);
            }
        }
    }

    public boolean hasZookeeperConnection() {
        return !this.database.isClosed();
    }

    public int getSlobrokMirrorUpdates() {
        return ((SlobrokClient)this.nodeLookup).getMirror().updates();
    }

    public ContentCluster getCluster() {
        return this.cluster;
    }

    public StatusHandler.ContainerStatusPageServer statusPageServer() {
        return this.statusPageServer;
    }
}

