/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.restapiv2.requests;

import com.yahoo.time.TimeBudget;
import com.yahoo.vdslib.distribution.ConfiguredNode;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vespa.clustercontroller.core.RemoteClusterControllerTask;
import com.yahoo.vespa.clustercontroller.core.restapiv2.Request;
import com.yahoo.vespa.clustercontroller.core.restapiv2.requests.SetNodeStateRequest;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.InternalFailure;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.InvalidContentException;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.StateRestApiException;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.requests.SetUnitStateRequest;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.SetResponse;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.UnitState;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;

public class SetNodeStatesForClusterRequest
extends Request<SetResponse> {
    private final Map<String, UnitState> newStates;
    private final SetUnitStateRequest.Condition condition;
    private final TimeBudget timeBudget;
    private final boolean probe;

    public SetNodeStatesForClusterRequest(SetUnitStateRequest request) {
        super(Request.MasterState.MUST_BE_MASTER);
        this.newStates = request.getNewState();
        this.condition = request.getCondition();
        this.timeBudget = request.timeBudget();
        this.probe = request.isProbe();
    }

    @Override
    public SetResponse calculateResult(RemoteClusterControllerTask.Context context) throws StateRestApiException {
        if (this.condition != SetUnitStateRequest.Condition.FORCE) {
            throw new InvalidContentException("Setting all nodes in a cluster to a state is only supported with FORCE");
        }
        for (ConfiguredNode configuredNode : context.cluster.getConfiguredNodes().values()) {
            Node node = new Node(NodeType.STORAGE, configuredNode.index());
            SetResponse setResponse = SetNodeStateRequest.setWantedState(context.cluster, this.condition, this.newStates, node, context.nodeListener, context.currentConsolidatedState, context.masterInfo.inMasterMoratorium(), this.probe);
            if (setResponse.getWasModified()) continue;
            throw new InternalFailure("We have not yet implemented the meaning of failing to set the wanted state for a subset of nodes: condition = " + this.condition + ", newStates = " + this.newStates + ", currentConsolidatedState = " + context.currentConsolidatedState);
        }
        return new SetResponse("ok", true);
    }

    @Override
    public Optional<Instant> getDeadline() {
        return this.timeBudget.deadline();
    }

    @Override
    public boolean isFailed() {
        return super.isFailed() || this.resultSet && !((SetResponse)this.result).getWasModified();
    }
}

