/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.hostinfo;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.vespa.clustercontroller.core.hostinfo.ContentNode;
import com.yahoo.vespa.clustercontroller.core.hostinfo.Distributor;
import com.yahoo.vespa.clustercontroller.core.hostinfo.Metrics;
import com.yahoo.vespa.clustercontroller.core.hostinfo.Vtag;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HostInfo {
    private static final Logger log = Logger.getLogger(HostInfo.class.getName());
    private static final ObjectMapper mapper = new ObjectMapper();
    private String rawCreationString = "NOT SET";
    @JsonProperty(value="cluster-state-version")
    private Integer clusterStateVersion = null;
    @JsonProperty(value="vtag")
    private Vtag vtag = new Vtag(null);
    @JsonProperty(value="distributor")
    private Distributor distributor = new Distributor();
    @JsonProperty(value="metrics")
    private Metrics metrics = new Metrics();
    @JsonProperty(value="content-node")
    private ContentNode contentNode = new ContentNode();

    public Vtag getVtag() {
        return this.vtag;
    }

    public Distributor getDistributor() {
        return this.distributor;
    }

    public ContentNode getContentNode() {
        return this.contentNode;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public Integer getClusterStateVersionOrNull() {
        return this.clusterStateVersion;
    }

    public static HostInfo createHostInfo(String json) {
        HostInfo hostInfo;
        try {
            hostInfo = (HostInfo)mapper.readValue(json, HostInfo.class);
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Problem parsing " + json, e);
            hostInfo = new HostInfo();
        }
        hostInfo.setRawCreationString(json);
        return hostInfo;
    }

    public String getRawCreationString() {
        return this.rawCreationString;
    }

    public void setRawCreationString(String rawCreationString) {
        this.rawCreationString = rawCreationString;
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

