/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vdslib.state.Node;
import com.yahoo.vespa.clustercontroller.core.Event;
import com.yahoo.vespa.clustercontroller.core.EventLogInterface;
import com.yahoo.vespa.clustercontroller.core.MetricUpdater;
import com.yahoo.vespa.clustercontroller.core.NodeEvent;
import com.yahoo.vespa.clustercontroller.core.RealTimer;
import com.yahoo.vespa.clustercontroller.core.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventLog
implements EventLogInterface {
    public static final Logger log = Logger.getLogger(EventLog.class.getName());
    private final Timer timer;
    private final LinkedList<Event> eventLog = new LinkedList();
    private final Map<Node, LinkedList<NodeEvent>> nodeLog = new TreeMap<Node, LinkedList<NodeEvent>>();
    private final MetricUpdater metricUpdater;
    private long eventsSeen = 0L;
    private final long startTime;
    private int maxSize = 1024;
    private int maxNodeSize = 1024;
    private final long recentTimePeriod = 604800000L;

    public EventLog(Timer timer, MetricUpdater metricUpdater) {
        this.timer = timer;
        this.startTime = timer.getCurrentTimeInMillis();
        this.metricUpdater = Objects.requireNonNull(metricUpdater, "metricUpdater must be non-null");
    }

    @Override
    public void setMaxSize(int size, int nodesize) {
        if (size < 1 || nodesize < 1) {
            throw new IllegalArgumentException("Max size must be at least 1");
        }
        this.maxSize = size;
        while (this.eventLog.size() > this.maxSize) {
            this.eventLog.remove(0);
        }
        this.maxNodeSize = nodesize;
        for (List list : this.nodeLog.values()) {
            while (list.size() > this.maxNodeSize) {
                list.remove(0);
            }
        }
    }

    @Override
    public long getRecentTimePeriod() {
        return 604800000L;
    }

    @Override
    public void add(Event e) {
        this.add(e, true);
    }

    @Override
    public void add(Event e, boolean logInfo) {
        ++this.eventsSeen;
        this.eventLog.add(e);
        if (this.eventLog.size() > this.maxSize) {
            this.eventLog.remove(0);
        }
        if (e instanceof NodeEvent) {
            this.addNodeOnlyEvent((NodeEvent)e, logInfo ? Level.INFO : Level.FINE);
        } else {
            log.log(logInfo ? Level.INFO : Level.FINE, e::toString);
        }
    }

    @Override
    public void addNodeOnlyEvent(NodeEvent e, Level level) {
        log.log(level, "Added node only event: " + e.toString());
        this.metricUpdater.recordNewNodeEvent();
        LinkedList<NodeEvent> nodeList = this.nodeLog.get(e.getNode().getNode());
        if (nodeList == null) {
            nodeList = new LinkedList();
            this.nodeLog.put(e.getNode().getNode(), nodeList);
        }
        nodeList.add(e);
        if (nodeList.size() > this.maxNodeSize) {
            nodeList.remove(0);
        }
    }

    @Override
    public int getNodeEventsSince(Node n, long time) {
        LinkedList<NodeEvent> events = this.nodeLog.get(n);
        int count = 0;
        if (events != null) {
            NodeEvent e;
            Iterator<NodeEvent> it = events.descendingIterator();
            while (it.hasNext() && (e = it.next()).getTimeMs() >= time) {
                ++count;
            }
        }
        return count;
    }

    public List<NodeEvent> getNodeEvents(Node n) {
        return new ArrayList<NodeEvent>((Collection)this.nodeLog.get(n));
    }

    @Override
    public void writeHtmlState(StringBuilder sb, Node node) {
        Iterator<Object> eventIterator;
        TimeZone tz = TimeZone.getTimeZone("UTC");
        LinkedList<Object> events = new LinkedList();
        long currentTime = this.timer.getCurrentTimeInMillis();
        long recentNodeEvents = 0L;
        if (node == null) {
            events = this.eventLog;
            sb.append("<h2 id=\"eventlog\">Event log</h2>\n").append("<p>A total number of " + this.eventsSeen + " has been seen since ").append(RealTimer.printDate(this.startTime, tz)).append(".</p>\n");
        } else {
            if (this.nodeLog.containsKey(node)) {
                events.addAll((Collection)this.nodeLog.get(node));
            }
            recentNodeEvents = this.getNodeEventsSince(node, currentTime - 604800000L);
            sb.append("<h2>Node event log for " + node + "</h2>\n").append("<p>A total number of " + events.size() + " events has been seen since ").append(RealTimer.printDate(this.startTime, tz)).append(".</p>\n").append("<p>Recently, " + recentNodeEvents + " events has been seen since ").append(RealTimer.printDate(currentTime - 604800000L, tz)).append(".</p>\n");
        }
        sb.append("<table border=\"1\" cellspacing=\"0\">\n").append("<tr><td>Date (").append(tz.getDisplayName(false, 0)).append(")</td><td>Type</td><td>Node</td><td>Bucket space</td><td>Event</td></tr>\n");
        int nr = 0;
        Iterator<Object> iterator = eventIterator = events == null ? null : events.descendingIterator();
        if (eventIterator != null) {
            while (eventIterator.hasNext()) {
                Event e = (Event)eventIterator.next();
                String colStart = "<font color=\"" + ((long)(++nr) > recentNodeEvents ? "grey" : "black") + "\">";
                String colEnd = "</font>";
                sb.append("<tr>\n");
                EventLog.addNobrTableCell(sb, colStart, colEnd, RealTimer.printDate(e.getTimeMs(), tz));
                EventLog.addNobrTableCell(sb, colStart, colEnd, e.getCategory());
                if (e instanceof NodeEvent) {
                    NodeEvent nodeEvent = (NodeEvent)e;
                    EventLog.addNobrTableCell(sb, colStart, colEnd, nodeEvent.getNode().toString());
                    EventLog.addNobrTableCell(sb, colStart, colEnd, nodeEvent.getBucketSpace().orElse(" - "));
                } else {
                    EventLog.addNobrTableCell(sb, colStart, colEnd, " - ");
                    EventLog.addNobrTableCell(sb, colStart, colEnd, " - ");
                }
                EventLog.addTableCell(sb, colStart, colEnd, e.getDescription());
                sb.append("</tr>\n");
            }
        }
        sb.append("</table>\n");
    }

    private static void addNobrTableCell(StringBuilder sb, String colStart, String colEnd, String cellValue) {
        sb.append("  <td><nobr>").append(colStart).append(cellValue).append(colEnd).append("</nobr></td>\n");
    }

    private static void addTableCell(StringBuilder sb, String colStart, String colEnd, String cellValue) {
        sb.append("  <td>").append(colStart).append(cellValue).append(colEnd).append("</td>\n");
    }
}

