/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vdslib.distribution.ConfiguredNode;
import com.yahoo.vdslib.distribution.Distribution;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.ClusterInfo;
import com.yahoo.vespa.clustercontroller.core.FleetControllerOptions;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.NodeStateChangeChecker;
import com.yahoo.vespa.clustercontroller.core.listeners.NodeListener;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.requests.SetUnitStateRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class ContentCluster {
    private static final int pollingFrequency = 5000;
    private final String clusterName;
    private final ClusterInfo clusterInfo = new ClusterInfo();
    private final Map<Node, Long> nodeStartTimestamps = new TreeMap<Node, Long>();
    private int slobrokGenerationCount = 0;
    private Distribution distribution;
    private final int maxNumberOfGroupsAllowedToBeDown;

    public ContentCluster(String clusterName, Collection<ConfiguredNode> configuredNodes, Distribution distribution) {
        this(clusterName, configuredNodes, distribution, 1);
    }

    public ContentCluster(FleetControllerOptions options) {
        this(options.clusterName(), options.nodes(), options.storageDistribution(), options.maxNumberOfGroupsAllowedToBeDown());
    }

    ContentCluster(String clusterName, Collection<ConfiguredNode> configuredNodes, Distribution distribution, int maxNumberOfGroupsAllowedToBeDown) {
        if (configuredNodes == null) {
            throw new IllegalArgumentException("Nodes must be set");
        }
        this.clusterName = clusterName;
        this.distribution = distribution;
        this.setNodes(configuredNodes, new NodeListener(){});
        this.maxNumberOfGroupsAllowedToBeDown = maxNumberOfGroupsAllowedToBeDown;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public void setDistribution(Distribution distribution) {
        this.distribution = distribution;
        for (NodeInfo info : this.clusterInfo.getAllNodeInfos()) {
            info.setGroup(distribution);
        }
    }

    public final void setNodes(Collection<ConfiguredNode> configuredNodes, NodeListener nodeListener) {
        this.clusterInfo.setNodes(configuredNodes, this, this.distribution, nodeListener);
    }

    public void setStartTimestamp(Node n, long startTimestamp) {
        this.nodeStartTimestamps.put(n, startTimestamp);
    }

    public long getStartTimestamp(Node n) {
        Long value = this.nodeStartTimestamps.get(n);
        return value == null ? 0L : value;
    }

    public Map<Node, Long> getStartTimestamps() {
        return this.nodeStartTimestamps;
    }

    public void clearStates() {
        for (NodeInfo info : this.clusterInfo.getAllNodeInfos()) {
            info.setReportedState(null, 0L);
        }
    }

    public boolean allStatesReported() {
        return this.clusterInfo.allStatesReported();
    }

    public int getPollingFrequency() {
        return 5000;
    }

    public Map<Integer, ConfiguredNode> getConfiguredNodes() {
        return this.clusterInfo.getConfiguredNodes();
    }

    public Collection<NodeInfo> getNodeInfos() {
        return Collections.unmodifiableCollection(this.clusterInfo.getAllNodeInfos());
    }

    public ClusterInfo clusterInfo() {
        return this.clusterInfo;
    }

    public String getName() {
        return this.clusterName;
    }

    public NodeInfo getNodeInfo(Node node) {
        return this.clusterInfo.getNodeInfo(node);
    }

    public int maxNumberOfGroupsAllowedToBeDown() {
        return this.maxNumberOfGroupsAllowedToBeDown;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ContentCluster(").append(this.clusterName).append(") {");
        for (NodeInfo node : this.clusterInfo.getAllNodeInfos()) {
            sb.append("\n  ").append(node);
        }
        sb.append("\n}");
        return sb.toString();
    }

    public int getSlobrokGenerationCount() {
        return this.slobrokGenerationCount;
    }

    public void setSlobrokGenerationCount(int count) {
        this.slobrokGenerationCount = count;
    }

    public NodeStateChangeChecker.Result calculateEffectOfNewState(Node node, ClusterState clusterState, SetUnitStateRequest.Condition condition, NodeState oldState, NodeState newState, boolean inMoratorium) {
        NodeStateChangeChecker nodeStateChangeChecker = new NodeStateChangeChecker(this, inMoratorium);
        return nodeStateChangeChecker.evaluateTransition(node, clusterState, condition, oldState, newState);
    }

    public List<Integer> nodesSafelySetTo(State state) {
        return switch (state) {
            case State.MAINTENANCE, State.DOWN -> this.clusterInfo.getStorageNodeInfos().stream().filter(storageNodeInfo -> {
                NodeState userWantedState = storageNodeInfo.getUserWantedState();
                return userWantedState.getState() == state && Objects.equals(userWantedState.getDescription(), "Orchestrator");
            }).map(NodeInfo::getNodeIndex).toList();
            default -> List.of();
        };
    }

    public boolean hasConfiguredNode(int index) {
        return this.clusterInfo.hasConfiguredNode(index);
    }
}

