/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.hostinfo;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Metrics {
    @JsonProperty(value="values")
    private ArrayList<Metric> metricsList = new ArrayList();

    public Optional<Value> getValue(String name) {
        for (Metric metric : this.metricsList) {
            if (!name.equals(metric.getName())) continue;
            return Optional.ofNullable(metric.getValue());
        }
        return Optional.empty();
    }

    public Optional<Value> getValueAt(String name, Map<String, String> dimensions) {
        return this.metricsList.stream().filter(metric -> metric.name.equals(name)).filter(metric -> dimensions.entrySet().stream().allMatch(entry -> {
            String dimensionName = (String)entry.getKey();
            Optional<String> requiredDimensionValue = Optional.ofNullable((String)entry.getValue());
            return metric.getDimensionValue(dimensionName).equals(requiredDimensionValue);
        })).map(Metric::getValue).findFirst();
    }

    public List<Metric> getMetrics() {
        return Collections.unmodifiableList(this.metricsList);
    }

    public static class Metric {
        private final String name;
        private final Value value;
        private final Map<String, String> dimensions;

        public Metric(@JsonProperty(value="name") String name, @JsonProperty(value="values") Value value, @JsonProperty(value="dimensions") Map<String, String> dimensions) {
            this.name = name;
            this.value = value;
            this.dimensions = dimensions;
        }

        public String getName() {
            return this.name;
        }

        public Value getValue() {
            return this.value;
        }

        public Optional<String> getDimensionValue(String dimension) {
            return Optional.ofNullable(this.dimensions.get(dimension));
        }
    }

    public static class Value {
        private final Long last;
        private final Double average;
        private final Long count;

        public Value(@JsonProperty(value="average") Double average, @JsonProperty(value="count") Long count, @JsonProperty(value="rate") Double rate, @JsonProperty(value="min") Long min, @JsonProperty(value="max") Long max, @JsonProperty(value="last") Long last) {
            this.last = last;
            this.average = average;
            this.count = count;
        }

        public Long getLast() {
            return this.last;
        }

        public Double getAverage() {
            return this.average;
        }

        public Long getCount() {
            return this.count;
        }
    }
}

