/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vespa.clustercontroller.core.FleetControllerContext;
import com.yahoo.vespa.clustercontroller.core.MasterInterface;
import com.yahoo.vespa.clustercontroller.core.Timer;
import com.yahoo.vespa.clustercontroller.core.database.DatabaseHandler;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MasterElectionHandler
implements MasterInterface {
    private static final Logger logger = Logger.getLogger(MasterElectionHandler.class.getName());
    private final FleetControllerContext context;
    private final Object monitor;
    private final Timer timer;
    private final int index;
    private int totalCount;
    private Integer masterCandidate;
    private int nextInLineCount;
    private int followers;
    private Map<Integer, Integer> masterData;
    private Map<Integer, Integer> nextMasterData;
    private long masterGoneFromZooKeeperTime;
    private long masterZooKeeperCooldownPeriod;
    private boolean usingZooKeeper = false;

    public MasterElectionHandler(FleetControllerContext context, int index, int totalCount, Object monitor, Timer timer) {
        this.context = context;
        this.monitor = monitor;
        this.timer = timer;
        this.index = index;
        this.totalCount = totalCount;
        this.nextInLineCount = Integer.MAX_VALUE;
        if (this.cannotBecomeMaster()) {
            context.log(logger, Level.FINE, () -> "We can never become master and will always stay a follower.");
        }
        this.masterGoneFromZooKeeperTime = timer.getCurrentTimeInMillis();
    }

    public void setFleetControllerCount(int count) {
        this.totalCount = count;
        if (count == 1 && !this.usingZooKeeper) {
            this.masterCandidate = 0;
            this.followers = 1;
            this.nextInLineCount = 0;
        }
    }

    public void setMasterZooKeeperCooldownPeriod(int period) {
        this.masterZooKeeperCooldownPeriod = period;
    }

    public void setUsingZooKeeper(boolean usingZK) {
        if (!this.usingZooKeeper && usingZK) {
            this.resetElectionProgress();
        }
        this.usingZooKeeper = usingZK;
    }

    @Override
    public boolean isMaster() {
        Integer master = this.getMaster();
        return master != null && master == this.index;
    }

    @Override
    public boolean inMasterMoratorium() {
        return false;
    }

    @Override
    public Integer getMaster() {
        if (this.tooFewFollowersToHaveAMaster()) {
            return null;
        }
        if (this.followers == this.totalCount) {
            return this.masterCandidate;
        }
        if (this.masterGoneFromZooKeeperTime + this.masterZooKeeperCooldownPeriod > this.timer.getCurrentTimeInMillis()) {
            return null;
        }
        return this.masterCandidate;
    }

    public String getMasterReason() {
        if (this.masterCandidate == null) {
            return "There is currently no master candidate.";
        }
        if (this.tooFewFollowersToHaveAMaster()) {
            return "More than half of the nodes must agree for there to be a master. Only " + this.followers + " of " + this.totalCount + " nodes agree on current master candidate (" + this.masterCandidate + ").";
        }
        if (this.followers == this.totalCount) {
            return "All " + this.totalCount + " nodes agree that " + this.masterCandidate + " is current master.";
        }
        if (this.masterGoneFromZooKeeperTime + this.masterZooKeeperCooldownPeriod > this.timer.getCurrentTimeInMillis()) {
            return this.followers + " of " + this.totalCount + " nodes agree " + this.masterCandidate + " should be master, but old master cooldown period of " + this.masterZooKeeperCooldownPeriod + " ms has not passed yet. To ensure it has got time to realize it is no longer master before we elect a new one, currently there is no master.";
        }
        return this.followers + " of " + this.totalCount + " nodes agree " + this.masterCandidate + " is master.";
    }

    private boolean tooFewFollowersToHaveAMaster() {
        return 2 * this.followers <= this.totalCount;
    }

    public boolean isAmongNthFirst(int first) {
        return this.nextInLineCount < first;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean watchMasterElection(DatabaseHandler database, DatabaseHandler.DatabaseContext dbContext) throws InterruptedException {
        Map<Integer, Integer> state;
        if (this.totalCount == 1 && !this.usingZooKeeper) {
            return false;
        }
        if (this.nextMasterData == null) {
            if (this.masterCandidate == null) {
                this.context.log(logger, Level.FINEST, () -> "No current master candidate. Waiting for data to do master election.");
            }
            return false;
        }
        this.context.log(logger, Level.INFO, "Handling new master election, as we have received " + this.nextMasterData.size() + " entries");
        Object object = this.monitor;
        synchronized (object) {
            state = this.nextMasterData;
            this.nextMasterData = null;
        }
        this.context.log(logger, Level.INFO, "Got master election state " + MasterElectionHandler.toString(state) + ".");
        if (state.isEmpty()) {
            throw new IllegalStateException("Database has no master data. We should at least have data for ourselves.");
        }
        Map.Entry<Integer, Integer> first = state.entrySet().iterator().next();
        Integer currentMaster = this.getMaster();
        if (currentMaster != null && first.getKey().intValue() != currentMaster.intValue()) {
            this.context.log(logger, Level.INFO, "Master gone from ZooKeeper. Tagging timestamp. Will wait " + this.masterZooKeeperCooldownPeriod + " ms.");
            this.masterGoneFromZooKeeperTime = this.timer.getCurrentTimeInMillis();
            this.masterCandidate = null;
        }
        if (first.getValue().intValue() != first.getKey().intValue()) {
            this.context.log(logger, Level.INFO, "First index is not currently trying to become master. Waiting for it to change state");
            this.masterCandidate = null;
            if (first.getKey() == this.index) {
                this.context.log(logger, Level.INFO, "We are next in line to become master. Altering our state to look for followers");
                database.setMasterVote(dbContext, this.index);
            }
        } else {
            this.masterCandidate = first.getValue();
            this.followers = 0;
            for (Map.Entry<Integer, Integer> current : state.entrySet()) {
                if (current.getValue().intValue() != first.getKey().intValue()) continue;
                ++this.followers;
            }
            if (2 * this.followers > this.totalCount) {
                Integer newMaster = this.getMaster();
                if (newMaster != null && currentMaster != null && newMaster.intValue() == currentMaster.intValue()) {
                    this.context.log(logger, Level.INFO, currentMaster + " is still the master");
                } else if (newMaster != null && currentMaster != null) {
                    this.context.log(logger, Level.INFO, newMaster + " took over for fleet controller " + currentMaster + " as master");
                } else if (newMaster == null) {
                    this.context.log(logger, Level.INFO, this.masterCandidate + " is new master candidate, but needs to wait before it can take over");
                } else {
                    this.context.log(logger, Level.INFO, newMaster + " is newly elected master");
                }
            } else {
                this.context.log(logger, Level.INFO, "Currently too few followers for cluster controller candidate " + this.masterCandidate + ". No current master. (" + this.followers + "/" + this.totalCount + " followers)");
            }
            Integer ourState = state.get(this.index);
            if (ourState == null) {
                throw new IllegalStateException("Database lacks data from ourselves. This should always be present.");
            }
            if (ourState.intValue() != first.getKey().intValue()) {
                this.context.log(logger, Level.INFO, "Altering our state to follow new fleet controller master candidate " + first.getKey());
                database.setMasterVote(dbContext, first.getKey());
            }
        }
        if (this.canBecomeMaster()) {
            int ourPosition = 0;
            for (Map.Entry<Integer, Integer> entry : state.entrySet()) {
                if (entry.getKey() == this.index) break;
                ++ourPosition;
            }
            if (this.nextInLineCount != ourPosition) {
                this.nextInLineCount = ourPosition;
                if (ourPosition > 0) {
                    this.context.log(logger, Level.FINE, () -> "We are now " + this.getPosition(this.nextInLineCount) + " in queue to take over being master.");
                }
            }
        }
        this.masterData = state;
        return true;
    }

    private boolean canBecomeMaster() {
        return this.index <= (this.totalCount - 1) / 2;
    }

    private boolean cannotBecomeMaster() {
        return !this.canBecomeMaster();
    }

    private static String toString(Map<Integer, Integer> data) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Integer, Integer> entry : data.entrySet()) {
            sb.append(", ").append(entry.getKey()).append(" -> ").append(entry.getValue() == null ? "null" : entry.getValue());
        }
        if (sb.length() > 2) {
            sb.delete(0, 2);
        }
        sb.insert(0, "data(");
        sb.append(")");
        return sb.toString();
    }

    private String getPosition(int val) {
        if (val < 1) {
            return "invalid(" + val + ")";
        }
        if (val == 1) {
            return "first";
        }
        if (val == 2) {
            return "second";
        }
        if (val == 3) {
            return "third";
        }
        return val + "th";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFleetData(Map<Integer, Integer> data) {
        this.context.log(logger, Level.INFO, "Got new fleet data with " + data.size() + " entries: " + data);
        Object object = this.monitor;
        synchronized (object) {
            this.nextMasterData = data;
            this.monitor.notifyAll();
        }
    }

    public void lostDatabaseConnection() {
        if (this.totalCount > 1 || this.usingZooKeeper) {
            this.context.log(logger, Level.INFO, "Clearing master data as we lost connection on node " + this.index);
            this.resetElectionProgress();
        }
    }

    private void resetElectionProgress() {
        this.masterData = null;
        this.masterCandidate = null;
        this.followers = 0;
        this.nextMasterData = null;
    }

    public void writeHtmlState(StringBuilder sb, int stateGatherCount) {
        sb.append("<h2>Master state</h2>\n");
        Integer master = this.getMaster();
        if (master != null) {
            sb.append("<p>Current cluster controller master is node " + master + ".");
            if (master == this.index) {
                sb.append(" (This node)");
            }
            sb.append("</p>");
        } else if (this.tooFewFollowersToHaveAMaster()) {
            sb.append("<p>There is currently no master. Less than half the fleet controllers (").append(this.followers).append(") are following master candidate ").append(this.masterCandidate).append(".</p>");
        } else if (this.masterGoneFromZooKeeperTime + this.masterZooKeeperCooldownPeriod > this.timer.getCurrentTimeInMillis()) {
            long time = this.timer.getCurrentTimeInMillis() - this.masterGoneFromZooKeeperTime;
            sb.append("<p>There is currently no master. Only " + time / 1000L + " seconds have passed since").append(" old master disappeared. At least " + this.masterZooKeeperCooldownPeriod / 1000L + " must pass").append(" before electing new master unless all possible master candidates are online.</p>");
        }
        if ((master == null || master != this.index) && this.nextInLineCount < stateGatherCount) {
            sb.append("<p>As we are number ").append(this.nextInLineCount).append(" in line for taking over as master, we're gathering state from nodes.</p>");
            sb.append("<p><font color=\"red\">As we are not the master, we don't know about nodes current system state or wanted states, so some statistics below may be stale. Look at status page on master for updated data.</font></p>");
        }
        if (this.cannotBecomeMaster()) {
            sb.append("<p>As lowest index fleet controller is prioritized to become master, and more than half of the fleet controllers need to be available to select a master, we can never become master.</p>");
        }
        sb.append("<p><font size=\"-1\" color=\"grey\">Master election handler internal state:").append("<br>Index: " + this.index).append("<br>Fleet controller count: " + this.totalCount).append("<br>Master candidate: " + this.masterCandidate).append("<br>Next in line count: " + this.nextInLineCount).append("<br>Followers: " + this.followers).append("<br>Master data:");
        if (this.masterData == null) {
            sb.append("null");
        } else {
            for (Map.Entry<Integer, Integer> e : this.masterData.entrySet()) {
                sb.append(" ").append(e.getKey()).append("->").append(e.getValue());
            }
        }
        sb.append("<br>Next master data:");
        if (this.nextMasterData == null) {
            sb.append("null");
        } else {
            for (Map.Entry<Integer, Integer> e : this.nextMasterData.entrySet()) {
                sb.append(" ").append(e.getKey()).append("->").append(e.getValue());
            }
        }
        sb.append("<br>Master gone from zookeeper time: " + this.masterGoneFromZooKeeperTime).append("<br>Master cooldown period: " + this.masterZooKeeperCooldownPeriod).append("</font></p>");
    }
}

