/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.status;

import com.yahoo.vespa.clustercontroller.core.status.statuspage.StatusPageResponse;
import com.yahoo.vespa.clustercontroller.core.status.statuspage.StatusPageServer;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpRequest;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpRequestHandler;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpResult;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StatusHandler
implements HttpRequestHandler {
    private static final Logger log = Logger.getLogger(StatusHandler.class.getName());
    private static final Pattern clusterListRequest = Pattern.compile("^/clustercontroller-status/v1/?$");
    private static final Pattern statusRequest = Pattern.compile("^/clustercontroller-status/v1/([^/]+)(/.*)?$");
    private final ClusterStatusPageServerSet statusClusters;

    public StatusHandler(ClusterStatusPageServerSet set) {
        this.statusClusters = set;
    }

    public HttpResult handleRequest(HttpRequest httpRequest) throws Exception {
        log.fine("Handling status request " + httpRequest);
        Matcher matcher = statusRequest.matcher(httpRequest.getPath());
        if (matcher.matches()) {
            return this.handleClusterRequest(matcher.group(1), matcher.group(2));
        }
        matcher = clusterListRequest.matcher(httpRequest.getPath());
        if (matcher.matches()) {
            return this.handleClusterListRequest();
        }
        return new HttpResult().setHttpCode(404, "No page for request '" + httpRequest.getPath() + "'.");
    }

    private HttpResult handleClusterRequest(String clusterName, String fleetControllerPath) throws InterruptedException {
        ContainerStatusPageServer statusServer = this.statusClusters.get(clusterName);
        if (statusServer == null) {
            return new HttpResult().setHttpCode(404, "No controller exists for cluster '" + clusterName + "'.");
        }
        if (fleetControllerPath == null || fleetControllerPath.isEmpty()) {
            fleetControllerPath = "/";
        }
        StatusPageServer.HttpRequest req = new StatusPageServer.HttpRequest(fleetControllerPath);
        req.setPathPrefix("/clustercontroller-status/v1");
        StatusPageResponse response = statusServer.getStatus(req);
        HttpResult result = new HttpResult();
        if (response.getResponseCode() != null) {
            result.setHttpCode(response.getResponseCode().getCode(), response.getResponseCode().getMessage());
        }
        if (response.getContentType() != null) {
            result.addHeader("Content-Type", response.getContentType());
        }
        result.setContent((Object)response.getOutputStream().toString(StandardCharsets.UTF_8));
        return result;
    }

    public HttpResult handleClusterListRequest() {
        HttpResult result = new HttpResult();
        result.addHeader("Content-Type", "text/html");
        StringWriter sw = new StringWriter();
        sw.append("<title>clusters</title>\n");
        for (String s : this.statusClusters.getAll().keySet()) {
            sw.append("<a href=\"./").append(s).append("\">").append(s).append("</a><br>").append("\n");
        }
        result.setContent((Object)sw.toString());
        return result;
    }

    public static interface ClusterStatusPageServerSet {
        public ContainerStatusPageServer get(String var1);

        public Map<String, ContainerStatusPageServer> getAll();
    }

    public static class ContainerStatusPageServer {
        StatusPageServer.HttpRequest request;
        StatusPageResponse response;
        private final Object queueMonitor = new Object();
        private final Object answerMonitor = new Object();

        public int getPort() {
            return 0;
        }

        public void shutdown() throws InterruptedException, IOException {
        }

        public void setPort(int port) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StatusPageServer.HttpRequest getCurrentHttpRequest() {
            Object object = this.answerMonitor;
            synchronized (object) {
                StatusPageServer.HttpRequest r = this.request;
                this.request = null;
                return r;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void answerCurrentStatusRequest(StatusPageResponse r) {
            Object object = this.answerMonitor;
            synchronized (object) {
                this.response = r;
                this.answerMonitor.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StatusPageResponse getStatus(StatusPageServer.HttpRequest req) throws InterruptedException {
            Object object = this.queueMonitor;
            synchronized (object) {
                Object object2 = this.answerMonitor;
                synchronized (object2) {
                    this.request = req;
                    while (this.response == null) {
                        this.answerMonitor.wait();
                    }
                    StatusPageResponse res = this.response;
                    this.response = null;
                    return res;
                }
            }
        }
    }
}

