/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.restapiv2;

import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vespa.clustercontroller.core.RemoteClusterControllerTaskScheduler;
import com.yahoo.vespa.clustercontroller.core.restapiv2.Id;
import com.yahoo.vespa.clustercontroller.core.restapiv2.Request;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.MissingUnitException;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.OperationNotSupportedForUnitException;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.StateRestApiException;
import java.util.HashMap;
import java.util.Map;

public class UnitPathResolver<T> {
    private final Map<String, RemoteClusterControllerTaskScheduler> fleetControllers;

    public UnitPathResolver(Map<String, RemoteClusterControllerTaskScheduler> fleetControllers) {
        this.fleetControllers = new HashMap<String, RemoteClusterControllerTaskScheduler>(fleetControllers);
    }

    public RemoteClusterControllerTaskScheduler resolveFleetController(String[] path) throws StateRestApiException {
        if (path.length == 0) {
            return null;
        }
        RemoteClusterControllerTaskScheduler fc = this.fleetControllers.get(path[0]);
        if (fc == null) {
            throw new MissingUnitException(path, 0);
        }
        return fc;
    }

    public Request<? extends T> visit(String[] path, Visitor<T> visitor) throws StateRestApiException {
        Id.Node node;
        Id.Service service;
        if (path.length == 0) {
            return visitor.visitGlobal();
        }
        RemoteClusterControllerTaskScheduler fc = this.fleetControllers.get(path[0]);
        if (fc == null) {
            throw new MissingUnitException(path, 0);
        }
        Id.Cluster cluster = new Id.Cluster(path[0]);
        if (path.length == 1) {
            return visitor.visitCluster(cluster);
        }
        try {
            service = new Id.Service(cluster, NodeType.get((String)path[1]));
        }
        catch (IllegalArgumentException e) {
            throw new MissingUnitException(path, 1);
        }
        if (path.length == 2) {
            return visitor.visitService(service);
        }
        try {
            node = new Id.Node(service, Integer.valueOf(path[2]));
        }
        catch (NumberFormatException e) {
            throw new MissingUnitException(path, 2);
        }
        if (path.length == 3) {
            return visitor.visitNode(node);
        }
        throw new MissingUnitException(path, 4);
    }

    public static interface Visitor<T> {
        public Request<? extends T> visitGlobal() throws StateRestApiException;

        public Request<? extends T> visitCluster(Id.Cluster var1) throws StateRestApiException;

        public Request<? extends T> visitService(Id.Service var1) throws StateRestApiException;

        public Request<? extends T> visitNode(Id.Node var1) throws StateRestApiException;
    }

    public static abstract class AbstractVisitor<T>
    implements Visitor<T> {
        private final String[] path;
        private final String failureMessage;

        public AbstractVisitor(String[] path, String failureMessage) {
            this.path = path;
            this.failureMessage = failureMessage;
        }

        private Request<T> fail() throws StateRestApiException {
            throw new OperationNotSupportedForUnitException(this.path, this.failureMessage);
        }

        @Override
        public Request<? extends T> visitGlobal() throws StateRestApiException {
            return this.fail();
        }

        @Override
        public Request<? extends T> visitCluster(Id.Cluster id) throws StateRestApiException {
            return this.fail();
        }

        @Override
        public Request<? extends T> visitService(Id.Service id) throws StateRestApiException {
            return this.fail();
        }

        @Override
        public Request<? extends T> visitNode(Id.Node id) throws StateRestApiException {
            return this.fail();
        }
    }
}

