/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vespa.clustercontroller.core.FleetControllerOptions;
import java.util.Objects;

public class FleetControllerId {
    private final String clusterName;
    private final int index;

    public static FleetControllerId fromOptions(FleetControllerOptions options) {
        return new FleetControllerId(options.clusterName, options.fleetControllerIndex);
    }

    public FleetControllerId(String clusterName, int index) {
        this.clusterName = clusterName;
        this.index = index;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public int index() {
        return this.index;
    }

    public String toString() {
        return "FleetController " + this.index + " for cluster '" + this.clusterName + "'";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FleetControllerId that = (FleetControllerId)o;
        return this.index == that.index && Objects.equals(this.clusterName, that.clusterName);
    }

    public int hashCode() {
        return Objects.hash(this.clusterName, this.index);
    }
}

