/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.jrt.Target;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.Communicator;
import com.yahoo.vespa.clustercontroller.core.ContentCluster;
import com.yahoo.vespa.clustercontroller.core.EventLog;
import com.yahoo.vespa.clustercontroller.core.GetNodeStateRequest;
import com.yahoo.vespa.clustercontroller.core.NodeEvent;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.Timer;
import com.yahoo.vespa.clustercontroller.core.hostinfo.HostInfo;
import com.yahoo.vespa.clustercontroller.core.listeners.NodeListener;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NodeStateGatherer {
    public static final Logger log = Logger.getLogger(NodeStateGatherer.class.getName());
    private final Object monitor;
    private final Timer timer;
    private final List<GetNodeStateRequest> replies = new LinkedList<GetNodeStateRequest>();
    private final NodeStateWaiter waiter = new NodeStateWaiter();
    private final EventLog eventLog;
    private int maxSlobrokDisconnectGracePeriod = 1000;
    private long nodeStateRequestTimeoutMS = 10000L;

    public NodeStateGatherer(Object monitor, Timer timer, EventLog log) {
        this.monitor = monitor;
        this.timer = timer;
        this.eventLog = log;
    }

    public void setMaxSlobrokDisconnectGracePeriod(int millisecs) {
        this.maxSlobrokDisconnectGracePeriod = millisecs;
    }

    public void setNodeStateRequestTimeout(long millisecs) {
        this.nodeStateRequestTimeoutMS = millisecs;
    }

    public boolean sendMessages(ContentCluster cluster, Communicator communicator, NodeListener listener) {
        boolean sentAnyMessages = false;
        long currentTime = this.timer.getCurrentTimeInMillis();
        for (NodeInfo info : cluster.getNodeInfos()) {
            Long requestTime = info.getLatestNodeStateRequestTime();
            if (requestTime != null && currentTime - requestTime < this.nodeStateRequestTimeoutMS || info.getTimeForNextStateRequestAttempt() > currentTime) continue;
            if (info.getRpcAddress() == null || info.isNotInSlobrok()) {
                log.log(Level.FINE, () -> "Not sending getNodeState request to node " + info.getNode() + ": Not in slobrok");
                NodeState reportedState = info.getReportedState().clone();
                if (!reportedState.getState().equals((Object)State.DOWN) && currentTime - info.lastSeenInSlobrok() > (long)this.maxSlobrokDisconnectGracePeriod || reportedState.getState().equals((Object)State.STOPPING)) {
                    log.log(Level.FINE, () -> "Setting reported state to DOWN " + (String)(reportedState.getState().equals((Object)State.STOPPING) ? "as node completed stopping." : "as node has been out of slobrok longer than " + this.maxSlobrokDisconnectGracePeriod + "."));
                    if (reportedState.getState().oneOf("iur") || !reportedState.hasDescription()) {
                        StringBuilder sb = new StringBuilder().append("Set node down as it has been out of slobrok for ").append(currentTime - info.lastSeenInSlobrok()).append(" ms which is more than the max limit of ").append(this.maxSlobrokDisconnectGracePeriod).append(" ms.");
                        reportedState.setDescription(sb.toString());
                    }
                    reportedState.setState(State.DOWN);
                    listener.handleNewNodeState(info, reportedState.clone());
                }
                info.setReportedState(reportedState, currentTime);
                continue;
            }
            communicator.getNodeState(info, this.waiter);
            sentAnyMessages = true;
        }
        return sentAnyMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processResponses(NodeListener listener) {
        boolean processedAnyResponses = false;
        long currentTime = this.timer.getCurrentTimeInMillis();
        Object object = this.monitor;
        synchronized (object) {
            for (GetNodeStateRequest req : this.replies) {
                processedAnyResponses = true;
                NodeInfo info = req.getNodeInfo();
                if (!info.isPendingGetNodeStateRequest(req)) {
                    log.log(Level.FINE, () -> "Ignoring getnodestate response from " + info.getNode() + " as request replied to is not the most recent pending request.");
                    continue;
                }
                info.removePendingGetNodeStateRequest(req);
                GetNodeStateRequest.Reply reply = req.getReply();
                if (reply.isError()) {
                    if (reply.getReturnCode() != 102) {
                        NodeState newState = this.handleError(req, info, currentTime);
                        if (newState != null) {
                            listener.handleNewNodeState(info, newState.clone());
                            info.setReportedState(newState, currentTime);
                            continue;
                        }
                        log.log(Level.FINE, () -> "Ignoring get node state error. Need to resend");
                        continue;
                    }
                    log.log(Level.FINE, () -> "Ignoring getnodestate response from " + info.getNode() + " as it was aborted by client");
                    continue;
                }
                try {
                    NodeState state = NodeState.deserialize((NodeType)info.getNode().getType(), (String)reply.getStateString());
                    if (!state.equals((Object)info.getReportedState())) {
                        listener.handleNewNodeState(info, state.clone());
                    }
                    info.setReportedState(state, currentTime);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Failed to process get node state response", e);
                    info.setReportedState(new NodeState(info.getNode().getType(), State.DOWN), currentTime);
                }
                HostInfo hostInfo = HostInfo.createHostInfo(reply.getHostInfo());
                listener.handleUpdatedHostInfo(info, hostInfo);
                info.setHostInfo(hostInfo);
            }
            this.replies.clear();
        }
        return processedAnyResponses;
    }

    private NodeState handleError(GetNodeStateRequest req, NodeInfo info, long currentTime) {
        String prefix = "Failed get node state request: ";
        NodeState newState = new NodeState(info.getNode().getType(), State.DOWN);
        if (req.getReply().getReturnCode() == 103) {
            String msg = "RPC timeout";
            if (info.getReportedState().getState().oneOf("ui")) {
                this.eventLog.addNodeOnlyEvent(NodeEvent.forBaseline(info, prefix + "RPC timeout talking to node.", NodeEvent.Type.REPORTED, currentTime), Level.INFO);
            } else if (!info.getReportedState().hasDescription() || !info.getReportedState().getDescription().equals(msg)) {
                log.log(Level.FINE, () -> "Failed to talk to node " + info + ": " + req.getReply().getReturnCode() + " " + req.getReply().getReturnMessage() + ": " + msg);
            }
            newState.setDescription(msg);
        } else if (req.getReply().getReturnCode() == 104) {
            Exception reason;
            Target target = info.lastRequestInfoConnection;
            Exception exception = reason = target == null ? null : target.getConnectionLostReason();
            if (reason != null) {
                Object msg = reason.getMessage();
                if (msg == null) {
                    msg = "(null)";
                }
                newState.setDescription((String)msg);
                if (((String)msg).equals("Connection refused")) {
                    msg = "Connection error: Connection refused";
                    if (info.getReportedState().getState().oneOf("ui")) {
                        this.eventLog.addNodeOnlyEvent(NodeEvent.forBaseline(info, prefix + (String)msg, NodeEvent.Type.REPORTED, currentTime), Level.INFO);
                    } else if (!(info.getReportedState().hasDescription() && info.getReportedState().getDescription().equals(msg) || !log.isLoggable(Level.FINE))) {
                        log.log(Level.FINE, "Failed to talk to node " + info + ": " + req.getReply().getReturnCode() + " " + req.getReply().getReturnMessage() + ": " + (String)msg);
                    }
                    newState.setState(State.DOWN);
                } else if (((String)msg).equals("jrt: Connection closed by peer") || ((String)msg).equals("Connection reset by peer")) {
                    msg = "Connection error: Closed at other end. (Node or switch likely shut down)";
                    if (info.isNotInSlobrok()) {
                        msg = (String)msg + " Node is no longer in slobrok.";
                    }
                    if (info.getReportedState().getState().oneOf("ui")) {
                        this.eventLog.addNodeOnlyEvent(NodeEvent.forBaseline(info, prefix + (String)msg, NodeEvent.Type.REPORTED, currentTime), Level.INFO);
                    } else if (!(info.getReportedState().hasDescription() && info.getReportedState().getDescription().equals(msg) || !log.isLoggable(Level.FINE))) {
                        log.log(Level.FINE, "Failed to talk to node " + info + ": " + req.getReply().getReturnCode() + " " + req.getReply().getReturnMessage() + ": " + (String)msg);
                    }
                    newState.setState(State.DOWN).setDescription((String)msg);
                } else if (((String)msg).equals("Connection timed out")) {
                    if (info.getReportedState().getState().oneOf("ui")) {
                        msg = "Connection error: Timeout";
                        this.eventLog.addNodeOnlyEvent(NodeEvent.forBaseline(info, prefix + (String)msg, NodeEvent.Type.REPORTED, currentTime), Level.INFO);
                    } else if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Failed to talk to node " + info + ": " + req.getReply().getReturnCode() + " " + req.getReply().getReturnMessage() + ": " + (String)msg);
                    }
                } else {
                    msg = "Connection error: " + reason;
                    if (info.getReportedState().getState().oneOf("ui")) {
                        this.eventLog.addNodeOnlyEvent(NodeEvent.forBaseline(info, prefix + (String)msg, NodeEvent.Type.REPORTED, currentTime), Level.WARNING);
                    } else if (!(info.getReportedState().hasDescription() && info.getReportedState().getDescription().equals(msg) || !log.isLoggable(Level.FINE))) {
                        log.log(Level.FINE, "Failed to talk to node " + info + ": " + req.getReply().getReturnCode() + " " + req.getReply().getReturnMessage() + ": " + (String)msg);
                    }
                    newState.setDescription((String)msg);
                }
            } else {
                String msg = "Connection error: Unexpected error with no reason set. Assuming it is a network issue: " + req.getReply().getReturnCode() + ": " + req.getReply().getReturnMessage();
                if (info.getReportedState().getState().oneOf("ui")) {
                    this.eventLog.addNodeOnlyEvent(NodeEvent.forBaseline(info, prefix + msg, NodeEvent.Type.REPORTED, currentTime), Level.WARNING);
                } else if (!info.getReportedState().hasDescription() || !info.getReportedState().getDescription().equals(msg)) {
                    log.log(Level.FINE, () -> "Failed to talk to node " + info + ": " + req.getReply().getReturnCode() + " " + req.getReply().getReturnMessage() + ": " + msg);
                }
                newState.setDescription(msg);
            }
        } else {
            if (req.getReply().getReturnCode() == 9999) {
                return null;
            }
            if (req.getReply().getReturnCode() == 106) {
                String msg = "no such RPC method error";
                if (info.getReportedState().getState().oneOf("ui")) {
                    this.eventLog.addNodeOnlyEvent(NodeEvent.forBaseline(info, prefix + msg, NodeEvent.Type.REPORTED, currentTime), Level.WARNING);
                } else if (!info.getReportedState().hasDescription() || !info.getReportedState().getDescription().equals(msg)) {
                    log.log(Level.FINE, () -> "Failed to talk to node " + info + ": " + req.getReply().getReturnCode() + " " + req.getReply().getReturnMessage() + ": " + msg);
                }
                newState.setState(State.DOWN).setDescription(msg + ": get node state");
            } else if (req.getReply().getReturnCode() == 75004) {
                String msg = "Node refused to answer RPC request and is likely stopping: " + req.getReply().getReturnMessage();
                if (info.getReportedState().getState().equals((Object)State.STOPPING)) {
                    log.log(Level.FINE, () -> "Failed to get node state from " + info + " because it is still shutting down.");
                } else if (info.getReportedState().getState().oneOf("ui")) {
                    this.eventLog.addNodeOnlyEvent(NodeEvent.forBaseline(info, prefix + msg, NodeEvent.Type.REPORTED, currentTime), Level.INFO);
                } else if (!info.getReportedState().hasDescription() || !info.getReportedState().getDescription().equals(msg)) {
                    log.log(Level.FINE, () -> "Failed to talk to node " + info + ": " + req.getReply().getReturnCode() + " " + req.getReply().getReturnMessage() + ": " + msg);
                }
                newState.setState(State.STOPPING).setDescription(msg);
            } else {
                String msg = "Got unexpected error, assumed to be node issue " + req.getReply().getReturnCode() + ": " + req.getReply().getReturnMessage();
                if (info.getReportedState().getState().oneOf("ui")) {
                    this.eventLog.addNodeOnlyEvent(NodeEvent.forBaseline(info, prefix + msg, NodeEvent.Type.REPORTED, currentTime), Level.WARNING);
                } else if (!info.getReportedState().hasDescription() || !info.getReportedState().getDescription().equals(msg)) {
                    log.log(Level.FINE, () -> "Failed to talk to node " + info + ": " + req.getReply().getReturnCode() + " " + req.getReply().getReturnMessage() + ": " + msg);
                }
                newState.setState(State.DOWN).setDescription(msg);
            }
        }
        return newState;
    }

    private class NodeStateWaiter
    implements Communicator.Waiter<GetNodeStateRequest> {
        private NodeStateWaiter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done(GetNodeStateRequest reply) {
            Object object = NodeStateGatherer.this.monitor;
            synchronized (object) {
                NodeStateGatherer.this.replies.add(reply);
                NodeStateGatherer.this.monitor.notifyAll();
            }
        }
    }
}

