/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vespa.clustercontroller.core.ClusterStateBundle;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.NodeResourceExhaustion;
import com.yahoo.vespa.clustercontroller.core.hostinfo.HostInfo;
import com.yahoo.vespa.clustercontroller.core.hostinfo.ResourceUsage;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ResourceExhaustionCalculator {
    private final boolean feedBlockEnabled;
    private final Map<String, Double> feedBlockLimits;
    private final double feedBlockNoiseLevel;
    private final Set<NodeAndResourceType> previouslyBlockedNodeResources;

    public ResourceExhaustionCalculator(boolean feedBlockEnabled, Map<String, Double> feedBlockLimits) {
        this.feedBlockEnabled = feedBlockEnabled;
        this.feedBlockLimits = feedBlockLimits;
        this.feedBlockNoiseLevel = 0.0;
        this.previouslyBlockedNodeResources = Collections.emptySet();
    }

    public ResourceExhaustionCalculator(boolean feedBlockEnabled, Map<String, Double> feedBlockLimits, ClusterStateBundle.FeedBlock previousFeedBlock, double feedBlockNoiseLevel) {
        this.feedBlockEnabled = feedBlockEnabled;
        this.feedBlockLimits = feedBlockLimits;
        this.feedBlockNoiseLevel = feedBlockNoiseLevel;
        this.previouslyBlockedNodeResources = previousFeedBlock != null ? previousFeedBlock.getConcreteExhaustions().stream().map(ex -> NodeAndResourceType.of(ex.node.getIndex(), ex.resourceType)).collect(Collectors.toSet()) : Collections.emptySet();
    }

    public ClusterStateBundle.FeedBlock inferContentClusterFeedBlockOrNull(Collection<NodeInfo> nodeInfos) {
        if (!this.feedBlockEnabled) {
            return null;
        }
        Set<NodeResourceExhaustion> exhaustions = this.enumerateNodeResourceExhaustionsAcrossAllNodes(nodeInfos);
        if (exhaustions.isEmpty()) {
            return null;
        }
        int maxDescriptions = 3;
        Object description = exhaustions.stream().limit(maxDescriptions).map(NodeResourceExhaustion::toExhaustionAddedDescription).collect(Collectors.joining(", "));
        if (exhaustions.size() > maxDescriptions) {
            description = (String)description + String.format(" (... and %d more)", exhaustions.size() - maxDescriptions);
        }
        return ClusterStateBundle.FeedBlock.blockedWith((String)description, exhaustions);
    }

    public Set<NodeResourceExhaustion> resourceExhaustionsFromHostInfo(NodeInfo nodeInfo, HostInfo hostInfo) {
        Set<NodeResourceExhaustion> exceedingLimit = null;
        for (Map.Entry<String, ResourceUsage> usage : hostInfo.getContentNode().getResourceUsage().entrySet()) {
            double effectiveLimit;
            double configuredLimit = this.feedBlockLimits.getOrDefault(usage.getKey(), 1.0);
            boolean wasBlocked = this.previouslyBlockedNodeResources.contains(NodeAndResourceType.of(nodeInfo.getNodeIndex(), usage.getKey()));
            double d = effectiveLimit = wasBlocked ? Math.max(configuredLimit - this.feedBlockNoiseLevel, 0.0) : configuredLimit;
            if (!(usage.getValue().getUsage() > effectiveLimit)) continue;
            if (exceedingLimit == null) {
                exceedingLimit = new LinkedHashSet<NodeResourceExhaustion>();
            }
            exceedingLimit.add(new NodeResourceExhaustion(nodeInfo.getNode(), usage.getKey(), usage.getValue(), effectiveLimit, nodeInfo.getRpcAddress()));
        }
        return exceedingLimit != null ? exceedingLimit : Collections.emptySet();
    }

    public Set<NodeResourceExhaustion> enumerateNodeResourceExhaustions(NodeInfo nodeInfo) {
        if (!nodeInfo.isStorage()) {
            return Collections.emptySet();
        }
        return this.resourceExhaustionsFromHostInfo(nodeInfo, nodeInfo.getHostInfo());
    }

    private static boolean nodeMayContributeToFeedBlocked(NodeInfo info) {
        return info.getWantedState().getState().oneOf("ur") && info.getReportedState().getState().oneOf("ui");
    }

    public Set<NodeResourceExhaustion> enumerateNodeResourceExhaustionsAcrossAllNodes(Collection<NodeInfo> nodeInfos) {
        return nodeInfos.stream().filter(info -> ResourceExhaustionCalculator.nodeMayContributeToFeedBlocked(info)).flatMap(info -> this.enumerateNodeResourceExhaustions((NodeInfo)info).stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static class NodeAndResourceType {
        public final int nodeIndex;
        public final String resourceType;

        public NodeAndResourceType(int nodeIndex, String resourceType) {
            this.nodeIndex = nodeIndex;
            this.resourceType = resourceType;
        }

        public static NodeAndResourceType of(int nodeIndex, String resourceType) {
            return new NodeAndResourceType(nodeIndex, resourceType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeAndResourceType that = (NodeAndResourceType)o;
            return this.nodeIndex == that.nodeIndex && Objects.equals(this.resourceType, that.resourceType);
        }

        public int hashCode() {
            return Objects.hash(this.nodeIndex, this.resourceType);
        }
    }
}

