/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vespa.clustercontroller.core.NodeInfo;

public abstract class ClusterStateVersionSpecificRequest {
    private final NodeInfo nodeInfo;
    private final int clusterStateVersion;
    private Reply reply;

    public ClusterStateVersionSpecificRequest(NodeInfo nodeInfo, int clusterStateVersion) {
        this.nodeInfo = nodeInfo;
        this.clusterStateVersion = clusterStateVersion;
    }

    public NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public int getClusterStateVersion() {
        return this.clusterStateVersion;
    }

    public void setReply(Reply reply) {
        this.reply = reply;
    }

    public Reply getReply() {
        return this.reply;
    }

    public static class Reply {
        final int returnCode;
        final String returnMessage;
        final int actualVersion;

        public Reply() {
            this(0, null);
        }

        public Reply(int returnCode, String returnMessage) {
            this.returnCode = returnCode;
            this.returnMessage = returnMessage;
            this.actualVersion = -1;
        }

        private Reply(int actualVersion) {
            this.returnCode = 0;
            this.returnMessage = null;
            this.actualVersion = actualVersion;
        }

        public static Reply withActualVersion(int version) {
            return new Reply(version);
        }

        public boolean isError() {
            return this.returnCode != 0;
        }

        public int getReturnCode() {
            return this.returnCode;
        }

        public String getReturnMessage() {
            return this.returnMessage;
        }

        public int getActualVersion() {
            return this.actualVersion;
        }
    }
}

