/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.rpc;

import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.jrt.slobrok.api.Mirror;
import com.yahoo.jrt.slobrok.api.SlobrokList;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vespa.clustercontroller.core.ContentCluster;
import com.yahoo.vespa.clustercontroller.core.FleetControllerContext;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.NodeLookup;
import com.yahoo.vespa.clustercontroller.core.Timer;
import com.yahoo.vespa.clustercontroller.core.listeners.NodeAddedOrRemovedListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SlobrokClient
implements NodeLookup {
    public static final Logger log = Logger.getLogger(SlobrokClient.class.getName());
    private final FleetControllerContext context;
    private final Timer timer;
    private String[] connectionSpecs;
    private Mirror mirror;
    private Supervisor supervisor;
    private boolean freshMirror = false;

    public SlobrokClient(FleetControllerContext context, Timer timer) {
        this.context = context;
        this.timer = timer;
    }

    public boolean equalsExistingSpec(String[] spec) {
        if (spec == null && this.connectionSpecs == null) {
            return true;
        }
        if (spec == null && this.connectionSpecs != null) {
            return false;
        }
        if (spec != null && this.connectionSpecs == null) {
            return false;
        }
        if (spec.length != this.connectionSpecs.length) {
            return false;
        }
        int n = spec.length;
        for (int i = 0; i < n; ++i) {
            if (spec[i].equals(this.connectionSpecs[i])) continue;
            return false;
        }
        return true;
    }

    public void setSlobrokConnectionSpecs(String[] slobrokConnectionSpecs) {
        if (this.equalsExistingSpec(slobrokConnectionSpecs)) {
            return;
        }
        this.connectionSpecs = slobrokConnectionSpecs;
        this.shutdown();
        this.supervisor = new Supervisor(new Transport("slobrok-client"));
        this.supervisor.setDropEmptyBuffers(true);
        SlobrokList slist = new SlobrokList();
        slist.setup(slobrokConnectionSpecs);
        this.mirror = new Mirror(this.supervisor, slist);
        this.freshMirror = true;
    }

    @Override
    public void shutdown() {
        if (this.supervisor != null) {
            this.supervisor.transport().shutdown().join();
        }
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    @Override
    public boolean isReady() {
        return this.mirror != null && this.mirror.ready();
    }

    @Override
    public boolean updateCluster(ContentCluster cluster, NodeAddedOrRemovedListener listener) {
        NodeInfo nodeInfo;
        if (this.mirror == null) {
            return false;
        }
        int mirrorVersion = this.mirror.updates();
        if (this.freshMirror) {
            this.freshMirror = false;
        } else if (cluster.getSlobrokGenerationCount() == mirrorVersion) {
            this.context.log(log, Level.FINEST, () -> "Slobrok still at generation count " + cluster.getSlobrokGenerationCount() + ". Not updating.");
            return false;
        }
        cluster.setSlobrokGenerationCount(0);
        Map<Node, SlobrokData> distributorRpc = this.getSlobrokData("storage/cluster." + cluster.getName() + "/distributor/*");
        Map<Node, SlobrokData> distributorMbus = this.getSlobrokData("storage/cluster." + cluster.getName() + "/distributor/*/default");
        Map<Node, SlobrokData> storageRpc = this.getSlobrokData("storage/cluster." + cluster.getName() + "/storage/*");
        Map<Node, SlobrokData> storageMbus = this.getSlobrokData("storage/cluster." + cluster.getName() + "/storage/*/default");
        TreeMap<Node, SlobrokData> slobrokNodes = new TreeMap<Node, SlobrokData>();
        for (SlobrokData data : distributorRpc.values()) {
            if (!distributorMbus.containsKey(data.node)) continue;
            slobrokNodes.put(data.node, data);
        }
        for (SlobrokData data : storageRpc.values()) {
            if (!storageMbus.containsKey(data.node)) continue;
            slobrokNodes.put(data.node, data);
        }
        LinkedList<SlobrokData> newNodes = new LinkedList<SlobrokData>();
        LinkedList<NodeInfo> missingNodeInfos = new LinkedList<NodeInfo>();
        LinkedList<SlobrokData> alteredRpcAddressNodes = new LinkedList<SlobrokData>();
        LinkedList<NodeInfo> returningNodeInfos = new LinkedList<NodeInfo>();
        this.detectNewAndMissingNodes(cluster, slobrokNodes, newNodes, missingNodeInfos, alteredRpcAddressNodes, returningNodeInfos);
        for (SlobrokData data : newNodes) {
            nodeInfo = cluster.clusterInfo().getNodeInfo(data.node);
            if (nodeInfo == null) continue;
            cluster.clusterInfo().setRpcAddress(data.node, data.rpcAddress);
            if (listener == null) continue;
            listener.handleNewNode(nodeInfo);
        }
        for (NodeInfo nodeInfo2 : missingNodeInfos) {
            nodeInfo2.markRpcAddressOutdated(this.timer);
            if (listener == null) continue;
            listener.handleMissingNode(nodeInfo2);
        }
        for (SlobrokData data : alteredRpcAddressNodes) {
            nodeInfo = cluster.clusterInfo().setRpcAddress(data.node, data.rpcAddress);
            if (listener == null) continue;
            listener.handleNewRpcAddress(nodeInfo);
        }
        for (NodeInfo nodeInfo2 : returningNodeInfos) {
            nodeInfo2.markRpcAddressLive();
            nodeInfo2.abortCurrentNodeStateRequests();
            if (listener == null) continue;
            listener.handleReturnedRpcAddress(nodeInfo2);
        }
        cluster.setSlobrokGenerationCount(mirrorVersion);
        for (NodeInfo nodeInfo2 : cluster.getNodeInfo()) {
            if (!slobrokNodes.containsKey(nodeInfo2.getNode()) || !nodeInfo2.isRpcAddressOutdated()) continue;
            this.context.log(log, Level.WARNING, "Node " + nodeInfo2 + " was tagged NOT in slobrok even though it is. It was in the following lists:" + (newNodes.contains(nodeInfo2.getNode()) ? " newNodes" : "") + (missingNodeInfos.contains(nodeInfo2) ? " missingNodes" : "") + (alteredRpcAddressNodes.contains(nodeInfo2.getNode()) ? " alteredNodes" : "") + (returningNodeInfos.contains(nodeInfo2) ? " returningNodes" : ""));
            nodeInfo2.markRpcAddressLive();
        }
        this.context.log(log, Level.FINEST, () -> "Slobrok information updated to generation " + cluster.getSlobrokGenerationCount());
        return true;
    }

    private void detectNewAndMissingNodes(ContentCluster oldCluster, Map<Node, SlobrokData> slobrokNodes, List<SlobrokData> newNodes, List<NodeInfo> missingNodeInfos, List<SlobrokData> alteredRpcAddress, List<NodeInfo> returningRpcAddressNodeInfos) {
        Iterator<NodeInfo> oldIt = oldCluster.getNodeInfo().iterator();
        Iterator<SlobrokData> newIt = slobrokNodes.values().iterator();
        NodeInfo oldNext = null;
        SlobrokData newNext = null;
        while (true) {
            if (oldNext == null && oldIt.hasNext()) {
                oldNext = oldIt.next();
            }
            if (newNext == null && newIt.hasNext()) {
                newNext = newIt.next();
            }
            if (oldNext == null && newNext == null) break;
            if (oldNext == null || newNext != null && oldNext.getNode().compareTo(newNext.node) > 0) {
                newNodes.add(newNext);
                newNext = null;
                continue;
            }
            if (newNext == null || newNext.node.compareTo(oldNext.getNode()) > 0) {
                assert (slobrokNodes.get(oldNext.getNode()) == null);
                if (!oldNext.isRpcAddressOutdated() && oldNext.getRpcAddress() != null) {
                    missingNodeInfos.add(oldNext);
                }
                oldNext = null;
                continue;
            }
            assert (newNext.rpcAddress != null);
            if (oldNext.getRpcAddress() == null || !oldNext.getRpcAddress().equals(newNext.rpcAddress)) {
                alteredRpcAddress.add(newNext);
            } else if (oldNext.isRpcAddressOutdated()) {
                returningRpcAddressNodeInfos.add(oldNext);
            }
            oldNext = null;
            newNext = null;
        }
    }

    private Map<Node, SlobrokData> getSlobrokData(String pattern) {
        TreeMap<Node, SlobrokData> result = new TreeMap<Node, SlobrokData>();
        List entries = this.mirror.lookup(pattern);
        this.context.log(log, Level.FINEST, () -> "Looking for slobrok entries with pattern '" + pattern + "'. Found " + entries.size() + " entries.");
        for (Mirror.Entry entry : entries) {
            String service;
            StringTokenizer st = new StringTokenizer(entry.getName(), "/");
            String addressType = st.nextToken();
            String cluster = st.nextToken();
            NodeType nodeType = NodeType.get((String)st.nextToken());
            Integer nodeIndex = Integer.valueOf(st.nextToken());
            String string = service = st.hasMoreTokens() ? st.nextToken() : "";
            assert (addressType.equals("storage"));
            Node n = new Node(nodeType, nodeIndex.intValue());
            result.put(n, new SlobrokData(n, entry.getSpecString()));
        }
        return result;
    }

    private static class SlobrokData {
        public Node node;
        String rpcAddress;

        SlobrokData(Node node, String rpcAddress) {
            this.node = node;
            this.rpcAddress = rpcAddress;
        }
    }
}

