/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.status.statuspage;

import java.util.ArrayList;

public class HtmlTable {
    int border = 1;
    int cellSpacing = 0;
    ArrayList<CellProperties> colProperties = new ArrayList();
    CellProperties tableProperties = new CellProperties();
    private ArrayList<Row> cells = new ArrayList();

    public HtmlTable addRow(Row r) {
        this.cells.add(r);
        return this;
    }

    public CellProperties getTableProperties() {
        return this.tableProperties;
    }

    public CellProperties getColProperties(int col) {
        while (this.colProperties.size() <= col) {
            this.colProperties.add(new CellProperties());
        }
        return this.colProperties.get(col);
    }

    private String getColor(int color) {
        Object col = Integer.toHexString(color);
        while (((String)col).length() < 6) {
            col = "0" + (String)col;
        }
        return col;
    }

    public static String escape(String s) {
        s = s.replaceAll("&", "&amp;");
        s = s.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        return s;
    }

    public int getColumnCount() {
        int cols = 0;
        ArrayList<Integer> next = new ArrayList<Integer>();
        for (Row row : this.cells) {
            int rowCount = 0;
            if (!next.isEmpty()) {
                rowCount += ((Integer)next.get(0)).intValue();
                next.remove(0);
            }
            for (Cell c : row.cells) {
                int width = 1;
                if (c.properties.colSpan != null && c.properties.colSpan > 1) {
                    width = c.properties.colSpan;
                }
                rowCount += width;
                if (c.properties.rowSpan == null || c.properties.rowSpan <= 1) continue;
                while (next.size() < c.properties.rowSpan - 1) {
                    next.add(0);
                }
                for (int i = 1; i < c.properties.rowSpan; ++i) {
                    next.set(i - 1, (Integer)next.get(i - 1) + width);
                }
            }
            cols = Math.max(cols, rowCount);
        }
        return cols;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<table border=\"").append(this.border).append("\" cellSpacing=\"").append(this.cellSpacing).append("\">\n");
        int columnCount = this.getColumnCount();
        for (Row row : this.cells) {
            sb.append("<tr>\n");
            for (int i = 0; i < row.cells.size(); ++i) {
                Cell cell = row.cells.get(i);
                CellProperties properties = new CellProperties();
                properties.add(this.tableProperties);
                if (this.colProperties.size() > i) {
                    properties.add(this.colProperties.get(i));
                }
                properties.add(row.rowProperties);
                properties.add(cell.properties);
                sb.append(row.isHeaderRow ? "<th" : "<td");
                if (properties.backgroundColor != null) {
                    sb.append(" bgcolor=\"#").append(this.getColor(properties.backgroundColor)).append('\"');
                }
                if (properties.contentAlignment != null) {
                    sb.append(" align=\"").append(properties.contentAlignment.name().toLowerCase()).append('\"');
                }
                if (properties.colSpan != null) {
                    int colSpan = properties.colSpan;
                    if (colSpan == 0) {
                        colSpan = columnCount - i;
                    }
                    sb.append(" colspan=\"").append(colSpan).append('\"');
                }
                if (properties.rowSpan != null) {
                    sb.append(" rowspan=\"").append(properties.rowSpan).append('\"');
                }
                sb.append(">");
                if (properties.allowLineBreaks != null && !properties.allowLineBreaks.booleanValue()) {
                    sb.append("<nobr>");
                }
                sb.append(cell.content);
                if (properties.allowLineBreaks != null && !properties.allowLineBreaks.booleanValue()) {
                    sb.append("</nobr>");
                }
                sb.append(row.isHeaderRow ? "</th>" : "</td>").append("\n");
            }
            sb.append("</tr>\n");
        }
        sb.append("</table>\n");
        return sb.toString();
    }

    public static class Row {
        boolean isHeaderRow;
        ArrayList<Cell> cells = new ArrayList();
        CellProperties rowProperties = new CellProperties();

        public Row addCell(Cell c) {
            this.cells.add(c);
            return this;
        }

        public Cell getLastCell() {
            return this.cells.get(this.cells.size() - 1);
        }

        Row setHeaderRow() {
            this.isHeaderRow = true;
            return this;
        }

        Row addProperties(CellProperties p) {
            this.rowProperties.add(p);
            return this;
        }
    }

    public static class Cell {
        CellProperties properties = new CellProperties();
        String content;

        Cell(String content) {
            this.content = content;
        }

        Cell addProperties(CellProperties c) {
            this.properties.add(c);
            return this;
        }
    }

    public static class CellProperties {
        Integer backgroundColor;
        Integer colSpan;
        Integer rowSpan;
        Orientation contentAlignment;
        Boolean allowLineBreaks;

        CellProperties setColSpan(Integer span) {
            this.colSpan = span;
            return this;
        }

        CellProperties setRowSpan(Integer span) {
            this.rowSpan = span;
            return this;
        }

        CellProperties setBackgroundColor(Integer bgcol) {
            this.backgroundColor = bgcol;
            return this;
        }

        CellProperties align(Orientation alignment) {
            this.contentAlignment = alignment;
            return this;
        }

        CellProperties allowLineBreaks(Boolean allow) {
            this.allowLineBreaks = allow;
            return this;
        }

        void add(CellProperties cp) {
            if (cp.backgroundColor != null) {
                this.backgroundColor = cp.backgroundColor;
            }
            if (cp.colSpan != null) {
                this.colSpan = cp.colSpan;
            }
            if (cp.rowSpan != null) {
                this.rowSpan = cp.rowSpan;
            }
            if (cp.contentAlignment != null) {
                this.contentAlignment = cp.contentAlignment;
            }
            if (cp.allowLineBreaks != null) {
                this.allowLineBreaks = cp.allowLineBreaks;
            }
        }
    }

    static enum Orientation {
        LEFT,
        CENTER,
        RIGHT;

    }
}

