/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.status;

import com.yahoo.vespa.clustercontroller.core.ClusterStateBundle;
import com.yahoo.vespa.clustercontroller.core.ClusterStateHistoryEntry;
import com.yahoo.vespa.clustercontroller.core.ContentCluster;
import com.yahoo.vespa.clustercontroller.core.EventLog;
import com.yahoo.vespa.clustercontroller.core.MasterElectionHandler;
import com.yahoo.vespa.clustercontroller.core.RealTimer;
import com.yahoo.vespa.clustercontroller.core.StateVersionTracker;
import com.yahoo.vespa.clustercontroller.core.Timer;
import com.yahoo.vespa.clustercontroller.core.status.RunDataExtractor;
import com.yahoo.vespa.clustercontroller.core.status.statuspage.StatusPageResponse;
import com.yahoo.vespa.clustercontroller.core.status.statuspage.StatusPageServer;
import com.yahoo.vespa.clustercontroller.core.status.statuspage.VdsClusterHtmlRenderer;
import java.util.TimeZone;

public class LegacyIndexPageRequestHandler
implements StatusPageServer.RequestHandler {
    private final Timer timer;
    private final ContentCluster cluster;
    private final MasterElectionHandler masterElectionHandler;
    private final StateVersionTracker stateVersionTracker;
    private final EventLog eventLog;
    private final long startedTime;
    private final RunDataExtractor data;
    private final boolean showLocalSystemStatesInLog;

    public LegacyIndexPageRequestHandler(Timer timer, boolean showLocalSystemStatesInLog, ContentCluster cluster, MasterElectionHandler masterElectionHandler, StateVersionTracker stateVersionTracker, EventLog eventLog, long startedTime, RunDataExtractor data) {
        this.timer = timer;
        this.showLocalSystemStatesInLog = showLocalSystemStatesInLog;
        this.cluster = cluster;
        this.masterElectionHandler = masterElectionHandler;
        this.stateVersionTracker = stateVersionTracker;
        this.eventLog = eventLog;
        this.startedTime = startedTime;
        this.data = data;
    }

    @Override
    public StatusPageResponse handle(StatusPageServer.HttpRequest request) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        long currentTime = this.timer.getCurrentTimeInMillis();
        StatusPageResponse response = new StatusPageResponse();
        response.setContentType("text/html");
        StringBuilder content = new StringBuilder();
        content.append("<!-- Answer to request " + request + " -->\n");
        response.writeHtmlHeader(content, this.cluster.getName() + " Cluster Controller " + this.data.getOptions().fleetControllerIndex + " Status Page");
        content.append("<p><font size=\"-1\">").append(" [ <a href=\"#config\">Current config</a>").append(" | <a href=\"#clusterstates\">Cluster states</a>").append(" | <a href=\"#eventlog\">Event log</a>").append(" ]</font></p>\n");
        content.append("<table><tr><td>UTC time when creating this page:</td><td align=\"right\">").append(RealTimer.printDateNoMilliSeconds(currentTime, tz)).append("</td></tr>");
        content.append("<tr><td>Cluster controller uptime:</td><td align=\"right\">" + RealTimer.printDuration(currentTime - this.startedTime) + "</td></tr></table>");
        if (this.masterElectionHandler.isAmongNthFirst(this.data.getOptions().stateGatherCount)) {
            this.cluster.writeHtmlState(new VdsClusterHtmlRenderer(), content, this.timer, this.stateVersionTracker.getVersionedClusterStateBundle(), this.stateVersionTracker.getAggregatedClusterStats(), this.data.getOptions().storageDistribution, this.data.getOptions(), this.eventLog);
            this.writeHtmlState(this.stateVersionTracker, content, request);
        } else {
            this.data.getOptions().writeHtmlState(content);
        }
        this.masterElectionHandler.writeHtmlState(content, this.data.getOptions().stateGatherCount);
        this.data.getOptions().writeHtmlState(content);
        this.eventLog.writeHtmlState(content, null);
        response.writeHtmlFooter(content, "");
        response.writeContent(content.toString());
        return response;
    }

    public void writeHtmlState(StateVersionTracker stateVersionTracker, StringBuilder sb, StatusPageServer.HttpRequest request) {
        boolean showLocal = this.showLocalSystemStatesInLog;
        if (request.hasQueryParameter("showlocal")) {
            showLocal = true;
        } else if (request.hasQueryParameter("hidelocal")) {
            showLocal = false;
        }
        sb.append("<h2 id=\"clusterstates\">Cluster states</h2>\n");
        LegacyIndexPageRequestHandler.writeClusterStates(sb, stateVersionTracker.getVersionedClusterStateBundle());
        if (!stateVersionTracker.getClusterStateHistory().isEmpty()) {
            TimeZone tz = TimeZone.getTimeZone("UTC");
            sb.append("<h3 id=\"clusterstatehistory\">Cluster state history</h3>\n");
            sb.append("<table border=\"1\" cellspacing=\"0\"><tr>\n").append("  <th>Creation date (").append(tz.getDisplayName(false, 0)).append(")</th>\n").append("  <th>Bucket space</th>\n").append("  <th>Cluster state</th>\n").append("</tr>\n");
            for (ClusterStateHistoryEntry historyEntry : stateVersionTracker.getClusterStateHistory()) {
                this.writeClusterStateEntry(historyEntry, sb, tz);
            }
            sb.append("</table>\n");
        }
    }

    private static void writeClusterStates(StringBuilder sb, ClusterStateBundle clusterStates) {
        sb.append("<p>Baseline cluster state:<br><code>").append(clusterStates.getBaselineClusterState().toString()).append("</code></p>\n");
        clusterStates.getDerivedBucketSpaceStates().forEach((bucketSpace, state) -> sb.append("<p>" + bucketSpace + " cluster state:<br><code>").append(state.getClusterState().toString()).append("</code></p>\n"));
    }

    private void writeClusterStateEntry(ClusterStateHistoryEntry entry, StringBuilder sb, TimeZone tz) {
        sb.append("<tr><td rowspan=\"").append(entry.getRawStates().size()).append("\">").append(RealTimer.printDate(entry.time(), tz)).append("</td>");
        for (String space : entry.getRawStates().keySet()) {
            if (!space.equals("-")) {
                sb.append("<tr>");
            }
            this.writeClusterStateTransition(space, entry.getStateString(space), entry.getDiffString(space), entry.getStateString("-"), entry.getDiffString("-"), sb);
        }
    }

    private void writeClusterStateTransition(String bucketSpace, String state, String diff, String baselineState, String baselineDiff, StringBuilder sb) {
        sb.append("<td align=\"center\">").append(bucketSpace).append("</td><td>");
        if (!bucketSpace.equals("-") && state.equals(baselineState) && diff.equals(baselineDiff)) {
            sb.append("<span style=\"color: gray\">(identical to baseline state)</span>");
        } else {
            sb.append(state);
            if (!diff.isEmpty()) {
                sb.append("<br><b>Diff</b>: ").append(diff);
            }
        }
        sb.append("</td></tr>\n");
    }
}

