/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.rpc;

import com.yahoo.compress.CompressionType;
import com.yahoo.compress.Compressor;
import com.yahoo.slime.BinaryFormat;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vespa.clustercontroller.core.AnnotatedClusterState;
import com.yahoo.vespa.clustercontroller.core.ClusterStateBundle;
import com.yahoo.vespa.clustercontroller.core.rpc.ClusterStateBundleCodec;
import com.yahoo.vespa.clustercontroller.core.rpc.EncodedClusterStateBundle;
import com.yahoo.vespa.clustercontroller.core.rpc.EnvelopedClusterStateBundleCodec;
import java.util.HashMap;

public class SlimeClusterStateBundleCodec
implements ClusterStateBundleCodec,
EnvelopedClusterStateBundleCodec {
    private static final Compressor compressor = new Compressor(CompressionType.LZ4, 3, 0.9, 1024);

    @Override
    public EncodedClusterStateBundle encode(ClusterStateBundle stateBundle) {
        Slime slime = new Slime();
        Cursor root = slime.setObject();
        if (stateBundle.deferredActivation()) {
            root.setBool("deferred-activation", stateBundle.deferredActivation());
        }
        Cursor states = root.setObject("states");
        states.setString("baseline", stateBundle.getBaselineClusterState().toString());
        Cursor spaces = states.setObject("spaces");
        stateBundle.getDerivedBucketSpaceStates().entrySet().forEach(entry -> spaces.setString((String)entry.getKey(), ((AnnotatedClusterState)entry.getValue()).toString()));
        if (stateBundle.getFeedBlock().map(fb -> fb.blockFeedInCluster()).orElse(false).booleanValue()) {
            Cursor feedBlock = root.setObject("feed-block");
            feedBlock.setBool("block-feed-in-cluster", true);
            feedBlock.setString("description", stateBundle.getFeedBlock().get().getDescription());
        }
        byte[] serialized = BinaryFormat.encode((Slime)slime);
        Compressor.Compression compression = compressor.compress(serialized);
        return EncodedClusterStateBundle.fromCompressionBuffer(compression);
    }

    @Override
    public ClusterStateBundle decode(EncodedClusterStateBundle encodedClusterStateBundle) {
        byte[] uncompressed = compressor.decompress(encodedClusterStateBundle.getCompression());
        Slime slime = BinaryFormat.decode((byte[])uncompressed);
        Cursor root = slime.get();
        Inspector states = root.field("states");
        ClusterState baseline = ClusterState.stateFromString((String)states.field("baseline").asString());
        Inspector spaces = states.field("spaces");
        HashMap<String, AnnotatedClusterState> derivedStates = new HashMap<String, AnnotatedClusterState>();
        spaces.traverse((key, value) -> derivedStates.put(key, AnnotatedClusterState.withoutAnnotations(ClusterState.stateFromString((String)value.asString()))));
        boolean deferredActivation = root.field("deferred-activation").asBool();
        ClusterStateBundle.FeedBlock feedBlock = null;
        Inspector fb = root.field("feed-block");
        if (fb.valid() && fb.field("block-feed-in-cluster").asBool()) {
            feedBlock = ClusterStateBundle.FeedBlock.blockedWithDescription(fb.field("description").asString());
        }
        return ClusterStateBundle.of(AnnotatedClusterState.withoutAnnotations(baseline), derivedStates, feedBlock, deferredActivation);
    }

    @Override
    public byte[] encodeWithEnvelope(ClusterStateBundle stateBundle) {
        EncodedClusterStateBundle toEnvelope = this.encode(stateBundle);
        Slime slime = new Slime();
        Cursor root = slime.setObject();
        root.setLong("compression-type", (long)toEnvelope.getCompression().type().getCode());
        root.setLong("uncompressed-size", (long)toEnvelope.getCompression().uncompressedSize());
        root.setData("data", toEnvelope.getCompression().data());
        return BinaryFormat.encode((Slime)slime);
    }

    @Override
    public ClusterStateBundle decodeWithEnvelope(byte[] encodedClusterStateBundle) {
        Slime slime = BinaryFormat.decode((byte[])encodedClusterStateBundle);
        Cursor root = slime.get();
        CompressionType compressionType = CompressionType.valueOf((byte)((byte)root.field("compression-type").asLong()));
        int uncompressedSize = (int)root.field("uncompressed-size").asLong();
        byte[] data = root.field("data").asData();
        return this.decode(EncodedClusterStateBundle.fromCompressionBuffer(new Compressor.Compression(compressionType, uncompressedSize, data)));
    }
}

