/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vespa.clustercontroller.core.ClusterStateBundle;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.NodeResourceExhaustion;
import com.yahoo.vespa.clustercontroller.core.hostinfo.ContentNode;
import com.yahoo.vespa.clustercontroller.core.hostinfo.ResourceUsage;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ResourceUsageStats {
    private final double maxDiskUtilization;
    private final double maxMemoryUtilization;
    private final int nodesAboveLimit;
    private static final String diskResource = "disk";
    private static final String memoryResource = "memory";

    public ResourceUsageStats() {
        this.maxDiskUtilization = 0.0;
        this.maxMemoryUtilization = 0.0;
        this.nodesAboveLimit = 0;
    }

    public ResourceUsageStats(double maxDiskUtilization, double maxMemoryUtilization, int nodesAboveLimit) {
        this.maxDiskUtilization = maxDiskUtilization;
        this.maxMemoryUtilization = maxMemoryUtilization;
        this.nodesAboveLimit = nodesAboveLimit;
    }

    public double getMaxDiskUtilization() {
        return this.maxDiskUtilization;
    }

    public double getMaxMemoryUtilization() {
        return this.maxMemoryUtilization;
    }

    public int getNodesAboveLimit() {
        return this.nodesAboveLimit;
    }

    public static ResourceUsageStats calculateFrom(Collection<NodeInfo> nodeInfos, Map<String, Double> feedBlockLimits, Optional<ClusterStateBundle.FeedBlock> feedBlock) {
        double maxDiskUsage = 0.0;
        double maxMemoryUsage = 0.0;
        for (NodeInfo info : nodeInfos) {
            if (!info.isStorage()) continue;
            ContentNode node = info.getHostInfo().getContentNode();
            maxDiskUsage = Double.max(maxDiskUsage, ResourceUsageStats.resourceUsageOf(diskResource, node));
            maxMemoryUsage = Double.max(maxMemoryUsage, ResourceUsageStats.resourceUsageOf(memoryResource, node));
        }
        return new ResourceUsageStats(maxDiskUsage / ResourceUsageStats.limitOf(diskResource, feedBlockLimits), maxMemoryUsage / ResourceUsageStats.limitOf(memoryResource, feedBlockLimits), ResourceUsageStats.calculateNodesAboveLimit(feedBlock));
    }

    private static double resourceUsageOf(String type, ContentNode node) {
        Optional<ResourceUsage> result = node.resourceUsageOf(type);
        return result.isPresent() ? result.get().getUsage() : 0.0;
    }

    private static int calculateNodesAboveLimit(Optional<ClusterStateBundle.FeedBlock> feedBlock) {
        if (feedBlock.isEmpty()) {
            return 0;
        }
        Set<NodeResourceExhaustion> exhaustions = feedBlock.get().getConcreteExhaustions();
        return (int)exhaustions.stream().map(resource -> resource.node).distinct().count();
    }

    private static double limitOf(String type, Map<String, Double> limits) {
        Double result = limits.get(type);
        return result != null ? result : 1.0;
    }
}

