/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vespa.clustercontroller.core.ClusterStateBundle;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.NodeResourceExhaustion;
import com.yahoo.vespa.clustercontroller.core.hostinfo.HostInfo;
import com.yahoo.vespa.clustercontroller.core.hostinfo.ResourceUsage;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ResourceExhaustionCalculator {
    private final boolean feedBlockEnabled;
    private final Map<String, Double> feedBlockLimits;

    public ResourceExhaustionCalculator(boolean feedBlockEnabled, Map<String, Double> feedBlockLimits) {
        this.feedBlockEnabled = feedBlockEnabled;
        this.feedBlockLimits = feedBlockLimits;
    }

    public ClusterStateBundle.FeedBlock inferContentClusterFeedBlockOrNull(Collection<NodeInfo> nodeInfos) {
        if (!this.feedBlockEnabled) {
            return null;
        }
        Set<NodeResourceExhaustion> exhaustions = this.enumerateNodeResourceExhaustionsAcrossAllNodes(nodeInfos);
        if (exhaustions.isEmpty()) {
            return null;
        }
        int maxDescriptions = 3;
        Object description = exhaustions.stream().limit(maxDescriptions).map(NodeResourceExhaustion::toExhaustionAddedDescription).collect(Collectors.joining(", "));
        if (exhaustions.size() > maxDescriptions) {
            description = (String)description + String.format(" (... and %d more)", exhaustions.size() - maxDescriptions);
        }
        return ClusterStateBundle.FeedBlock.blockedWith((String)description, exhaustions);
    }

    public Set<NodeResourceExhaustion> resourceExhaustionsFromHostInfo(NodeInfo nodeInfo, HostInfo hostInfo) {
        Set<NodeResourceExhaustion> exceedingLimit = null;
        for (Map.Entry<String, ResourceUsage> usage : hostInfo.getContentNode().getResourceUsage().entrySet()) {
            double limit = this.feedBlockLimits.getOrDefault(usage.getKey(), 1.0);
            if (!(usage.getValue().getUsage() > limit)) continue;
            if (exceedingLimit == null) {
                exceedingLimit = new LinkedHashSet<NodeResourceExhaustion>();
            }
            exceedingLimit.add(new NodeResourceExhaustion(nodeInfo.getNode(), usage.getKey(), usage.getValue(), limit, nodeInfo.getRpcAddress()));
        }
        return exceedingLimit != null ? exceedingLimit : Collections.emptySet();
    }

    public Set<NodeResourceExhaustion> enumerateNodeResourceExhaustions(NodeInfo nodeInfo) {
        if (!nodeInfo.isStorage()) {
            return Collections.emptySet();
        }
        return this.resourceExhaustionsFromHostInfo(nodeInfo, nodeInfo.getHostInfo());
    }

    public Set<NodeResourceExhaustion> enumerateNodeResourceExhaustionsAcrossAllNodes(Collection<NodeInfo> nodeInfos) {
        return nodeInfos.stream().flatMap(info -> this.enumerateNodeResourceExhaustions((NodeInfo)info).stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

