/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.jrt.Spec;
import com.yahoo.vespa.clustercontroller.core.ClusterStateBundle;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.NodeResourceExhaustion;
import com.yahoo.vespa.clustercontroller.core.hostinfo.HostInfo;
import com.yahoo.vespa.clustercontroller.core.hostinfo.ResourceUsage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ResourceExhaustionCalculator {
    private final boolean feedBlockEnabled;
    private final Map<String, Double> feedBlockLimits;

    public ResourceExhaustionCalculator(boolean feedBlockEnabled, Map<String, Double> feedBlockLimits) {
        this.feedBlockEnabled = feedBlockEnabled;
        this.feedBlockLimits = feedBlockLimits;
    }

    public ClusterStateBundle.FeedBlock inferContentClusterFeedBlockOrNull(Collection<NodeInfo> nodeInfos) {
        if (!this.feedBlockEnabled) {
            return null;
        }
        List<NodeResourceExhaustion> exhaustions = this.enumerateNodeResourceExhaustionsAcrossAllNodes(nodeInfos);
        if (exhaustions.isEmpty()) {
            return null;
        }
        int maxDescriptions = 3;
        Object description = exhaustions.stream().limit(maxDescriptions).map(ResourceExhaustionCalculator::formatNodeResourceExhaustion).collect(Collectors.joining(", "));
        if (exhaustions.size() > maxDescriptions) {
            description = (String)description + String.format(" (... and %d more)", exhaustions.size() - maxDescriptions);
        }
        return ClusterStateBundle.FeedBlock.blockedWithDescription((String)description);
    }

    private static String formatNodeResourceExhaustion(NodeResourceExhaustion n) {
        return String.format("%s%s on node %d [%s] (%.3g > %.3g)", n.resourceType, n.resourceUsage.getName() != null ? ":" + n.resourceUsage.getName() : "", n.node.getIndex(), ResourceExhaustionCalculator.inferHostnameFromRpcAddress(n.rpcAddress), n.resourceUsage.getUsage(), n.limit);
    }

    private static String inferHostnameFromRpcAddress(String rpcAddress) {
        if (rpcAddress == null) {
            return "unknown hostname";
        }
        Spec spec = new Spec(rpcAddress);
        if (spec.malformed()) {
            return "unknown hostname";
        }
        return spec.host();
    }

    public List<NodeResourceExhaustion> resourceExhaustionsFromHostInfo(NodeInfo nodeInfo, HostInfo hostInfo) {
        List<NodeResourceExhaustion> exceedingLimit = null;
        for (Map.Entry<String, ResourceUsage> usage : hostInfo.getContentNode().getResourceUsage().entrySet()) {
            double limit = this.feedBlockLimits.getOrDefault(usage.getKey(), 1.0);
            if (!(usage.getValue().getUsage() > limit)) continue;
            if (exceedingLimit == null) {
                exceedingLimit = new ArrayList<NodeResourceExhaustion>();
            }
            exceedingLimit.add(new NodeResourceExhaustion(nodeInfo.getNode(), usage.getKey(), usage.getValue(), limit, nodeInfo.getRpcAddress()));
        }
        return exceedingLimit != null ? exceedingLimit : Collections.emptyList();
    }

    public List<NodeResourceExhaustion> enumerateNodeResourceExhaustions(NodeInfo nodeInfo) {
        if (!nodeInfo.isStorage()) {
            return Collections.emptyList();
        }
        return this.resourceExhaustionsFromHostInfo(nodeInfo, nodeInfo.getHostInfo());
    }

    public List<NodeResourceExhaustion> enumerateNodeResourceExhaustionsAcrossAllNodes(Collection<NodeInfo> nodeInfos) {
        return nodeInfos.stream().flatMap(info -> this.enumerateNodeResourceExhaustions((NodeInfo)info).stream()).collect(Collectors.toList());
    }
}

