/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vdslib.distribution.ConfiguredNode;
import com.yahoo.vdslib.distribution.Distribution;
import com.yahoo.vdslib.distribution.Group;
import com.yahoo.vdslib.distribution.GroupVisitor;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class GroupAvailabilityCalculator {
    private final Distribution distribution;
    private final double minNodeRatioPerGroup;
    private final int safeMaintenanceGroupThreshold;
    private List<Integer> nodesSafelySetToMaintenance;

    private GroupAvailabilityCalculator(Distribution distribution, double minNodeRatioPerGroup, int safeMaintenanceGroupThreshold, List<Integer> nodesSafelySetToMaintenance) {
        this.distribution = distribution;
        this.minNodeRatioPerGroup = minNodeRatioPerGroup;
        this.safeMaintenanceGroupThreshold = safeMaintenanceGroupThreshold;
        this.nodesSafelySetToMaintenance = nodesSafelySetToMaintenance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static boolean isFlatCluster(Group root) {
        return root.isLeafGroup();
    }

    public Result calculate(ClusterState state) {
        if (this.distribution == null) {
            return new Result();
        }
        if (GroupAvailabilityCalculator.isFlatCluster(this.distribution.getRootGroup())) {
            return new Result();
        }
        InsufficientAvailabilityGroupVisitor visitor = new InsufficientAvailabilityGroupVisitor(state, this.nodesSafelySetToMaintenance, this.safeMaintenanceGroupThreshold);
        this.distribution.visitGroups((GroupVisitor)visitor);
        return visitor.result();
    }

    public Set<Integer> nodesThatShouldBeDown(ClusterState state) {
        return this.calculate(state).nodesThatShouldBeDown();
    }

    public static class Result {
        private final Set<Integer> shouldBeMaintained;
        private final Set<Integer> shouldBeDown;

        public Result() {
            this(Set.of(), Set.of());
        }

        public Result(Set<Integer> shouldBeMaintained, Set<Integer> shouldBeDown) {
            this.shouldBeMaintained = Set.copyOf(shouldBeMaintained);
            this.shouldBeDown = Set.copyOf(shouldBeDown);
        }

        public Set<Integer> nodesThatShouldBeMaintained() {
            return this.shouldBeMaintained;
        }

        public Set<Integer> nodesThatShouldBeDown() {
            return this.shouldBeDown;
        }
    }

    private class InsufficientAvailabilityGroupVisitor
    implements GroupVisitor {
        private final Set<Integer> implicitlyMaintained = new HashSet<Integer>();
        private final Set<Integer> implicitlyDown = new HashSet<Integer>();
        private final ClusterState clusterState;
        private final Set<Integer> nodesSafelySetToMaintenance;
        private final int safeMaintenanceGroupThreshold;

        public InsufficientAvailabilityGroupVisitor(ClusterState clusterState, List<Integer> nodesSafelySetToMaintenance, int safeMaintenanceGroupThreshold) {
            this.clusterState = clusterState;
            this.nodesSafelySetToMaintenance = Set.copyOf(nodesSafelySetToMaintenance);
            this.safeMaintenanceGroupThreshold = safeMaintenanceGroupThreshold;
        }

        private boolean nodeIsAvailableInState(int index, String states) {
            return this.clusterState.getNodeState(new Node(NodeType.STORAGE, index)).getState().oneOf(states);
        }

        private Stream<ConfiguredNode> availableNodesIn(Group g) {
            return g.getNodes().stream().filter(n -> this.nodeIsAvailableInState(n.index(), "uim"));
        }

        private Stream<ConfiguredNode> candidateNodesForSettingDown(Group g) {
            return g.getNodes().stream().filter(n -> this.nodeIsAvailableInState(n.index(), "ui"));
        }

        private Stream<ConfiguredNode> candidateNodesForSettingMaintenance(Group g) {
            return g.getNodes().stream().filter(n -> this.nodeIsAvailableInState(n.index(), "uird"));
        }

        private double computeGroupAvailability(Group g) {
            long availableNodes = this.availableNodesIn(g).count();
            return (double)availableNodes / (double)g.getNodes().size();
        }

        private int computeNodesSafelySetToMaintenance(Group group) {
            Set nodesInGroupSafelySetToMaintenance = group.getNodes().stream().filter(configuredNode -> this.nodesSafelySetToMaintenance.contains(configuredNode.index())).collect(Collectors.toSet());
            return nodesInGroupSafelySetToMaintenance.size();
        }

        private void markAllAvailableGroupNodeIndicesAsDown(Group group) {
            this.candidateNodesForSettingDown(group).forEach(n -> this.implicitlyDown.add(n.index()));
        }

        private void markAllAvailableGroupNodeIndicesAsMaintained(Group group) {
            this.candidateNodesForSettingMaintenance(group).forEach(n -> this.implicitlyMaintained.add(n.index()));
        }

        public boolean visitGroup(Group group) {
            if (group.isLeafGroup()) {
                if (this.safeMaintenanceGroupThreshold > 0 && this.computeNodesSafelySetToMaintenance(group) >= this.safeMaintenanceGroupThreshold) {
                    this.markAllAvailableGroupNodeIndicesAsMaintained(group);
                } else if (this.computeGroupAvailability(group) < GroupAvailabilityCalculator.this.minNodeRatioPerGroup) {
                    this.markAllAvailableGroupNodeIndicesAsDown(group);
                }
            }
            return true;
        }

        Result result() {
            HashSet<Integer> intersection = new HashSet<Integer>(this.implicitlyMaintained);
            intersection.retainAll(this.implicitlyDown);
            if (intersection.size() > 0) {
                throw new IllegalStateException("Nodes implicitly both maintenance and down: " + intersection);
            }
            return new Result(this.implicitlyMaintained, this.implicitlyDown);
        }
    }

    public static class Builder {
        private Distribution distribution;
        private double minNodeRatioPerGroup = 1.0;
        private int safeMaintenanceGroupThreshold = 2;
        private List<Integer> nodesSafelySetToMaintenance = new ArrayList<Integer>();

        Builder withDistribution(Distribution distribution) {
            this.distribution = distribution;
            return this;
        }

        Builder withMinNodeRatioPerGroup(double minRatio) {
            this.minNodeRatioPerGroup = minRatio;
            return this;
        }

        Builder withSafeMaintenanceGroupThreshold(int safeMaintenanceGroupThreshold) {
            this.safeMaintenanceGroupThreshold = safeMaintenanceGroupThreshold;
            return this;
        }

        Builder withNodesSafelySetToMaintenance(List<Integer> nodesSafelySetToMaintenance) {
            this.nodesSafelySetToMaintenance.addAll(nodesSafelySetToMaintenance);
            return this;
        }

        GroupAvailabilityCalculator build() {
            return new GroupAvailabilityCalculator(this.distribution, this.minNodeRatioPerGroup, this.safeMaintenanceGroupThreshold, this.nodesSafelySetToMaintenance);
        }
    }
}

