/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vespa.clustercontroller.core.ClusterStateBundle;
import com.yahoo.vespa.clustercontroller.core.ContentCluster;
import com.yahoo.vespa.clustercontroller.core.MasterInterface;
import com.yahoo.vespa.clustercontroller.core.listeners.NodeAddedOrRemovedListener;
import com.yahoo.vespa.clustercontroller.core.listeners.NodeStateOrHostInfoChangeHandler;
import java.time.Instant;
import java.util.Optional;

public abstract class RemoteClusterControllerTask {
    private final Object monitor = new Object();
    private boolean completed = false;

    public abstract void doRemoteFleetControllerTask(Context var1);

    public boolean hasVersionAckDependency() {
        return false;
    }

    public boolean isFailed() {
        return false;
    }

    public void handleFailure(Failure failure) {
    }

    public Optional<Instant> getDeadline() {
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompleted() {
        Object object = this.monitor;
        synchronized (object) {
            return this.completed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCompleted() {
        Object object = this.monitor;
        synchronized (object) {
            this.completed = true;
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion() {
        Object object = this.monitor;
        synchronized (object) {
            while (!this.completed) {
                try {
                    this.monitor.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class Failure {
        private final FailureCondition condition;
        private final String message;

        private Failure(FailureCondition condition, String message) {
            this.condition = condition;
            this.message = message;
        }

        public static Failure of(FailureCondition condition, String message) {
            return new Failure(condition, message);
        }

        public static Failure of(FailureCondition condition) {
            return new Failure(condition, "");
        }

        public FailureCondition getCondition() {
            return this.condition;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static enum FailureCondition {
        LEADERSHIP_LOST,
        DEADLINE_EXCEEDED;

    }

    public static class Context {
        public ContentCluster cluster;
        public ClusterState currentConsolidatedState;
        public ClusterStateBundle publishedClusterStateBundle;
        public MasterInterface masterInfo;
        public NodeStateOrHostInfoChangeHandler nodeStateOrHostInfoChangeHandler;
        public NodeAddedOrRemovedListener nodeAddedOrRemovedListener;
    }
}

